/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.springmvc;

import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.springmvc.controller.DocumentationController;
import com.wordnik.swagger.core.Api;
import com.wordnik.swagger.core.DocumentationEndPoint;
import java.lang.reflect.AnnotatedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MvcApiResource {
    private static final Logger log = LoggerFactory.getLogger(MvcApiResource.class);
    private final HandlerMethod handlerMethod;
    private final Class<?> controllerClass;
    private final SwaggerConfiguration configuration;

    public MvcApiResource(HandlerMethod handlerMethod, SwaggerConfiguration configuration) {
        this.handlerMethod = handlerMethod;
        this.configuration = configuration;
        this.controllerClass = ClassUtils.getUserClass((Class)handlerMethod.getBeanType());
    }

    public DocumentationEndPoint describeAsEndpoint() {
        DocumentationEndPoint endPoint = new DocumentationEndPoint(this.getControllerUri(), this.getApiDescription());
        return endPoint;
    }

    public ControllerDocumentation createEmptyApiDocumentation() {
        String resourcePath = this.getControllerUri();
        if (resourcePath == null) {
            return null;
        }
        return this.configuration.newDocumentation(this);
    }

    private String getApiDescription() {
        Api apiAnnotation = this.controllerClass.getAnnotation(Api.class);
        if (apiAnnotation == null) {
            return null;
        }
        return apiAnnotation.description();
    }

    public String getControllerUri() {
        String requestUri = this.resolveRequestUri(this.controllerClass);
        if (requestUri == null) {
            log.info("Class {} has handler methods, but no class-level @RequestMapping. Continue with method-level {}", (Object)this.controllerClass.getName(), (Object)this.handlerMethod.getMethod().getName());
            requestUri = this.resolveRequestUri(this.handlerMethod.getMethod());
            if (requestUri == null) {
                log.warn("Unable to resolve the uri for class {} and method {}. No documentation will be generated", (Object)this.controllerClass.getName(), (Object)this.handlerMethod.getMethod().getName());
                return null;
            }
        }
        return requestUri;
    }

    protected String resolveRequestUri(AnnotatedElement annotatedElement) {
        RequestMapping requestMapping = annotatedElement.getAnnotation(RequestMapping.class);
        if (requestMapping == null) {
            log.info("Class {} has no @RequestMapping", (Object)annotatedElement);
            return null;
        }
        String[] requestUris = requestMapping.value();
        if (requestUris == null || requestUris.length == 0) {
            log.info("Class {} contains a @RequestMapping, but could not resolve the uri", (Object)annotatedElement);
            return null;
        }
        if (requestUris.length > 1) {
            log.info("Class {} contains a @RequestMapping with multiple uri's. Only the first one will be documented.", (Object)annotatedElement);
        }
        return requestUris[0];
    }

    public String toString() {
        return "ApiResource for " + this.controllerClass.getSimpleName() + " at " + this.getControllerUri();
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public boolean isInternalResource() {
        return this.controllerClass == DocumentationController.class;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }
}

