/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeTrace;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittySecurityUtil;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyProxy {
    private static Log log = LogFactory.getLog(WikittyProxy.class);
    protected static TimeTrace timeTrace = new TimeTrace();
    protected WikittyServiceEnhanced wikittyService;
    protected String securityToken;

    public WikittyProxy() {
    }

    public WikittyProxy(ApplicationConfig config) {
        if (config != null) {
            long timeToLogInfo = config.getOptionAsInt(WikittyConfig.WikittyOption.WIKITTY_PROXY_TIME_TO_LOG_INFO.getKey());
            long timeToLogWarn = config.getOptionAsInt(WikittyConfig.WikittyOption.WIKITTY_PROXY_TIME_TO_LOG_WARN.getKey());
            timeTrace.setTimeToLogInfo(timeToLogInfo);
            timeTrace.setTimeToLogWarn(timeToLogWarn);
        }
    }

    public WikittyProxy(WikittyService wikittyService) {
        this();
        this.setWikittyService(wikittyService);
    }

    public WikittyProxy(ApplicationConfig config, WikittyService wikittyService) {
        this(config);
        this.setWikittyService(wikittyService);
    }

    public static TimeTrace getTimeTrace() {
        return timeTrace;
    }

    public static Map<String, TimeTrace.CallStat> getCallCount() {
        return timeTrace.getCallCount();
    }

    public void login(String login, String password) {
        long start = TimeTrace.getTime();
        String result = this.wikittyService.login(login, password);
        this.setSecurityToken(result);
        timeTrace.add(start, "login");
    }

    public void logout() {
        long start = TimeTrace.getTime();
        this.wikittyService.logout(this.securityToken);
        timeTrace.add(start, "logout");
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public WikittyService getWikittyService() {
        return this.wikittyService.getDelegate();
    }

    public void setWikittyService(WikittyService wikittyService) {
        this.wikittyService = new WikittyServiceEnhanced(wikittyService);
    }

    public <E extends BusinessEntity> E cast(BusinessEntity source, Class<E> target) {
        long start = TimeTrace.getTime();
        E result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, target, ((BusinessEntityImpl)source).getWikitty());
        timeTrace.add(start, "cast");
        return result;
    }

    public <E extends BusinessEntity> E store(E e) {
        Wikitty w = ((BusinessEntityImpl)e).getWikitty();
        w = this.store(w);
        return e;
    }

    public Wikitty store(Wikitty w) {
        long start = TimeTrace.getTime();
        WikittyEvent resp = this.wikittyService.store(this.securityToken, w);
        resp.update(w);
        timeTrace.add(start, "store");
        return w;
    }

    public <E extends BusinessEntity> List<E> store(List<E> objets) {
        long start = TimeTrace.getTime();
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(objets.size());
        for (BusinessEntity e : objets) {
            Wikitty w = ((BusinessEntityImpl)e).getWikitty();
            wikitties.add(w);
        }
        WikittyEvent resp = this.wikittyService.store(this.securityToken, wikitties);
        for (Wikitty w : wikitties) {
            resp.update(w);
        }
        timeTrace.add(start, "store<list>");
        return objets;
    }

    public List<Wikitty> storeWikitty(List<Wikitty> wikitties) {
        long start = TimeTrace.getTime();
        WikittyEvent resp = this.wikittyService.store(this.securityToken, wikitties);
        for (Wikitty w : wikitties) {
            resp.update(w);
        }
        timeTrace.add(start, "storeWikitty<list>");
        return wikitties;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id, boolean checkExtension) {
        try {
            long start = TimeTrace.getTime();
            Object result = null;
            if (id != null) {
                HashSet<String> extNames = null;
                Wikitty wikitty = this.wikittyService.restore(this.securityToken, id);
                if (wikitty != null) {
                    if (checkExtension) {
                        extNames = new HashSet<String>(wikitty.getExtensionNames());
                    }
                    result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
                    if (checkExtension) {
                        BusinessEntityImpl b = result;
                        Collection<WikittyExtension> BusinessEntityStaticExtensions = b.getStaticExtensions();
                        for (WikittyExtension ext : BusinessEntityStaticExtensions) {
                            String extensionName = ext.getName();
                            if (extNames.contains(extensionName)) continue;
                            result = null;
                            break;
                        }
                    }
                }
            }
            timeTrace.add(start, "restore<Business>");
            return result;
        }
        catch (SecurityException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't restore wikitty", eee);
        }
    }

    public Wikitty restore(String id) {
        long start = TimeTrace.getTime();
        Wikitty result = null;
        if (id != null) {
            result = this.wikittyService.restore(this.securityToken, id);
        }
        timeTrace.add(start, "restore");
        return result;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id) {
        E result = this.restore(clazz, id, false);
        return result;
    }

    public List<Wikitty> restore(List<String> id) {
        long start = TimeTrace.getTime();
        List<Wikitty> result = this.wikittyService.restore(this.securityToken, id);
        timeTrace.add(start, "restoreWikitty<list>");
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id, boolean checkExtension) {
        long start = TimeTrace.getTime();
        List<Wikitty> wikitties = this.wikittyService.restore(this.securityToken, id);
        ArrayList<E> result = new ArrayList<E>();
        for (Wikitty w : wikitties) {
            HashSet<String> extNames = null;
            if (checkExtension) {
                extNames = new HashSet<String>(w.getExtensionNames());
            }
            E dto = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, w);
            if (checkExtension) {
                BusinessEntityImpl b = (BusinessEntityImpl)dto;
                for (WikittyExtension ext : b.getStaticExtensions()) {
                    if (extNames.contains(ext.getName())) continue;
                    result = null;
                    break;
                }
                if (result == null) break;
            }
            result.add(dto);
        }
        timeTrace.add(start, "restore<list>");
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id) {
        List<E> result = this.restore(clazz, id, false);
        return result;
    }

    public void delete(String id) {
        long start = TimeTrace.getTime();
        this.wikittyService.delete(this.securityToken, id);
        timeTrace.add(start, "delete");
    }

    public void delete(Collection<String> ids) {
        long start = TimeTrace.getTime();
        this.wikittyService.delete(this.securityToken, ids);
        timeTrace.add(start, "delete<list>");
    }

    public <E extends BusinessEntityImpl> PagedResult<E> findAllByExample(E e, int firstIndex, int endIndex, String ... fieldFacet) {
        long start = TimeTrace.getTime();
        Criteria criteria = Search.query(e.getWikitty()).criteria().setFirstIndex(firstIndex).setEndIndex(endIndex).setFacetField(fieldFacet);
        PagedResult<String> pagedResult = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        PagedResult<?> result = pagedResult.cast(this, e.getClass(), true);
        timeTrace.add(start, "findAllByExample<limit>");
        return result;
    }

    public <E extends BusinessEntityImpl> E findByExample(E e) {
        long start = TimeTrace.getTime();
        Criteria criteria = Search.query(e.getWikitty()).criteria();
        String id = this.wikittyService.findByCriteria(this.securityToken, criteria);
        BusinessEntityImpl result = null;
        if (id != null) {
            Wikitty w = this.wikittyService.restore(this.securityToken, id);
            result = (BusinessEntityImpl)WikittyUtil.newInstance(this.securityToken, this.wikittyService, e.getClass(), w);
        }
        timeTrace.add(start, "findByExample");
        return (E)result;
    }

    public <E extends BusinessEntity> PagedResult<E> findAllByCriteria(Class<E> clazz, Criteria criteria) {
        Criteria serviceCriteria;
        Search search;
        long start = TimeTrace.getTime();
        BusinessEntityImpl sample = (BusinessEntityImpl)WikittyUtil.newInstance(clazz);
        Wikitty wikitty = sample.getWikitty();
        Collection<String> extensions = wikitty.getExtensionNames();
        if (criteria == null) {
            search = Search.query();
            search = search.eq(Element.ELT_EXTENSION, extensions);
            serviceCriteria = search.criteria();
        } else {
            List<String> sortDescending;
            List<String> sortAscending;
            List<Criteria> facetCriteria;
            search = Search.query(criteria);
            search = search.eq(Element.ELT_EXTENSION, extensions);
            serviceCriteria = search.criteria(criteria.getName());
            serviceCriteria.setFirstIndex(criteria.getFirstIndex());
            serviceCriteria.setEndIndex(criteria.getEndIndex());
            List<String> facetField = criteria.getFacetField();
            if (facetField != null) {
                String[] facetFieldTab = new String[facetField.size()];
                serviceCriteria.setFacetField(facetField.toArray(facetFieldTab));
            }
            if ((facetCriteria = criteria.getFacetCriteria()) != null) {
                Criteria[] facetCriteriaTab = new Criteria[facetCriteria.size()];
                serviceCriteria.setFacetCriteria(facetCriteria.toArray(facetCriteriaTab));
            }
            if ((sortAscending = criteria.getSortAscending()) != null) {
                String[] sortAscendingTab = new String[sortAscending.size()];
                serviceCriteria.setSortAscending(sortAscending.toArray(sortAscendingTab));
            }
            if ((sortDescending = criteria.getSortDescending()) != null) {
                String[] sortDescendingTab = new String[sortDescending.size()];
                serviceCriteria.setSortDescending(sortDescending.toArray(sortDescendingTab));
            }
        }
        PagedResult<String> pagedResult = this.wikittyService.findAllByCriteria(this.securityToken, serviceCriteria);
        PagedResult<?> result = pagedResult.cast(this, sample.getClass(), true);
        timeTrace.add(start, "findAllByCriteria<Business>");
        return result;
    }

    public PagedResult<Wikitty> findAllByCriteria(Criteria criteria) {
        long start = TimeTrace.getTime();
        PagedResult<String> resultId = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        PagedResult<Wikitty> result = resultId.cast(this.securityToken, this.wikittyService);
        timeTrace.add(start, "findAllByCriteria");
        return result;
    }

    public PagedResult<String> findAllIdByCriteria(Criteria criteria) {
        long start = TimeTrace.getTime();
        PagedResult<String> result = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        timeTrace.add(start, "findAllByCriteria");
        return result;
    }

    public <E extends BusinessEntity> E findByCriteria(Class<E> clazz, Criteria criteria) {
        long start = TimeTrace.getTime();
        BusinessEntityImpl sample = (BusinessEntityImpl)WikittyUtil.newInstance(clazz);
        Wikitty wikitty = sample.getWikitty();
        Collection<String> extensions = wikitty.getExtensionNames();
        Search search = Search.query(criteria);
        search = search.eq(Element.ELT_EXTENSION, extensions);
        criteria = search.criteria(criteria.getName());
        String id = this.wikittyService.findByCriteria(this.securityToken, criteria);
        Wikitty w = this.wikittyService.restore(this.securityToken, id);
        E result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, w);
        timeTrace.add(start, "findByCriteria<Business>");
        return result;
    }

    public Wikitty findByCriteria(Criteria criteria) {
        long start = TimeTrace.getTime();
        String id = this.wikittyService.findByCriteria(this.securityToken, criteria);
        Wikitty wikitty = this.wikittyService.restore(this.securityToken, id);
        timeTrace.add(start, "findByCriteria");
        return wikitty;
    }

    public WikittyTree restoreTree(String wikittyId) {
        long start = TimeTrace.getTime();
        WikittyTree result = this.wikittyService.restoreTree(this.securityToken, wikittyId);
        timeTrace.add(start, "restoreTree");
        return result;
    }

    public WikittyEvent deleteTree(String treeNodeId) {
        long start = TimeTrace.getTime();
        WikittyEvent result = this.wikittyService.deleteTree(this.securityToken, treeNodeId);
        timeTrace.add(start, "deleteTree");
        return result;
    }

    public <E extends BusinessEntity> Map.Entry<E, Integer> restoreNode(Class<E> clazz, String wikittyId, Criteria filter) {
        Map.Entry<E, Integer> result = this.restoreNode(clazz, wikittyId, filter, false);
        return result;
    }

    public <E extends BusinessEntity> Map.Entry<E, Integer> restoreNode(Class<E> clazz, String wikittyId, Criteria filter, boolean checkExtension) {
        E bean;
        long start = TimeTrace.getTime();
        AbstractMap.SimpleEntry<E, Integer> result = null;
        Map.Entry<String, Integer> node = this.wikittyService.restoreNode(this.securityToken, wikittyId, filter);
        if (node != null && (bean = this.restore(clazz, wikittyId, checkExtension)) != null) {
            result = new AbstractMap.SimpleEntry<E, Integer>(bean, node.getValue());
        }
        timeTrace.add(start, "restoreNode");
        return result;
    }

    public <E extends BusinessEntity> Map<E, Integer> restoreChildren(Class<E> clazz, String wikittyId, Criteria filter) {
        Map<E, Integer> result = this.restoreChildren(clazz, wikittyId, filter, false);
        return result;
    }

    public <E extends BusinessEntity> Map<E, Integer> restoreChildren(Class<E> clazz, String wikittyId, Criteria filter, boolean checkExtension) {
        long start = TimeTrace.getTime();
        LinkedHashMap<BusinessEntity, Integer> convertedResult = null;
        Map<String, Integer> result = this.wikittyService.restoreChildren(this.securityToken, wikittyId, filter);
        if (result != null) {
            ArrayList<String> ids = new ArrayList<String>(result.keySet());
            List<E> keys = this.restore(clazz, ids, checkExtension);
            convertedResult = new LinkedHashMap<BusinessEntity, Integer>();
            for (BusinessEntity e : keys) {
                Integer size = result.get(e.getWikittyId());
                convertedResult.put(e, size);
            }
        }
        timeTrace.add(start, "restoreChildren");
        return convertedResult;
    }

    public Wikitty restoreVersion(String wikittyId, String version) {
        long start = TimeTrace.getTime();
        Wikitty result = this.wikittyService.restoreVersion(this.securityToken, wikittyId, version);
        timeTrace.add(start, "restoreVersion");
        return result;
    }

    public <E extends BusinessEntity> boolean hasType(Class<E> clazz, String wikittyId) {
        try {
            long start = TimeTrace.getTime();
            boolean result = true;
            Wikitty wikitty = this.wikittyService.restore(this.securityToken, wikittyId);
            if (wikitty == null) {
                result = false;
            } else {
                HashSet<String> extNames = new HashSet<String>(wikitty.getExtensionNames());
                E businessObject = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
                BusinessEntityImpl b = (BusinessEntityImpl)businessObject;
                for (WikittyExtension ext : b.getStaticExtensions()) {
                    if (extNames.contains(ext.getName())) continue;
                    result = false;
                    break;
                }
            }
            timeTrace.add(start, "hasType");
            return result;
        }
        catch (SecurityException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't retrieve wikitty needed for hasType test", eee);
        }
    }

    public WikittyEvent storeExtension(WikittyExtension ext) {
        long start = TimeTrace.getTime();
        WikittyEvent response = this.wikittyService.storeExtension(this.securityToken, ext);
        timeTrace.add(start, "storeExtension");
        return response;
    }

    public WikittyEvent storeExtension(Collection<WikittyExtension> exts) {
        long start = TimeTrace.getTime();
        WikittyEvent response = this.wikittyService.storeExtension(this.securityToken, exts);
        timeTrace.add(start, "storeExtension<list>");
        return response;
    }

    public WikittyExtension restoreExtension(String extensionId) {
        long start = TimeTrace.getTime();
        WikittyExtension extension = this.wikittyService.restoreExtension(this.securityToken, extensionId);
        timeTrace.add(start, "restoreExtension");
        return extension;
    }

    public WikittyExtension restoreExtensionLastVersion(String extensionName) {
        long start = TimeTrace.getTime();
        WikittyExtension extension = this.wikittyService.restoreExtensionLastVersion(this.securityToken, extensionName);
        timeTrace.add(start, "restoreExtensionLastVersion");
        return extension;
    }

    public void deleteExtension(String extName) {
        long start = TimeTrace.getTime();
        this.wikittyService.deleteExtension(this.securityToken, extName);
        timeTrace.add(start, "deleteExtension");
    }

    public void deleteExtension(Collection<String> extNames) {
        long start = TimeTrace.getTime();
        this.wikittyService.deleteExtension(this.securityToken, extNames);
        timeTrace.add(start, "deleteExtension<list>");
    }

    public List<String> getAllExtensionIds() {
        long start = TimeTrace.getTime();
        List<String> result = this.wikittyService.getAllExtensionIds(this.securityToken);
        timeTrace.add(start, "getAllExtensionIds");
        return result;
    }

    public List<String> getAllExtensionsRequires(String extensionName) {
        long start = TimeTrace.getTime();
        List<String> result = this.wikittyService.getAllExtensionsRequires(this.securityToken, extensionName);
        timeTrace.add(start, "getAllExtensionsRequires");
        return result;
    }

    public WikittyEvent clear() {
        long start = TimeTrace.getTime();
        WikittyEvent result = this.wikittyService.clear(this.securityToken);
        timeTrace.add(start, "clear");
        return result;
    }

    public void syncSearchEngine() {
        long start = TimeTrace.getTime();
        this.wikittyService.syncSearchEngine(this.securityToken);
        timeTrace.add(start, "syncSearchEngine");
    }

    public Wikitty getWikitty(BusinessEntity entity) {
        long start = TimeTrace.getTime();
        Wikitty result = WikittyUtil.getWikitty(this.wikittyService, this.securityToken, entity);
        timeTrace.add(start, "getWikitty");
        return result;
    }

    public boolean isMember(String groupName) {
        long start = TimeTrace.getTime();
        boolean result = false;
        WikittyUser user = this.getLoggedInUser();
        Search search = Search.query().eq(Element.ELT_EXTENSION, "WikittyGroup").eq("WikittyGroup.name", groupName);
        Criteria criteria = search.criteria();
        Wikitty group = this.findByCriteria(criteria);
        if (group != null) {
            result = WikittySecurityUtil.isMember(this.wikittyService, this.securityToken, user.getWikittyId(), group.getId());
        }
        timeTrace.add(start, "isMember");
        return result;
    }

    public WikittyUser getLoggedInUser() {
        long start = TimeTrace.getTime();
        String userId = WikittySecurityUtil.getUserForToken(this.wikittyService, this.securityToken);
        WikittyUser user = this.restore(WikittyUser.class, userId);
        timeTrace.add(start, "getLoggedInUser");
        return user;
    }
}

