/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.FormLink;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.offer.widgets.FormLinkCellRenderer;
import com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionHandler;
import com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RelatedFormHandler
extends MultipleSelectionHandler<FormLink> {
    private static final Log log = LogFactory.getLog(RelatedFormHandler.class);
    protected FormLinkCellRenderer linkCellRenderer;
    protected List<FormLink> toSave = new ArrayList<FormLink>();

    public RelatedFormHandler(MultipleSelectionPane ui) {
        super(ui);
        ui.setLbl(I18n._("vradi.offerEdit.relatedForm"));
        this.linkCellRenderer = new FormLinkCellRenderer(ui);
        ui.getList().setCellRenderer(this.linkCellRenderer);
    }

    @Override
    public void init() {
        List relatedFormsLinkIds = null;
        String wikittyId = this.getBean().getWikittyId();
        try {
            relatedFormsLinkIds = VradiService.getVradiDataService().getRelatedFormsLinkIds(wikittyId);
        }
        catch (VradiException eee) {
            log.error((Object)("Cant get related form for form id : " + wikittyId), (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        this.fillList(relatedFormsLinkIds);
    }

    @Override
    public void add() {
        FormLink formLink = this.getHandler().addRelatedForm((JAXXContext)this.ui, this.getBean());
        if (formLink != null) {
            this.addToList(formLink, formLink.getWikittyId());
            this.linkCellRenderer.addAdded(formLink);
        }
    }

    @Override
    public void remove() {
        List<String> formLinkIds = this.getHandler().removeLinkForm(this.getSelectedInList());
        this.removeFromList(formLinkIds);
    }

    @Override
    public void openSelected(String selected) {
        OfferListHandler listHandler = UIHelper.getHandler((JAXXContext)this.ui, OfferListHandler.class);
        if (selected != null) {
            FormLink formLink = (FormLink)VradiService.getWikittyProxy().restore(FormLink.class, selected);
            if (formLink == null) {
                formLink = (FormLink)this.getAddedData(selected);
            }
            OfferListUI offerListUI = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
            listHandler.addEditPane((JAXXContext)offerListUI, formLink.getToForm());
        }
    }
}

