/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiExtensionsListener;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.models.FormMenu;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.entities.WikittyExtension;

public class RequestFieldMenu
extends JMenu
implements VradiExtensionsListener {
    private static final Log log = LogFactory.getLog(FormMenu.class);
    public static final String FIELD_NAME_SUFFIX = ":\"\"";
    protected SearchUI searchUI;
    protected Map<String, JMenu> formTypesMenu;
    protected Map<String, JMenuItem> formTypesFieldMenu;

    public RequestFieldMenu(SearchUI searchUI) {
        super(I18n._("vradi.request.keywords"));
        this.searchUI = searchUI;
        this.fillInfogeneMenu();
        List formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        }
        catch (VradiException eee) {
            log.error((Object)"cant get all forms type", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);
        this.formTypesMenu = new HashMap<String, JMenu>();
        this.formTypesFieldMenu = new HashMap<String, JMenuItem>();
        if (formTypes != null) {
            for (WikittyExtension formType : formTypes) {
                this.fillFormTypeMenu(formType);
            }
        }
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    protected void fillInfogeneMenu() {
        JMenu infogeneMenu = new JMenu(I18n._("vradi.request.infogene"));
        for (String fieldName : this.getInfogeneFieldNames()) {
            infogeneMenu.add(new InfogeneMenuItem(fieldName));
        }
        for (String fieldName : this.getFormFieldNames()) {
            infogeneMenu.add(new FormMenuItem(fieldName));
        }
        this.add(infogeneMenu);
    }

    protected void fillFormTypeMenu(WikittyExtension formType) {
        String formTypeName = formType.getName();
        JMenu formTypeMenu = new JMenu(formTypeName);
        for (String fieldName : formType.getFieldNames()) {
            FieldMenuItem fieldMenu = new FieldMenuItem(fieldName);
            formTypeMenu.add(fieldMenu);
            this.formTypesFieldMenu.put(fieldName, fieldMenu);
        }
        this.formTypesMenu.put(formTypeName, formTypeMenu);
        this.add(formTypeMenu);
    }

    protected List<String> getInfogeneFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("id");
        fieldNames.add("objet");
        fieldNames.add("description");
        fieldNames.add("creationDate");
        fieldNames.add("entity");
        fieldNames.add("sourceText");
        fieldNames.add("sourceURL");
        fieldNames.add("country");
        fieldNames.add("department");
        fieldNames.add("status");
        return fieldNames;
    }

    protected List<String> getFormFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("datePub");
        fieldNames.add("datePeremption");
        fieldNames.add("lastModifier");
        return fieldNames;
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        for (WikittyExtension ext : added) {
            this.fillFormTypeMenu(ext);
        }
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        for (String formTypeName : removedNames) {
            JMenu formTypeMenu = this.formTypesMenu.get(formTypeName);
            this.formTypesMenu.remove(formTypeName);
            this.remove(formTypeMenu);
        }
    }

    protected class FormMenuItem
    extends FieldMenuItem {
        public FormMenuItem(String key) {
            super(UIHelper.getFormTraduction(key), key);
        }
    }

    protected class InfogeneMenuItem
    extends FieldMenuItem {
        public InfogeneMenuItem(String key) {
            super(UIHelper.getInfogeneTraduction(key), key);
        }
    }

    protected class FieldMenuItem
    extends JMenuItem
    implements ActionListener {
        protected String key;

        public FieldMenuItem(String key) {
            this(null, key);
        }

        public FieldMenuItem(String text, String key) {
            super(text == null ? key : text + " (" + key + ")");
            this.key = key;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RSyntaxTextArea requestArea = RequestFieldMenu.this.searchUI.getRequestArea();
            int position = requestArea.getCaretPosition();
            requestArea.insert(this.key + RequestFieldMenu.FIELD_NAME_SUFFIX, position);
            requestArea.setCaretPosition(position + this.key.length() + 2);
            RequestFieldMenu.this.searchUI.setRequest(requestArea.getText());
        }
    }
}

