/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.offer.ThesaurusUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusSelectionManager;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.Component;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThesaurusHandler {
    private static Log log = LogFactory.getLog(ThesaurusHandler.class);

    public void initThesaurus(OfferEditUI ui) {
        JList propositionList = ui.getPropositionList();
        Form form = ui.getData();
        JPanel thesaurusPanel = ui.getThesaurus();
        thesaurusPanel.removeAll();
        VradiDataProvider dataProvider = new VradiDataProvider();
        ThesaurusSelectionManager manager = new ThesaurusSelectionManager(propositionList, form);
        ui.setContextValue(manager);
        ThesaurusTreeHelper rootHelper = new ThesaurusTreeHelper(dataProvider);
        this.openThesaurusUI((JAXXContext)ui, thesaurusPanel, manager, rootHelper, false);
        List<String> rootThesaurusIds = VradiHelper.getVradiListRootThesaurus();
        List<RootThesaurus> savedRootThesauruses = ThesaurusDataHelper.restoreRootThesaurus(rootThesaurusIds);
        for (RootThesaurus savedRootThesaurus : savedRootThesauruses) {
            if (savedRootThesaurus == null) continue;
            ThesaurusTreeHelper helper = new ThesaurusTreeHelper(dataProvider, savedRootThesaurus);
            this.openThesaurusUI((JAXXContext)ui, thesaurusPanel, manager, helper, true);
        }
        List<String> thesaurusIds = VradiHelper.getVradiListThesaurus();
        List<Thesaurus> savedThesauruses = ThesaurusDataHelper.restoreThesaurus(thesaurusIds);
        for (Thesaurus savedThesaurus : savedThesauruses) {
            if (savedThesaurus == null) continue;
            ThesaurusTreeHelper helper = new ThesaurusTreeHelper(dataProvider, savedThesaurus);
            this.openThesaurusUI((JAXXContext)ui, thesaurusPanel, manager, helper, true);
        }
        ui.updateThesaurusSize();
    }

    protected void openThesaurusUI(JAXXContext context, JPanel thesaurusPanel, ThesaurusSelectionManager manager, ThesaurusTreeHelper helper, boolean deletable) {
        thesaurusPanel.add((Component)((Object)new ThesaurusUI(context, manager, helper, deletable)));
    }

    public void newThesaurusUI(JAXXContext context, ThesaurusSelectionManager manager, TreePath path) {
        ThesaurusTreeHelper newHelper;
        if (path == null) {
            return;
        }
        VradiTreeNode parentNode = (VradiTreeNode)((Object)path.getLastPathComponent());
        if (parentNode == null) {
            return;
        }
        RootThesaurus rootThesaurus = this.getRootThesaurus(parentNode);
        if (rootThesaurus != null) {
            newHelper = new ThesaurusTreeHelper(manager.getDataProvider(), rootThesaurus);
            VradiHelper.addVradiListRootThesaurus(rootThesaurus);
        } else {
            Thesaurus thesaurus = this.getThesaurus(parentNode);
            newHelper = new ThesaurusTreeHelper(manager.getDataProvider(), thesaurus);
            VradiHelper.addVradiListThesaurus(thesaurus);
        }
        this.openThesaurusUI(context, this.getThesaurusContainer(context), manager, newHelper, true);
        this.getEditUI(context).updateThesaurusSize();
    }

    public void closeThesaurus(JAXXContext context) {
        ThesaurusUI thesaurusUI = this.getUI(context);
        OfferEditUI ui = thesaurusUI.getParentContainer(OfferEditUI.class);
        this.getThesaurusContainer(context).remove((Component)((Object)thesaurusUI));
        VradiTreeNode rootNode = (VradiTreeNode)thesaurusUI.helper.getRootNode();
        Thesaurus thesaurus = this.getThesaurus(rootNode);
        if (thesaurus != null) {
            VradiHelper.removeVradiListThesaurus(thesaurus);
        } else {
            RootThesaurus rootThesaurus = this.getRootThesaurus(rootNode);
            VradiHelper.removeVradiListRootThesaurus(rootThesaurus);
        }
        ui.updateThesaurusSize();
    }

    public void addCriteria(JAXXContext context, ThesaurusTreeHelper helper, TreePath path) {
        OfferListUI ui = this.getListUI(context);
        VradiTreeNode parentNode = this.getParentNode(helper, path);
        Thesaurus thesaurus = this.getThesaurus(parentNode);
        UIHelper.getHandler(context, SearchHandler.class).addAndPersistCriteria(context, thesaurus);
        ui.validate();
    }

    protected VradiTreeNode getSelectedNode(ThesaurusTreeHelper helper) {
        VradiTreeNode selectedNode = (VradiTreeNode)helper.getSelectedNode();
        if (selectedNode == null) {
            selectedNode = (VradiTreeNode)helper.getRootNode();
        }
        return selectedNode;
    }

    protected RootThesaurus getRootThesaurus(VradiTreeNode node) {
        Class internalClass = node.getInternalClass();
        if (!internalClass.equals(RootThesaurus.class)) {
            return null;
        }
        String id = node.getId();
        return ThesaurusDataHelper.restoreRootThesaurus(id);
    }

    public String getNamePath(VradiTreeNode node) {
        if (node == null) {
            return "";
        }
        if (node.isStringNode()) {
            return "";
        }
        String id = node.getId();
        Class internalClass = node.getInternalClass();
        if (internalClass.equals(RootThesaurus.class)) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(id);
            return rootThesaurus.getName();
        }
        Thesaurus thesaurus = ThesaurusDataHelper.restoreThesaurus(id);
        return ThesaurusDataHelper.getNamePath(thesaurus, "/");
    }

    protected Thesaurus getThesaurus(VradiTreeNode node) {
        Class internalClass = node.getInternalClass();
        if (!internalClass.equals(Thesaurus.class)) {
            return null;
        }
        String id = node.getId();
        return ThesaurusDataHelper.restoreThesaurus(id);
    }

    public ThesaurusUI getUI(JAXXContext context) {
        if (context instanceof ThesaurusUI) {
            return (ThesaurusUI)context;
        }
        return null;
    }

    protected JPanel getThesaurusContainer(JAXXContext context) {
        return this.getUI(context).getParentContainer(OfferEditUI.class).getThesaurus();
    }

    protected OfferEditUI getEditUI(JAXXContext context) {
        return this.getUI(context).getParentUI();
    }

    protected OfferListUI getListUI(JAXXContext context) {
        return UIHelper.getHandler(context, OfferListHandler.class).getUI(context);
    }

    protected VradiTreeNode getParentNode(ThesaurusTreeHelper helper, TreePath path) {
        if (path == null) {
            return (VradiTreeNode)helper.getRootNode();
        }
        return (VradiTreeNode)((Object)path.getLastPathComponent());
    }
}

