/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: XmlStreamNavigationTreeHelper.java 1739 2010-11-03 08:59:10Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/helpers/XmlStreamNavigationTreeHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.Set;

import com.jurismarches.vradi.ui.admin.loadors.StreamNodeLoadors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class XmlStreamNavigationTreeHelper extends AdminNavigationTreeHelper {

    /** Logger. */
    static private final Log log = LogFactory.getLog(XmlStreamNavigationTreeHelper.class);

    public XmlStreamNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {

        // Create client category node
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.XML_STREAM.getCategoryName(),
                null,
                new StreamNodeLoadors()
        );
    }

    /*
     * @see org.nuiton.wikitty.WikittyServiceListener#putWikitty(org.nuiton.wikitty.WikittyServiceEvent)
     */
    @Override
    public void putWikitty(String wikittyId, Set<String> wikittyExtensions) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service put event : " + wikittyId);
        }

        if (wikittyExtensions.contains(XmlStream.EXT_XMLSTREAM)) {

            VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);
            // cas modification
            if (existingNode != null) {

                // Reconstruction des fils
                refresh(existingNode);
            }

            // cas creation
            else {
                createStreamNode(wikittyId, false);
            }
        }
    }
}
