/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminFormTypeUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<WikittyExtension> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.nuiton.wikitty.WikittyExtension bean;
    protected jaxx.runtime.swing.CardLayout2 cardLayout;
    protected javax.swing.JPanel cardPanel;
    protected jaxx.runtime.swing.VBox content;
    protected javax.swing.JButton createField;
    protected javax.swing.JButton createForm;
    protected javax.swing.JButton downloadTemplate;
    protected jaxx.runtime.swing.Table fieldListUI;
    protected jaxx.runtime.swing.HidorButton hidorInfogene;
    protected javax.swing.JPanel infogene;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JButton newTemplate;
    protected javax.swing.JButton templateBindingButton;
    protected javax.swing.JComboBox templateChoice;
    protected javax.swing.JButton templateExampleButton;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminFormTypeUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void postLoadBean() {
    
        title.setText(_("vradi.adminForm.title", getStringValue(bean == null ? "" : bean.getName())));
        if (bean == null) {
            return;
        }
    
        // Update template choice
        templateChoice.setModel(getHandler().getTemplateComboBoxModel(bean));
    
        // Select template
        templateChoice.setSelectedItem(getHandler().getFormTypeTemplateName(bean));
    
        // Fill other fields that infogene
        int i = 0;
        Collection<String> fieldNames = bean.getFieldNames();
        for (String fieldName : fieldNames) {
            FieldType fieldType = bean.getFieldType(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                    VradiHelper.getFieldTypeEnum(fieldType), i);
            create(fieldSelectModel);
            i = i + 1;
        }
        fillInfogenePanel();
        setModified(false);
        validate();
    }
    
    @Override
    public void save() {
        getHandler().saveFormType(this, getHelper());
        setModified(false);
    }
    
    @Override
    protected void clearUI() {
        content.removeAll();
    }
    
    protected void create() {
        create(new FieldSelectModel(content.getComponentCount()));
    }
    
    protected void create(FieldSelectModel fieldSelectModel){
        FieldSelectUI result = new FieldSelectUI(this);
    
        result.updateBean(fieldSelectModel);
        result.addPropertyChangeListener(FieldSelectUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                FieldSelectUI field = (FieldSelectUI) evt.getSource();
                if (log.isDebugEnabled()) {
                    log.debug("field " + field + " modified value =  " + evt.getNewValue());
                }
                setModified(true);
                if(evt.getNewValue() == null) {
    
                    if(field != null) {
                        field.setVisible(false);
                        content.remove(field);
                    }
                    if(field.getBean().isUpOrDown() != null) {
                        if(field.getBean().isUpOrDown() && field.getBean().getPosition() == 0) {
                            content.add(field, 0);
                        } else if(!field.getBean().isUpOrDown() && field.getBean().getPosition() == content.getComponentCount()) {
                            content.add(field);
                        } else {
                            int fieldToMovePosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition();
                            int fieldToAddPosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition() + 1;
                            FieldSelectUI fieldToMove = (FieldSelectUI) content.getComponent(fieldToMovePosition);
                            if (log.isDebugEnabled()) {
                                log.debug(fieldToMove.getBean().getNameValue() + " : " + fieldToMove.getBean().getPosition());
                            }
    
                            content.add(field, fieldToAddPosition);
                            for(int i = 0 ; i < content.getComponentCount() ; i++) {
                                FieldSelectUI fieldSelectUI = (FieldSelectUI) content.getComponent(i);
                                fieldSelectUI.getBean().setPosition(i);
                                if (log.isDebugEnabled()) {
                                    log.debug(fieldSelectUI.getBean().getNameValue() + " : " + fieldSelectUI.getBean().getPosition());
                                }
                            }
                        }
                        field.getBean().setUpOrDown(null);
                        field.setVisible(true);
                    }
                    content.validate();
                }
            }
        });
        result.setModified(false);
    
        content.add(result);
        validate();
    }
    
    private void fillInfogenePanel() {
        infogene.removeAll();
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        int i = 0;
        java.util.List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Infogene.FIELD_INFOGENE_ID);
        fieldNames.add(Infogene.FIELD_INFOGENE_OBJET);
        fieldNames.add(Infogene.FIELD_INFOGENE_DESCRIPTION);
        fieldNames.add(Infogene.FIELD_INFOGENE_CREATIONDATE);
        fieldNames.add(Infogene.FIELD_INFOGENE_ENTITY);
        fieldNames.add(Infogene.FIELD_INFOGENE_SOURCETEXT);
        fieldNames.add(Infogene.FIELD_INFOGENE_SOURCEURL);
        fieldNames.add(Infogene.FIELD_INFOGENE_COUNTRY);
        fieldNames.add(Infogene.FIELD_INFOGENE_DEPARTMENT);
        fillInfogenePanel(fieldNames, extension, i);
    
        extension = FormImpl.extensionForm;
        fieldNames.clear();
        fieldNames.add(Form.FIELD_FORM_DATEPUB);
        fieldNames.add(Form.FIELD_FORM_DATEPEREMPTION);
        fillInfogenePanel(fieldNames, extension, i);
    }
    
    private void fillInfogenePanel(java.util.List<String> fieldNames,
                                   WikittyExtension extension, int i) {
        for (String fieldName : fieldNames) {
            FieldType fieldType = extension.getFieldType(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
    
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                    FieldTypeEnum.valueOf(fieldType), i);
    
            FieldDisplayUI fieldDisplayUI = new FieldDisplayUI(this);
            fieldDisplayUI.updateBean(fieldSelectModel);
    
            infogene.add(fieldDisplayUI);
            i = i + 1;
        }
    
    }
    
    private void onHidorInfogene() {
        if (hidorInfogene.isSelected()) {
            cardLayout.show(cardPanel, "infogene");
        } else {
            cardLayout.show(cardPanel, "content");
        }
    }
    
    private void openTemplateFieldBindingUI() {
        TemplateFieldBindingUI templateFieldBindingUI =
                new TemplateFieldBindingUI(this);
        getHandler().updateTemplateFieldTableModel(templateFieldBindingUI,
                getBean(), (String) templateChoice.getSelectedItem());
        templateFieldBindingUI.setVisible(true);
    }
    
    protected void addNewTemplate() {
        if (getHandler().uploadNewTemplate(this)) {
            openTemplateFieldBindingUI();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminFormTypeUI() {
        super();
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createField(java.awt.event.ActionEvent event) {
        create();
    }

    public void doActionPerformed__on__createForm(java.awt.event.ActionEvent event) {
        getHandler().createFormType(this, getHelper()); setModified(true);
    }

    public void doActionPerformed__on__downloadTemplate(java.awt.event.ActionEvent event) {
        getHandler().downloadTemplate(this);
    }

    public void doActionPerformed__on__hidorInfogene(java.awt.event.ActionEvent event) {
        onHidorInfogene();
    }

    public void doActionPerformed__on__newTemplate(java.awt.event.ActionEvent event) {
        addNewTemplate();
    }

    public void doActionPerformed__on__templateBindingButton(java.awt.event.ActionEvent event) {
        openTemplateFieldBindingUI();
    }

    public void doActionPerformed__on__templateChoice(java.awt.event.ActionEvent event) {
        setModified(true);
    }

    public void doActionPerformed__on__templateExampleButton(java.awt.event.ActionEvent event) {
        getHandler().showTemplateExample(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.nuiton.wikitty.WikittyExtension getBean() {
        return bean;
    }

    public jaxx.runtime.swing.CardLayout2 getCardLayout() {
        return cardLayout;
    }

    public javax.swing.JPanel getCardPanel() {
        return cardPanel;
    }

    public jaxx.runtime.swing.VBox getContent() {
        return content;
    }

    public javax.swing.JButton getCreateField() {
        return createField;
    }

    public javax.swing.JButton getCreateForm() {
        return createForm;
    }

    public javax.swing.JButton getDownloadTemplate() {
        return downloadTemplate;
    }

    public jaxx.runtime.swing.Table getFieldListUI() {
        return fieldListUI;
    }

    public jaxx.runtime.swing.HidorButton getHidorInfogene() {
        return hidorInfogene;
    }

    public javax.swing.JPanel getInfogene() {
        return infogene;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JButton getNewTemplate() {
        return newTemplate;
    }

    public javax.swing.JButton getTemplateBindingButton() {
        return templateBindingButton;
    }

    public javax.swing.JComboBox getTemplateChoice() {
        return templateChoice;
    }

    public javax.swing.JButton getTemplateExampleButton() {
        return templateExampleButton;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(org.nuiton.wikitty.WikittyExtension newValue) {
        org.nuiton.wikitty.WikittyExtension oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToCardPanel() {
        if (!allComponentsCreated) {
            return;
        }
        cardPanel.add(content, "content");
        cardPanel.add(infogene, "infogene");
    }

    protected void addChildrenToFieldListUI() {
        if (!allComponentsCreated) {
            return;
        }
        fieldListUI.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add(createForm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCardLayout() {
        $objectMap.put("cardLayout", cardLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createCardPanel() {
        $objectMap.put("cardPanel", cardPanel = new javax.swing.JPanel());
        
        cardPanel.setName("cardPanel");
        cardPanel.setLayout(cardLayout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new jaxx.runtime.swing.VBox());
        
        content.setName("content");
    }

    protected void createCreateField() {
        $objectMap.put("createField", createField = new javax.swing.JButton());
        
        createField.setName("createField");
        createField.setText(_("vradi.adminField.new"));
        createField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createField"));
    }

    protected void createCreateForm() {
        $objectMap.put("createForm", createForm = new javax.swing.JButton());
        
        createForm.setName("createForm");
        createForm.setText(_("vradi.adminForm.createForm"));
        createForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForm"));
    }

    protected void createDownloadTemplate() {
        $objectMap.put("downloadTemplate", downloadTemplate = new javax.swing.JButton());
        
        downloadTemplate.setName("downloadTemplate");
        downloadTemplate.setText(_("vradi.adminFormType.template.download"));
        downloadTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__downloadTemplate"));
    }

    protected void createFieldListUI() {
        $objectMap.put("fieldListUI", fieldListUI = new jaxx.runtime.swing.Table());
        
        fieldListUI.setName("fieldListUI");
    }

    protected void createHidorInfogene() {
        $objectMap.put("hidorInfogene", hidorInfogene = new jaxx.runtime.swing.HidorButton());
        
        hidorInfogene.setName("hidorInfogene");
        hidorInfogene.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidorInfogene"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = new javax.swing.JPanel());
        
        infogene.setName("infogene");
        infogene.setLayout(new GridLayout(0,1));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createNewTemplate() {
        $objectMap.put("newTemplate", newTemplate = new javax.swing.JButton());
        
        newTemplate.setName("newTemplate");
        newTemplate.setText(_("vradi.adminFormType.template.new"));
        newTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newTemplate"));
    }

    protected void createTemplateBindingButton() {
        $objectMap.put("templateBindingButton", templateBindingButton = new javax.swing.JButton());
        
        templateBindingButton.setName("templateBindingButton");
        templateBindingButton.setText(_("vradi.adminFormType.template.fieldBinding"));
        templateBindingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateBindingButton"));
    }

    protected void createTemplateChoice() {
        $objectMap.put("templateChoice", templateChoice = new javax.swing.JComboBox());
        
        templateChoice.setName("templateChoice");
        templateChoice.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateChoice"));
    }

    protected void createTemplateExampleButton() {
        $objectMap.put("templateExampleButton", templateExampleButton = new javax.swing.JButton());
        
        templateExampleButton.setName("templateExampleButton");
        templateExampleButton.setText(_("vradi.adminFormType.template.showExample"));
        templateExampleButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateExampleButton"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        addChildrenToBody();
        addChildrenToFieldListUI();
        // inline complete setup of $JPanel0
        $JPanel0.add(createField);
        $JPanel0.add($JButton0);
        $JPanel0.add(hidorInfogene, BorderLayout.WEST);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(cardPanel);
        addChildrenToCardPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel1);
        $JPanel1.add(templateChoice);
        $JPanel1.add(newTemplate);
        $JPanel1.add(downloadTemplate);
        $JPanel1.add(templateBindingButton);
        $JPanel1.add(templateExampleButton);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        cardLayout.setUseOnlyVisibleComponentDimension(true);
        createField.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        hidorInfogene.setHideText(_("vradi.adminFormType.hideInfogene"));
        hidorInfogene.setShowText(_("vradi.adminFormType.showInfogene"));
        hidorInfogene.setTarget(new jaxx.runtime.swing.Spacer());
        hidorInfogene.setTargetVisible(false);
        templateChoice.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createCardLayout();
        createTitle();
        createCreateForm();
        createFieldListUI();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.title"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminFormType.deleteFormType"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createHidorInfogene();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createCardPanel();
        createContent();
        createInfogene();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminFormType.template.label"));
        createTemplateChoice();
        createNewTemplate();
        createDownloadTemplate();
        createTemplateBindingButton();
        createTemplateExampleButton();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
    }

}