/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nInterceptor
extends AbstractInterceptor {
    protected static final Logger LOG = LoggerFactory.getLogger(I18nInterceptor.class);
    public static final String DEFAULT_SESSION_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_PARAMETER = "request_locale";
    public static final String DEFAULT_REQUESTONLY_PARAMETER = "request_only_locale";
    protected String parameterName = "request_locale";
    protected String requestOnlyParameterName = "request_only_locale";
    protected String attributeName = "WW_TRANS_I18N_LOCALE";

    public I18nInterceptor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("new I18nInterceptor()", new String[0]);
        }
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setRequestOnlyParameterName(String requestOnlyParameterName) {
        this.requestOnlyParameterName = requestOnlyParameterName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("intercept '" + invocation.getProxy().getNamespace() + "/" + invocation.getProxy().getActionName() + "' { ", new String[0]);
        }
        Map<String, Object> params = invocation.getInvocationContext().getParameters();
        boolean storeInSession = true;
        Object requested_locale = this.findLocaleParameter(params, this.parameterName);
        if (requested_locale == null && (requested_locale = this.findLocaleParameter(params, this.requestOnlyParameterName)) != null) {
            storeInSession = false;
        }
        Map<String, Object> session = invocation.getInvocationContext().getSession();
        Locale locale = null;
        if (requested_locale != null) {
            Locale locale2 = locale = requested_locale instanceof Locale ? (Locale)requested_locale : LocalizedTextUtil.localeFromString(requested_locale.toString(), null);
            if (locale != null && LOG.isDebugEnabled()) {
                LOG.debug("applied request locale=" + locale, new String[0]);
            }
        }
        if (session != null) {
            Map<String, Object> map = session;
            synchronized (map) {
                if (locale == null) {
                    Object sessionLocale = session.get(this.attributeName);
                    if (sessionLocale != null && sessionLocale instanceof Locale) {
                        locale = (Locale)sessionLocale;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("applied session locale=" + locale, new String[0]);
                        }
                    } else {
                        locale = invocation.getInvocationContext().getLocale();
                        if (locale != null && LOG.isDebugEnabled()) {
                            LOG.debug("applied invocation context locale=" + locale, new String[0]);
                        }
                    }
                }
                if (storeInSession) {
                    session.put(this.attributeName, locale);
                }
            }
        }
        this.saveLocale(invocation, locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("before Locale=" + invocation.getStack().findValue("locale"), new String[0]);
        }
        String result = invocation.invoke();
        if (LOG.isDebugEnabled()) {
            LOG.debug("after Locale=" + invocation.getStack().findValue("locale"), new String[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("intercept } ", new String[0]);
        }
        return result;
    }

    private Object findLocaleParameter(Map<String, Object> params, String parameterName) {
        Object requested_locale = params.remove(parameterName);
        if (requested_locale != null && requested_locale.getClass().isArray() && ((Object[])requested_locale).length == 1) {
            requested_locale = ((Object[])requested_locale)[0];
            if (LOG.isDebugEnabled()) {
                LOG.debug("requested_locale=" + requested_locale, new String[0]);
            }
        }
        return requested_locale;
    }

    protected void saveLocale(ActionInvocation invocation, Locale locale) {
        invocation.getInvocationContext().setLocale(locale);
    }
}

