/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=false)
public class AddDataTest
extends ChannelTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdditionalData() throws Exception {
        for (int i = 1; i <= 2; ++i) {
            System.out.println("-- attempt # " + i + "/2");
            JChannel c = this.createChannel(true);
            try {
                HashMap<String, byte[]> m = new HashMap<String, byte[]>();
                m.put("additional_data", new byte[]{98, 101, 108, 97});
                ((Channel)c).down(new Event(56, m));
                ((Channel)c).connect("AddDataTest.testadditionalData()");
                UUID addr = (UUID)((Channel)c).getAddress();
                System.out.println("address is " + addr);
                assert (addr.getAdditionalData() != null);
                if ($assertionsDisabled || addr.getAdditionalData()[0] == 98) continue;
                throw new AssertionError();
            }
            finally {
                ((Channel)c).close();
            }
        }
    }

    @Test
    public void testBetweenTwoChannelsMcast() throws Exception {
        this._testWithProps(true, "AddDataTest.testBetweenTwoChannelsMcast");
    }

    @Test
    public void testBetweenTwoChannelsUnicast() throws Exception {
        this._testWithProps(false, "AddDataTest.testBetweenTwoChannelsUnicast");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testWithProps(boolean mcast, String cluster_name) throws Exception {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("additional_data", new byte[]{98, 101, 108, 97});
        byte[] buf = new byte[1000];
        JChannel ch1 = null;
        JChannel ch2 = null;
        try {
            ch1 = this.createChannel(true, 2);
            ch1.down(new Event(56, m));
            ch2 = this.createChannel(ch1);
            ch2.down(new Event(56, m));
            MyReceiver receiver = new MyReceiver();
            ch2.setReceiver(receiver);
            ch1.connect(cluster_name);
            ch2.connect(cluster_name);
            if (mcast) {
                ch1.send(new Message(null, null, buf));
            } else {
                Address dest = ch2.getAddress();
                ch1.send(new Message(dest, null, buf));
            }
            Util.sleep(500L);
            List<Message> list = receiver.getMsgs();
            assert (!list.isEmpty());
            Message msg = list.get(0);
            UUID src = (UUID)msg.getSrc();
            assert (src != null);
            assert (src.getAdditionalData() != null);
            assert (src.getAdditionalData().length == 4);
        }
        finally {
            if (ch2 != null) {
                ch2.close();
            }
            if (ch1 != null) {
                ch1.close();
            }
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        final List<Message> msgs = new LinkedList<Message>();

        private MyReceiver() {
        }

        public List<Message> getMsgs() {
            return this.msgs;
        }

        public void clear() {
            this.msgs.clear();
        }

        @Override
        public void receive(Message msg) {
            System.out.println("received " + msg);
            this.msgs.add(msg);
        }
    }
}

