/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.webharvest.gui.ConfigPanel;
import org.webharvest.gui.PropertiesGridModel;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.ViewerFrame;
import org.webharvest.gui.component.SmallButton;

public class PropertiesGrid
extends JTable {
    private ConfigPanel configPanel = null;

    public PropertiesGrid(ConfigPanel configPanel) {
        super(new PropertiesGridModel());
        this.configPanel = configPanel;
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.getColumn(2).setCellRenderer(new ButtonRenderer());
        columnModel.getColumn(2).setCellEditor(new ButtonEditor(new JCheckBox()));
        columnModel.getColumn(2).setMaxWidth(15);
    }

    public PropertiesGridModel getPropertiesGridModel() {
        TableModel tableModel = this.getModel();
        return tableModel instanceof PropertiesGridModel ? (PropertiesGridModel)tableModel : null;
    }

    private class ButtonEditor
    extends DefaultCellEditor {
        protected JButton button;
        private boolean isPushed;
        private int row;

        public ButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.button.setIcon(ResourceManager.SMALL_VIEW_ICON);
            this.isPushed = true;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.isPushed) {
                PropertiesGridModel model = PropertiesGrid.this.getPropertiesGridModel();
                String propertyName = (String)model.getValueAt(this.row, 0);
                Object value = model.getValueAt(this.row, 1);
                final ViewerFrame viewerFrame = new ViewerFrame(PropertiesGrid.this.configPanel.getScraper(), propertyName, value, model.getNodeInfo(), 0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        viewerFrame.setVisible(true);
                        viewerFrame.toFront();
                    }
                });
            }
            this.isPushed = false;
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    private class ButtonRenderer
    extends SmallButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            this.setOpaque(true);
            this.setBorder(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setIcon(ResourceManager.SMALL_VIEW_ICON);
            return this;
        }
    }
}

