/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AbstractVradiNodeLoadors.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/tree/loadors/AbstractVradiNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.tree.loadors;

import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public abstract class AbstractVradiNodeLoadors<B extends BusinessEntity> extends NavTreeNodeChildLoador<String, B, VradiTreeNode> {

    protected AbstractVradiNodeLoadors(Class<B> beanType) {
        super(beanType);
    }

    public WikittyProxy getProxy(NavDataProvider dataProvider) {
        return ((VradiDataProvider) dataProvider).getWikittyProxy();
    }

    public VradiDataService getDataService(NavDataProvider dataProvider) {
        return ((VradiDataProvider) dataProvider).getVradiDataService();
    }
    
    public VradiTreeNode createVradiNode(String id) {

        return new VradiTreeNode(
                getBeanType(),
                id,
                null,
                null);
    }

    public VradiTreeNode createVradiNode(String id, NavTreeNodeChildLoador<?, ?, VradiTreeNode> childLoador) {

        return new VradiTreeNode(
                getBeanType(),
                id,
                null,
                childLoador);
    }

    protected List<String> extractIds(Collection<B> entities) {
        List<String> ids = new ArrayList<String>();
        if (entities == null) {
            return ids;
        }
        for (BusinessEntity e : entities) {
            if (e != null) {
                ids.add(e.getWikittyId());   
            }
        }
        return ids;
    }
}
