/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public abstract class VradiEditor<O, M extends VradiEditorModel<O>> extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_NAME_LABEL_TEXT = "fieldNameLabel.text";
    public static final String BINDING_FIELD_NAME_LABEL_TOOL_TIP_TEXT = "fieldNameLabel.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1SPW8TMRh+c23SJiHlo6IUtUALzA4SYxAUBSKIwodIhSqy4MRO48h3NravvTIgfgI/AXYWJDYmxMDMwIL4CwgxsCJsJ00aONRK5Qbf3Ws/j5/3eZ/X3yCrFaz2cZIgFUeGhRTVr29s3Gv3acfcoLqjmDRCweDJBBC0oEhGdW3gQqvh4OUhvFwVoRQRjfagKw0oaLPDqe5RagycmUR0tC43R9uVRMZql3UkKo315Y/vwQvy/FUAkEirbsq2srIfatzJdAMCRgycsDdt4TLH0aaVoVi0afWWXK3KsdZ3cUifwDOYaUBOYmXJDJw/eMuew+MTaWD2Yv0+jii/ZOByR4SoHyumQ6w6ParRlsKEoZgh0e1ShShhzmH00JVv+h8pPVXOwFyXUU6ctgZuU267cIITpLetflT3RXc0P0KUBnxVERnfwyTAqxoCFCxNuGjng8bzGRuYaUFWxbZsYLH190gf2K3BMBf/GKYj9Lu/FuY/v/v6trY7QRfGk6lH9wTQOiuVkFQZ5q4+OhhfbBgv38Gy0oK8ptym16dzOUVYc7htxdn7jjs4cnB0C+uepcjOfHn/YeHxpykIalDgApMadudvQ970lHVBcJLIa2te0ZHtWbsec9oM5DjeEbE1d+4KwQavtFlErL1XE2vCcooJIyXt/Mef8803a7tGZKyw0/88PjYj+whyLOIsoj7Mw5ymhrcoNY2JGOcxLaEZ9y7IYc5O+XUprdNiyCIWxmGTPfUXnE1i9zrntbuvVU9VOgBVSSpq864o+Q9k04Ym5pAcRSMEX2dyfX+q3wZjlrNBBQAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.VradiEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel editorContent;
    protected javax.swing.JLabel fieldNameLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VradiEditor $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * Initialize the editor, must be call before any use of it.
     */
    public void init() {
        // model is null, when coming here from parent
        applyDataBinding("fieldNameLabel.text");
    }
    
    public abstract VradiEditorModel<O> getModel();
    
    public String getFieldName() {
        return getModel().getFieldName();
    }
    
    public void setFieldName(String newValue) {
        getModel().setFieldName(newValue);
    }
    
    public String getFieldDescription() {
        return getModel().getFieldDescription();
    }
    
    public void setFieldDescription(String newValue) {
        getModel().setFieldDescription(newValue);
    }
    
    public String getExtensionName() {
        return getModel().getExtensionName();
    }
    
    public void setExtensionName(String newValue) {
        getModel().setExtensionName(newValue);
    }
    
    public String getExtensionFieldName() {
        return getModel().getExtensionFieldName();
    }
    
    public void setExtensionFieldName(String newValue) {
        getModel().setExtensionFieldName(newValue);
    }
    
    public O getValue() {
        return getModel().getValue();
    }
    
    public void setValue(O newValue) {
        getModel().setValue(newValue);
    }
    
    public String getValidatorContext() {
        return getModel().getValidatorContext();
    }
    
    public void setValidatorContext(String newValue) {
        getModel().setValidatorContext(newValue);
        registerValidator();
    }
    
    abstract void registerValidator();

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiEditor() {
        $initialize();
    }

    public VradiEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getEditorContent() {
        return editorContent;
    }

    public javax.swing.JLabel getFieldNameLabel() {
        return fieldNameLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEditorContent() {
        $objectMap.put("editorContent", editorContent = new javax.swing.JPanel());
        
        editorContent.setName("editorContent");
    }

    protected void createFieldNameLabel() {
        $objectMap.put("fieldNameLabel", fieldNameLabel = new javax.swing.JLabel());
        
        fieldNameLabel.setName("fieldNameLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(fieldNameLabel, BorderLayout.WEST);
        add(editorContent, BorderLayout.CENTER);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        fieldNameLabel.setMinimumSize(new Dimension(0,28));
        fieldNameLabel.setPreferredSize(new Dimension(80,15));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createFieldNameLabel();
        createEditorContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_NAME_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    fieldNameLabel.setText(_(getModel().getFieldName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_NAME_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldDescription", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    fieldNameLabel.setToolTipText(_(getModel().getFieldDescription() != null ?                     SwingUtil.getStringValue(getModel().getFieldDescription()) :                     SwingUtil.getStringValue(getModel().getFieldName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldDescription", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldName", this);
                }
            }
        });
    }

}