/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailCellRenderer.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/renderers/EmailCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.renderers;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.ui.email.helpers.EmailBeanConstant;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.nuiton.wikitty.BusinessEntity;

/**
 * @author letellier
 * @see AbstractNavTreeCellRenderer
 */
public class EmailCellRenderer extends AbstractNavTreeCellRenderer<DefaultTreeModel, VradiTreeNode> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7917305304778635796L;

    /** Logger */
    protected static final Log log = LogFactory.getLog(EmailCellRenderer.class);

    /**
     * Init renderer.
     *
     * @param decoratorProvider ???
     * @param dataProvider data provider
     */
    public EmailCellRenderer(VradiDataProvider dataProvider) {

        setDataProvider(dataProvider);
    }

    @Override
    protected String computeNodeText(VradiTreeNode node) {

        // get decorator
        EmailBeanConstant constant = getEmailConstant(node);

        // Get bean
        BusinessEntity bean = getEmailBean(constant, node.getId());

        // Get session
        Session session = EmailNavigationTreeHelper.getParentSession(node);

        // Decorate
        String decorated = constant.decorate(session, bean);

        if (log.isDebugEnabled()) {
            log.debug("Compute text for node " + node + " return " + decorated);
        }

        return decorated;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree,
                                                  Object value,
                                                  boolean sel,
                                                  boolean expanded,
                                                  boolean leaf, int row,
                                                  boolean hasFocus) {

        // get node
        VradiTreeNode node = (VradiTreeNode)value;

        // get text for node
        String text = getNodeText(node);

        // Render node
        JLabel jLabel = (JLabel) super.getTreeCellRendererComponent(tree, text, sel,
                expanded, leaf,
                row, hasFocus);

        // get decorator
        EmailBeanConstant constant = getEmailConstant(node);

        // Not for root node
        if (constant != null) {

            // Get bean
            BusinessEntity bean = getEmailBean(constant, node.getId());

            // Get toolTipText
            String toolTipText = constant.getToolTipText(bean);

            // Add toolTip
            jLabel.setToolTipText(toolTipText);
        }

        return jLabel;
    }

    protected EmailBeanConstant getEmailConstant(VradiTreeNode node) {
        // Get node type
        Class<?> editType = node.getInternalClass();

        // get decorator
        return EmailBeanConstant.getConstantByBeanClass(editType);
    }

    protected BusinessEntity getEmailBean(EmailBeanConstant constant, String id) {
        // get decorator
        return constant.getBean((VradiDataProvider)getDataProvider(), id);
    }
}
