/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailUsersNodeLoadors.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/loadors/EmailUsersNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.loadors;

import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EmailUsersNodeLoadors extends AbstractEmailNodeLoador<User> {

    public EmailUsersNodeLoadors() {
        super(User.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Get sending of session
        List<Sending> sendings = getSendingList(dataProvider, parentId);

        // Extract clients ids
        List<String> userIds = new ArrayList<String>();
        for (Sending sending : sendings) {
            if (sending != null) {
                String userId = sending.getUser();
                userIds.add(userId);
            }
        }

        // Sort
        List<User> userSorted = VradiService.getWikittyProxy().restore(User.class, userIds);
        Collections.sort(userSorted,  VradiComparators.USER_COMPARATOR);

        // Return clients
        return extractIds(userSorted);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}
