/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: QueryCheckCellRenderer.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/query/QueryCheckCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.query;

import java.awt.Component;
import java.io.Serializable;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * QueryCheckCellRenderer is a special renderer used by {@code ThesaurusQueryChangesHandler}.
 * It render a checkbox if value is not null or a simple empty label instead.
 *
 * @author schorlet
 * @version $Revision: 1715 $ $Date: 2010-10-27 21:21:28 +0200 (mer., 27 oct. 2010) $
 * @since 6 avr. 2010 16:24:19
 */
public class QueryCheckCellRenderer extends JCheckBox implements TableCellRenderer,
        Serializable {
    
    private static final long serialVersionUID = 1L;

    final JLabel label = new JLabel();

    public QueryCheckCellRenderer() {
        super.setOpaque(true);
        label.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {

        if (value != null) {
            Boolean b = (Boolean) value;
            this.setSelected(b);
            return this;
            
        } else {
            return label;
        }
    }

}
