/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class TemplateFieldBindingUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXTENSION = "extension";
    public static final String PROPERTY_FIELDS_MODEL = "fieldsModel";
    public static final String PROPERTY_TEMPLATE = "template";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.String extension;
    protected com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected java.lang.String template;
    protected TemplateFieldBindingUI templateFieldBindingUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
                n_("vradi.table.field.name"),
                n_("vradi.table.field.name.tip"),
                n_("vradi.table.field.values"),
                n_("vradi.table.field.values.tip"));
    
        TableCellRenderer tbc = new DefaultTableCellRenderer() {
    
            @Override
            public Component getTableCellRendererComponent(JTable jTable,
                                                           Object o,
                                                           boolean b,
                                                           boolean b1,
                                                           int i,
                                                           int i1) {
    
                String sValue = null;
                if(o != null) {
                    java.util.List<String> sValues = (java.util.List<String>) o;
                    if(!sValues.isEmpty()) {
                        sValue = sValues.get(0);
                        sValue = sValue.substring(sValue.lastIndexOf(".") + 1);
                    }
                }
                return super.getTableCellRendererComponent(jTable,
                        sValue, b, b1, i, i1);
            }
        };
        JListCellRenderer renderer = new JListCellRenderer(tbc);
    
        setContextValue(renderer);
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, fieldsTable.getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, renderer);
    
        JListCellEditor editor = new JListCellEditor(true);
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
                HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TemplateFieldBindingUI() {
        $initialize();
    }

    public TemplateFieldBindingUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        this.dispose();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().saveTemplateFieldBinding(this);
    }

    public void doWindowClosing__on__templateFieldBindingUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.String getExtension() {
        return extension;
    }

    public com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public java.lang.String getTemplate() {
        return template;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExtension(java.lang.String newValue) {
        java.lang.String oldValue = this.extension;
        this.extension = newValue;
        firePropertyChange(PROPERTY_EXTENSION, oldValue, newValue);
    }

    public void setFieldsModel(com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel newValue) {
        com.jurismarches.vradi.ui.admin.models.TemplateFieldTableModel oldValue = this.fieldsModel;
        this.fieldsModel = newValue;
        firePropertyChange(PROPERTY_FIELDS_MODEL, oldValue, newValue);
    }

    public void setTemplate(java.lang.String newValue) {
        java.lang.String oldValue = this.template;
        this.template = newValue;
        firePropertyChange(PROPERTY_TEMPLATE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTemplateFieldBindingUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createExtension() {
        $objectMap.put("extension", extension = null);
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new TemplateFieldTableModel());
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createTemplate() {
        $objectMap.put("template", template = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToTemplateFieldBindingUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        fieldsTable.setModel(fieldsModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("templateFieldBindingUI", this);
        createExtension();
        createTemplate();
        createFieldsModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminFormType.template.fieldBinding.label"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.common.validate"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of templateFieldBindingUI
        setName("templateFieldBindingUI");
        SwingUtil.setComponentHeight(templateFieldBindingUI,800);
        templateFieldBindingUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminFormType.template.fieldBinding.title"));
        SwingUtil.setComponentWidth(templateFieldBindingUI,500);
        templateFieldBindingUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__templateFieldBindingUI"));
        
        $completeSetup();
    }

}