/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.spell.PlainTextDictionary;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.AbstractLuceneSpellChecker;
import org.apache.solr.util.HighFrequencyDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedSpellChecker
extends AbstractLuceneSpellChecker {
    private static final Logger log = LoggerFactory.getLogger(FileBasedSpellChecker.class);
    public static final String SOURCE_FILE_CHAR_ENCODING = "characterEncoding";
    private String characterEncoding;
    public static final String WORD_FIELD_NAME = "word";

    public String init(NamedList config, SolrCore core) {
        super.init(config, core);
        this.characterEncoding = (String)config.get(SOURCE_FILE_CHAR_ENCODING);
        return this.name;
    }

    public void build(SolrCore core, SolrIndexSearcher searcher) {
        try {
            this.loadExternalFileDictionary(core.getSchema(), core.getResourceLoader());
            this.spellChecker.clearIndex();
            this.spellChecker.indexDictionary(this.dictionary);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected IndexReader determineReader(IndexReader reader) {
        return null;
    }

    private void loadExternalFileDictionary(IndexSchema schema, SolrResourceLoader loader) {
        try {
            if (this.fieldTypeName != null && schema.getFieldTypeNoEx(this.fieldTypeName) != null) {
                FieldType fieldType = schema.getFieldTypes().get(this.fieldTypeName);
                RAMDirectory ramDir = new RAMDirectory();
                IndexWriter writer = new IndexWriter((Directory)ramDir, fieldType.getAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
                writer.setMergeFactor(300);
                writer.setMaxBufferedDocs(150);
                List<String> lines = loader.getLines(this.sourceLocation, this.characterEncoding);
                for (String s : lines) {
                    Document d = new Document();
                    d.add((Fieldable)new Field(WORD_FIELD_NAME, s, Field.Store.NO, Field.Index.TOKENIZED));
                    writer.addDocument(d);
                }
                writer.optimize();
                writer.close();
                this.dictionary = new HighFrequencyDictionary(IndexReader.open((Directory)ramDir), WORD_FIELD_NAME, 0.0f);
            } else {
                this.dictionary = this.characterEncoding == null ? new PlainTextDictionary(loader.openResource(this.sourceLocation)) : new PlainTextDictionary((Reader)new InputStreamReader(loader.openResource(this.sourceLocation), this.characterEncoding));
            }
        }
        catch (IOException e) {
            log.error("Unable to load spellings", (Throwable)e);
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

