/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.ThesaurusImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusConfirmDialogUI;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusEditUI;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusPathChooserUI;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusQueryChangesHandler;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusQueryChangesUI;
import com.jurismarches.vradi.ui.admin.query.ThesaurusChangesTreeTableModel;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusCartographyUI;
import com.jurismarches.vradi.ui.renderers.ColorsMap;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import com.sun.star.uno.RuntimeException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class AdminThesaurusHandler {
    private static Log log = LogFactory.getLog(AdminThesaurusHandler.class);
    private VradiStorageService vradiStorageService = null;

    public WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    protected AdminThesaurusUI getUI(JAXXContext context) {
        return (AdminThesaurusUI)context;
    }

    public Thesaurus getThesaurus(VradiTreeTableNode parentNode) {
        Class type = parentNode.getInternalClass();
        if (!type.equals(Thesaurus.class)) {
            return null;
        }
        String id = parentNode.getId();
        return this.getThesaurus(id);
    }

    public Thesaurus getThesaurus(String id) {
        return ThesaurusDataHelper.restoreThesaurus(id);
    }

    public RootThesaurus getRootThesaurus(VradiTreeTableNode parentNode) {
        Class type = parentNode.getInternalClass();
        if (!type.equals(RootThesaurus.class)) {
            return null;
        }
        String id = parentNode.getId();
        return this.getRootThesaurus(id);
    }

    public RootThesaurus getRootThesaurus(String id) {
        return ThesaurusDataHelper.restoreRootThesaurus(id);
    }

    protected VradiTreeTableNode getSelectedNode(ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = (VradiTreeTableNode)helper.getSelectedNode();
        if (selectedNode == null) {
            selectedNode = (VradiTreeTableNode)helper.getRootNode();
        }
        return selectedNode;
    }

    public void createRootThesaurus(JAXXContext context) {
        String rootThesaurusName = JOptionPane.showInputDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askRootThesaurusName"), I18n._((String)"vradi.adminThesaurus.askRootThesaurusTitle"), 3);
        try {
            if (rootThesaurusName != null) {
                if (!rootThesaurusName.matches("\\w+")) {
                    JOptionPane.showMessageDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.rootThesaurusInvalidName"), I18n._((String)"Error"), 0);
                } else {
                    int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askCreateRootThesaurus", (Object[])new Object[]{rootThesaurusName}), I18n._((String)"vradi.admin.saveTitle"), 0);
                    if (n == 0) {
                        if (VradiService.getVradiDataService().isRootThesaurusNameExists(rootThesaurusName)) {
                            int n2 = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{rootThesaurusName}), I18n._((String)"vradi.admin.warnTitle"), 2);
                            if (n2 == 0) {
                                this.createRootThesaurus(context);
                            }
                            return;
                        }
                        RootThesaurus newRootThesaurus = VradiService.getVradiDataService().createRootThesaurus(rootThesaurusName);
                        ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
                        UIHelper.selectNodeLater((NavHelper)helper, newRootThesaurus.getWikittyId());
                    }
                }
            }
        }
        catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create root thesaurus", (Throwable)ex);
            }
            throw new RuntimeException("Can't create root thesaurus", (Object)ex);
        }
    }

    public void createThesaurus(JAXXContext context, RootThesaurus parentRootThesaurus) {
        String name;
        ThesaurusImpl thesaurusToCreate = new ThesaurusImpl();
        String rootId = parentRootThesaurus.getWikittyId();
        thesaurusToCreate.setParent(rootId);
        thesaurusToCreate.setRootThesaurus(rootId);
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.init((Thesaurus)thesaurusToCreate, I18n._((String)"vradi.adminThesaurus.creationTitle"), true);
        if (edit.isSave().booleanValue() && (name = thesaurusToCreate.getName()) != null && !name.isEmpty()) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(rootId);
            if (VradiService.getVradiDataService().isThesaurusNameExistsInRootThesaurus(rootThesaurus, name)) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.adminThesaurus.warnTitle"), 2);
                if (n == 0) {
                    this.createThesaurus(context, parentRootThesaurus);
                }
                return;
            }
            this.getProxy().store((BusinessEntity)thesaurusToCreate);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + thesaurusToCreate.getName() + " to parent " + parentRootThesaurus.getName()));
            }
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
            UIHelper.selectNodeLater((NavHelper)helper, thesaurusToCreate.getWikittyId());
        }
    }

    public void createThesaurus(JAXXContext context, Thesaurus parentThesaurus) {
        String name;
        ThesaurusImpl thesaurusToCreate = new ThesaurusImpl();
        if (parentThesaurus == null) {
            return;
        }
        thesaurusToCreate.setParent(parentThesaurus.getWikittyId());
        thesaurusToCreate.setRootThesaurus(parentThesaurus.getRootThesaurus());
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.init((Thesaurus)thesaurusToCreate, I18n._((String)"vradi.adminThesaurus.creationTitle"), true);
        if (edit.isSave().booleanValue() && (name = thesaurusToCreate.getName()) != null && !name.isEmpty()) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(thesaurusToCreate.getRootThesaurus());
            if (VradiService.getVradiDataService().isThesaurusNameExistsInRootThesaurus(rootThesaurus, name)) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.warnTitle"), 2);
                if (n == 0) {
                    this.createThesaurus(context, parentThesaurus);
                }
                return;
            }
            this.getProxy().store((BusinessEntity)thesaurusToCreate);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + thesaurusToCreate.getName() + " to parent " + parentThesaurus.getName()));
            }
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
            UIHelper.selectNodeLater((NavHelper)helper, thesaurusToCreate.getWikittyId());
        }
    }

    public void editRootThesaurus(JAXXContext context, RootThesaurus rootThesaurus) {
        String oldName = rootThesaurus.getName();
        String name = JOptionPane.showInputDialog((Component)((Object)this.getUI(context)), (Object)I18n._((String)"vradi.adminThesaurus.askRootThesaurusEditName", (Object[])new Object[]{oldName}));
        if (name != null && !name.isEmpty()) {
            if (VradiService.getVradiDataService().isRootThesaurusNameExists(rootThesaurus.getName(), rootThesaurus.getWikittyId())) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.warnTitle"), 2);
                if (n == 0) {
                    this.editRootThesaurus(context, rootThesaurus);
                }
                return;
            }
            int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askEditRootThesaurus", (Object[])new Object[]{oldName, name}), I18n._((String)"vradi.admin.saveTitle"), 2);
            if (n == 0) {
                this.modifyQueries(context, oldName, name, null, null);
                rootThesaurus.setName(name);
                this.getProxy().store((BusinessEntity)rootThesaurus);
                ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
                UIHelper.selectNodeLater((NavHelper)helper, rootThesaurus.getWikittyId());
            }
        }
    }

    public void editThesaurus(JAXXContext context, Thesaurus thesaurus) {
        thesaurus = ThesaurusDataHelper.restoreThesaurus(thesaurus.getWikittyId());
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        String oldName = thesaurus.getName();
        edit.init(thesaurus, I18n._((String)"vradi.adminThesaurus.editTitle", (Object[])new Object[]{oldName}), false);
        if (edit.isSave().booleanValue() && oldName != null && !oldName.isEmpty()) {
            String rootId = thesaurus.getRootThesaurus();
            RootThesaurus rootThesaurus = this.getRootThesaurus(rootId);
            if (VradiService.getVradiDataService().isThesaurusNameExistsInRootThesaurus(rootThesaurus, thesaurus.getName(), thesaurus.getWikittyId())) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{oldName}), I18n._((String)"vradi.admin.warnTitle"), 2);
                if (n == 0) {
                    this.editThesaurus(context, thesaurus);
                }
                return;
            }
            String newName = thesaurus.getName();
            boolean responce = true;
            if (!oldName.equals(newName)) {
                thesaurus.setName(oldName);
                responce = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askEditThesaurus", (Object[])new Object[]{oldName, ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus)}), I18n._((String)"vradi.admin.saveTitle"));
            }
            if (responce) {
                thesaurus.setName(newName);
                this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), oldName, thesaurus.getName());
                this.getProxy().store((BusinessEntity)thesaurus);
                ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
                UIHelper.selectNodeLater((NavHelper)helper, thesaurus.getWikittyId());
            }
        }
    }

    public void moveThesaurus(JAXXContext context, Thesaurus thesaurus) {
        VradiTreeTableNode selectedNode;
        String id;
        boolean responce;
        thesaurus = ThesaurusDataHelper.restoreThesaurus(thesaurus.getWikittyId());
        String rootThesaurusId = thesaurus.getRootThesaurus();
        RootThesaurus rootThesaurus = this.getRootThesaurus(rootThesaurusId);
        ThesaurusTreeTableHelper selectHelper = new ThesaurusTreeTableHelper(rootThesaurus);
        ThesaurusPathChooserUI selectUI = new ThesaurusPathChooserUI(context, selectHelper);
        selectUI.setVisible(true);
        if (selectUI.isSaved().booleanValue() && (responce = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askMoveThesaurus", (Object[])new Object[]{thesaurus.getName()}), I18n._((String)"vradi.adminThesaurus.moveTitle"))) && !(id = (selectedNode = this.getSelectedNode(selectHelper)).getId()).equals(thesaurus.getParent())) {
            thesaurus.setParent(id);
            this.getProxy().store((BusinessEntity)thesaurus);
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
            UIHelper.selectNodeLater((NavHelper)helper, thesaurus.getWikittyId());
        }
    }

    public void deleteRootThesaurus(JAXXContext context, RootThesaurus rootThesaurus) {
        int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askDeleteRootThesaurus", (Object[])new Object[]{rootThesaurus.getName()}), I18n._((String)"vradi.admin.deleteTitle"), 2);
        if (n == 0) {
            try {
                VradiService.getVradiDataService().deleteThesaurus(rootThesaurus.getWikittyId());
            }
            catch (VradiException ex) {
                throw new RuntimeException("Can't delete thesaurus", (Object)ex);
            }
        }
    }

    public boolean deleteThesaurus(JAXXContext context, Thesaurus thesaurus) {
        boolean response = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askDeleteThesaurus", (Object[])new Object[]{thesaurus.getName(), ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus)}), I18n._((String)"vradi.admin.deleteTitle"));
        if (response) {
            String parentId = thesaurus.getParent();
            try {
                List childrenList = VradiService.getVradiDataService().deleteThesaurus(thesaurus.getWikittyId());
                RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus());
                this.modifyDeleteRequest(context, rootThesaurus, thesaurus, childrenList);
                ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
                UIHelper.selectNodeLater((NavHelper)helper, parentId);
            }
            catch (VradiException ex) {
                throw new RuntimeException("Can't delete thesaurus", (Object)ex);
            }
            return true;
        }
        return false;
    }

    protected void modifyDeleteRequest(JAXXContext context, RootThesaurus rootThesaurus, Thesaurus thesaurus, List<String> childrenList) {
        for (String childId : childrenList) {
            Thesaurus child = ThesaurusDataHelper.restoreThesaurus(childId);
            if (ThesaurusDataHelper.isFirstChild(child)) {
                this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), child.getName(), null);
                return;
            }
            Thesaurus parent = null;
            String parentId = thesaurus.getParent();
            while (childrenList.contains(parentId)) {
                parent = ThesaurusDataHelper.restoreThesaurus(parentId);
                if (ThesaurusDataHelper.isFirstChild(parent)) {
                    this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), child.getName(), null);
                    return;
                }
                parentId = parent.getParent();
            }
            this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), child.getName(), parent == null ? null : parent.getName());
        }
    }

    public void addChildThesaurusToSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.createThesaurus(context, rootThesaurus);
            return;
        }
        this.createThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void editThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.editRootThesaurus(context, rootThesaurus);
            return;
        }
        this.editThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void deleteThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.deleteRootThesaurus(context, rootThesaurus);
            return;
        }
        this.deleteThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void moveThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        Thesaurus thesaurus = this.getThesaurus(selectedNode);
        this.moveThesaurus(context, thesaurus);
    }

    public boolean showThesaurusConfirmDialog(JAXXContext context, Thesaurus concerned, String title, String msg) {
        ThesaurusConfirmDialogUI condirmDialogUI = new ThesaurusConfirmDialogUI(context);
        condirmDialogUI.init(concerned, title, msg);
        return condirmDialogUI.isSave();
    }

    public void showApply(JAXXContext context, Thesaurus concerned) {
        UIHelper.getHandler(context, AdminHandler.class).openRequest(context, concerned);
    }

    protected void modifyQueries(JAXXContext context, String rootThesaurusBefore, String rootThesaurusAfter, String thesaurusBefore, String thesaurusAfter) {
        Map queryMakers = VradiService.getVradiStorageService().getQueriesToModifyAfterThesaurusModification(rootThesaurusBefore, thesaurusBefore);
        if (queryMakers.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ModifyQueries] Query makers are empty for thesaurus : " + rootThesaurusBefore + ":" + thesaurusBefore));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ModifyQueries] Query makers are not empty for thesaurus : " + rootThesaurusBefore + ":" + thesaurusBefore + " will show modification UI"));
        }
        ThesaurusQueryChangesHandler handler = new ThesaurusQueryChangesHandler();
        ThesaurusQueryChangesUI thesaurusChangesUI = handler.initUI(context, queryMakers, rootThesaurusBefore, rootThesaurusAfter, thesaurusBefore, thesaurusAfter);
        thesaurusChangesUI.setModifiedQueries(Boolean.FALSE);
        thesaurusChangesUI.setVisible(true);
        if (!thesaurusChangesUI.isModifiedQueries().booleanValue()) {
            return;
        }
        try {
            ThesaurusChangesTreeTableModel model = thesaurusChangesUI.getContextValue(ThesaurusChangesTreeTableModel.class);
            List<Group> updatedQueryMakers = model.getUpdatedQueryMakers();
            VradiService.getWikittyProxy().store(updatedQueryMakers);
            if (log.isDebugEnabled()) {
                log.debug((Object)"[ModifyQueries] Store modifications");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void changeThesaurusColor(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        Thesaurus selected = this.getThesaurus(selectedNode);
        int depth = ThesaurusDataHelper.getDepth(selected);
        Color initialColor = ColorsMap.getInstance().get(depth);
        Color colorChoosed = JColorChooser.showDialog((Component)((Object)((AdminThesaurusUI)context)), I18n._((String)"vradi.thesaurus.colorTitle"), initialColor);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Store color " + colorChoosed + " for depth " + depth));
        }
        VradiHelper.storeThesaurusColor(depth, colorChoosed);
        this.reinitColors();
    }

    public void reinitColors() {
        ColorsMap.getInstance().updateColors();
    }

    public void exportThesaurusCSV(AdminThesaurusUI adminThesaurusUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminThesaurus.exportThesaurusTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminThesaurus.exportButtonText"));
                int returnVal = chooser.showOpenDialog((Component)((Object)adminThesaurusUI));
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporting thesaurus to : " + selectedFile.getAbsolutePath()));
                    }
                    Search search = Search.query().eq(Element.ELT_EXTENSION, "TreeNode");
                    Criteria criteria = search.criteria();
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String vscContent = vradiStorageService.exportAsCSV(criteria);
                    FileUtils.writeStringToFile((File)selectedFile, (String)vscContent);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't export thesaurus", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't export thesaurus", (Throwable)eee);
            }
        }
    }

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }

    public void importCSV(AdminThesaurusUI adminThesaurusUI) {
        block7: {
            int response = JOptionPane.showConfirmDialog((Component)((Object)adminThesaurusUI), I18n._((String)"Warning all your thesaurus will be deleted before new import. Do you want to continue ?"), I18n._((String)"Confirm thesaurus deletion"), 2);
            if (response != 0) {
                return;
            }
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminThesaurus.importTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminThesaurus.importButtonText"));
                int returnVal = chooser.showOpenDialog((Component)((Object)adminThesaurusUI));
                if (returnVal == 0) {
                    VradiService.getVradiDataService().deleteAllThesaurus();
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Importing file : " + selectedFile.getAbsolutePath()));
                    }
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String uri = VradiService.getFileService().uploadTempFile(selectedFile);
                    vradiStorageService.importAsCSV(uri);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import file", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Can't import file", (Throwable)eee);
            }
        }
    }

    public static class CopyToClipboard
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected AdminThesaurusUI thesaurusUI;
        protected ThesaurusCartographyUI thesaurusCartography;

        public CopyToClipboard(AdminThesaurusUI thesaurusUI) {
            super(I18n._((String)"vradi.common.copy"));
            this.thesaurusUI = thesaurusUI;
            JXTreeTable treeTable = thesaurusUI.getThesaurus();
            InputMap inputMap = treeTable.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), "ThesaurusHandler.CopyToClipboard");
            ActionMap actionMap = treeTable.getActionMap();
            actionMap.put("ThesaurusHandler.CopyToClipboard", this);
        }

        public CopyToClipboard(ThesaurusCartographyUI thesaurusCartography) {
            super(I18n._((String)"vradi.common.copy"));
            this.thesaurusCartography = thesaurusCartography;
            JXTreeTable treeTable = thesaurusCartography.getCartographyTable();
            InputMap inputMap = treeTable.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), "ThesaurusHandler.CopyToClipboard");
            ActionMap actionMap = treeTable.getActionMap();
            actionMap.put("ThesaurusHandler.CopyToClipboard", this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Thesaurus selectedThesaurus = null;
            if (this.thesaurusUI != null) {
                ThesaurusTreeTableHelper helper = this.thesaurusUI.helper;
                VradiTreeTableNode selectedNode = (VradiTreeTableNode)helper.getSelectedNode();
                if (selectedNode == null || selectedNode.isRoot()) {
                    return;
                }
                String id = selectedNode.getId();
                selectedThesaurus = (Thesaurus)VradiService.getWikittyProxy().restore(Thesaurus.class, id);
            } else {
                int selectedRow = this.thesaurusCartography.getCartographyTable().getSelectedRow();
                Object selected = this.thesaurusCartography.getCartographyTable().getValueAt(selectedRow, 0);
                if (!(selected instanceof Thesaurus)) {
                    return;
                }
                selectedThesaurus = (Thesaurus)selected;
            }
            if (selectedThesaurus == null) {
                return;
            }
            RootThesaurus rootThesaurus = (RootThesaurus)VradiService.getWikittyProxy().restore(RootThesaurus.class, selectedThesaurus.getRootThesaurus());
            String name = "\"" + selectedThesaurus.getName() + "\"";
            StringSelection selection = new StringSelection(rootThesaurus.getName() + ":" + name);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
    }
}

