/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.nuiton.util.beans.Binder;

public class BinderModel<S, T>
implements Serializable {
    protected final Class<S> sourceType;
    protected final Class<T> targetType;
    protected final Map<String, PropertyDescriptor> sourceDescriptors;
    protected final Map<String, PropertyDescriptor> targetDescriptors;
    protected final Map<String, String> propertiesMapping;
    protected Map<String, Binder.CollectionStrategy> collectionStrategies;
    protected Map<String, Binder<?, ?>> binders;
    private static final long serialVersionUID = 2L;

    public BinderModel(Class<S> sourceType, Class<T> targetType) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.sourceDescriptors = new TreeMap<String, PropertyDescriptor>();
        this.targetDescriptors = new TreeMap<String, PropertyDescriptor>();
        this.propertiesMapping = new TreeMap<String, String>();
        this.collectionStrategies = new TreeMap<String, Binder.CollectionStrategy>();
        this.binders = new TreeMap();
    }

    public Class<S> getSourceType() {
        return this.sourceType;
    }

    public Class<T> getTargetType() {
        return this.targetType;
    }

    public String[] getSourceDescriptors() {
        Set<String> universe = this.sourceDescriptors.keySet();
        return universe.toArray(new String[this.sourceDescriptors.size()]);
    }

    public Binder.CollectionStrategy getCollectionStrategy(String property) {
        return this.collectionStrategies.get(property);
    }

    public String[] getTargetDescriptors() {
        Set<String> universe = this.targetDescriptors.keySet();
        return universe.toArray(new String[this.targetDescriptors.size()]);
    }

    public String getTargetProperty(String sourceProperty) {
        if (!this.containsSourceProperty(sourceProperty)) {
            return null;
        }
        String dstProperty = this.propertiesMapping.get(sourceProperty);
        return dstProperty;
    }

    public PropertyDescriptor getSourceDescriptor(String sourceProperty) {
        if (!this.containsSourceProperty(sourceProperty)) {
            return null;
        }
        PropertyDescriptor descriptor = this.sourceDescriptors.get(sourceProperty);
        return descriptor;
    }

    public Method getSourceReadMethod(String srcProperty) {
        PropertyDescriptor descriptor = this.getSourceDescriptor(srcProperty);
        Method readMethod = null;
        if (descriptor != null) {
            readMethod = descriptor.getReadMethod();
        }
        return readMethod;
    }

    public Method getSourceWriteMethod(String sourceProperty) {
        PropertyDescriptor descriptor = this.getSourceDescriptor(sourceProperty);
        Method writeMethod = null;
        if (descriptor != null) {
            writeMethod = descriptor.getWriteMethod();
        }
        return writeMethod;
    }

    public PropertyDescriptor getTargetDescriptor(String targetProperty) {
        if (!this.containsTargetProperty(targetProperty)) {
            return null;
        }
        PropertyDescriptor descriptor = this.targetDescriptors.get(targetProperty);
        return descriptor;
    }

    public Method getTargetReadMethod(String targetProperty) {
        PropertyDescriptor descriptor = this.getTargetDescriptor(targetProperty);
        Method readMethod = null;
        if (descriptor != null) {
            readMethod = descriptor.getReadMethod();
        }
        return readMethod;
    }

    public Method getTargetWriteMethod(String targetProperty) {
        PropertyDescriptor descriptor = this.getTargetDescriptor(targetProperty);
        Method writeMethod = null;
        if (descriptor != null) {
            writeMethod = descriptor.getWriteMethod();
        }
        return writeMethod;
    }

    public Class<?> getCollectionType(String sourceProperty) {
        Method method = this.getSourceReadMethod(sourceProperty);
        Class<?> type = method.getReturnType();
        if (Collection.class.isAssignableFrom(type)) {
            return type;
        }
        return null;
    }

    public void addCollectionStrategy(String propertyName, Binder.CollectionStrategy strategy) {
        this.collectionStrategies.put(propertyName, strategy);
    }

    public void addBinder(String propertyName, Binder<?, ?> binder) {
        this.binders.put(propertyName, binder);
    }

    protected boolean containsSourceProperty(String sourceProperty) {
        return this.propertiesMapping.containsKey(sourceProperty);
    }

    protected boolean containsTargetProperty(String targetProperty) {
        return this.propertiesMapping.containsValue(targetProperty);
    }

    protected boolean containsCollectionProperty(String propertyName) {
        return this.collectionStrategies.containsKey(propertyName);
    }

    protected boolean containsBinderProperty(String propertyName) {
        return this.binders.containsKey(propertyName);
    }

    protected void addBinding(PropertyDescriptor sourceDescriptor, PropertyDescriptor targetDescriptor) {
        String sourceProperty = sourceDescriptor.getName();
        String targetProperty = targetDescriptor.getName();
        this.sourceDescriptors.put(sourceProperty, sourceDescriptor);
        this.targetDescriptors.put(targetProperty, targetDescriptor);
        this.propertiesMapping.put(sourceProperty, targetProperty);
    }

    protected Map<String, String> getPropertiesMapping() {
        return this.propertiesMapping;
    }

    public Binder<?, ?> getBinder(String sourceProperty) {
        return this.binders.get(sourceProperty);
    }
}

