/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueFloat
extends Value {
    static final int PRECISION = 7;
    static final int DISPLAY_SIZE = 15;
    private static final float FLOAT_ZERO = 0.0f;
    private static final float FLOAT_ONE = 1.0f;
    private static final ValueFloat ZERO = new ValueFloat(0.0f);
    private static final ValueFloat ONE = new ValueFloat(1.0f);
    private final float value;

    private ValueFloat(float f) {
        this.value = f;
    }

    public Value add(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.value + valueFloat.value);
    }

    public Value subtract(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.value - valueFloat.value);
    }

    public Value negate() {
        return ValueFloat.get(-this.value);
    }

    public Value multiply(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.value * valueFloat.value);
    }

    public Value divide(Value value) throws SQLException {
        ValueFloat valueFloat = (ValueFloat)value;
        if ((double)valueFloat.value == 0.0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueFloat.get(this.value / valueFloat.value);
    }

    public String getSQL() {
        if (this.value == Float.POSITIVE_INFINITY) {
            return "POWER(0, -1)";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "(-POWER(0, -1))";
        }
        if (Double.isNaN(this.value)) {
            return "SQRT(-1)";
        }
        return this.getString();
    }

    public int getType() {
        return 8;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueFloat valueFloat = (ValueFloat)value;
        return Float.compare(this.value, valueFloat.value);
    }

    public int getSignum() {
        return this.value == 0.0f ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    public float getFloat() {
        return this.value;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 7L;
    }

    public int getScale() {
        return 0;
    }

    public int hashCode() {
        long l = Float.floatToIntBits(this.value);
        return (int)(l ^ l >> 32);
    }

    public Object getObject() {
        return Float.valueOf(this.value);
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setFloat(n, this.value);
    }

    public static ValueFloat get(float f) {
        if (0.0f == f) {
            return ZERO;
        }
        if (1.0f == f) {
            return ONE;
        }
        return (ValueFloat)Value.cache(new ValueFloat(f));
    }

    public int getDisplaySize() {
        return 15;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueFloat)) {
            return false;
        }
        return this.compareSecure((ValueFloat)object, null) == 0;
    }
}

