/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Message;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class AckReceiverWindowStressTest {
    static final int NUM_MSGS = 1000000;
    static final int NUM_THREADS = 50;
    static final int SEGMENT_SIZE = 50000;

    @Test
    public static void stressTest() {
        AckReceiverWindowStressTest.start(50, 1000000, 50000);
    }

    private static void start(int num_threads, int num_msgs, int segment_size) {
        AckReceiverWindow win = new AckReceiverWindow(1L, segment_size);
        AtomicInteger counter = new AtomicInteger(num_msgs);
        AtomicLong seqno = new AtomicLong(1L);
        AtomicInteger removed_msgs = new AtomicInteger(0);
        CountDownLatch latch = new CountDownLatch(1);
        Adder[] adders = new Adder[num_threads];
        for (int i = 0; i < adders.length; ++i) {
            adders[i] = new Adder(win, latch, counter, seqno, removed_msgs);
            adders[i].start();
        }
        long start = System.currentTimeMillis();
        latch.countDown();
        for (Adder adder : adders) {
            try {
                adder.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < 50 && removed_msgs.get() < num_msgs; ++i) {
            System.out.println("removed: " + removed_msgs.get());
            Util.sleep(100L);
            List<Message> msgs = win.removeManyAsList(segment_size);
            if (msgs == null || msgs.isEmpty()) continue;
            removed_msgs.addAndGet(msgs.size());
        }
        long time = System.currentTimeMillis() - start;
        double requests_sec = (double)num_msgs / ((double)time / 1000.0);
        System.out.println("\nTime: " + time + " ms, " + Util.format(requests_sec) + " requests / sec\n");
        System.out.println("Total removed messages: " + removed_msgs);
        assert (removed_msgs.get() == num_msgs) : "removed messages (" + removed_msgs.get() + ") != num_msgs (" + num_msgs + ")";
    }

    @Test(enabled=false)
    public static void main(String[] args) {
        int num_threads = 50;
        int num_msgs = 1000000;
        int segment_size = 20000;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num_threads")) {
                num_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-num_msgs")) {
                num_msgs = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-segment_size")) {
                segment_size = Integer.parseInt(args[++i]);
                continue;
            }
            System.out.println("AckReceiverWindowStressTest [-num_msgs msgs] [-num_threads threads] [-segment_size <size>]");
            return;
        }
        AckReceiverWindowStressTest.start(num_threads, num_msgs, segment_size);
    }

    static class Adder
    extends Thread {
        final AckReceiverWindow win;
        final CountDownLatch latch;
        final AtomicInteger num_msgs;
        final AtomicLong current_seqno;
        final AtomicInteger removed_msgs;
        static final AtomicBoolean processing = new AtomicBoolean(false);

        public Adder(AckReceiverWindow win, CountDownLatch latch, AtomicInteger num_msgs, AtomicLong current_seqno, AtomicInteger removed_msgs) {
            this.win = win;
            this.latch = latch;
            this.num_msgs = num_msgs;
            this.current_seqno = current_seqno;
            this.removed_msgs = removed_msgs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            Message msg = new Message(false);
            while (this.num_msgs.getAndDecrement() > 0) {
                long seqno = this.current_seqno.getAndIncrement();
                byte result = this.win.add2(seqno, msg);
                if (result != 1) {
                    System.err.println("seqno " + seqno + " not added correctly");
                }
                if (!processing.compareAndSet(false, true)) continue;
                try {
                    List<Message> msgs;
                    while ((msgs = this.win.removeManyAsList(20000)) != null && !msgs.isEmpty()) {
                        this.removed_msgs.addAndGet(msgs.size());
                    }
                }
                finally {
                    processing.set(false);
                }
            }
        }
    }
}

