/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class VradiHelper {
    private static final Log log = LogFactory.getLog(VradiHelper.class);
    public static final String TYPE_DESCRIPTION = "description";
    public static final String TYPE_RANK = "rank";
    public static final String TYPE_LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String TYPE_LAST_MODIFIED_TIME = "lastModifiedTime";
    public static final String TYPE_LAST_MODIFIED_BY = "lastModifiedBy";
    @Deprecated
    public static final String TYPE_TEMPLATE = "template";

    public static VradiConfig getVradiConfig() {
        return VradiContext.get().getVradiConfig();
    }

    public static List<Sending> getAllSending(Session session) {
        ArrayList sendingIds = new ArrayList(session.getSending());
        WikittyProxy proxy = VradiService.getWikittyProxy();
        return proxy.restore(Sending.class, sendingIds);
    }

    public static List<User> getUsersSendingConcernedBy(Session session, Form form) {
        ArrayList<User> result = new ArrayList<User>();
        for (Sending sending : VradiHelper.getAllSending(session)) {
            Set formsIds = sending.getForm();
            if (formsIds == null || !formsIds.contains(form.getWikittyId()) || sending.getUser() == null) continue;
            String userId = sending.getUser();
            User user = (User)VradiService.getWikittyProxy().restore(User.class, userId);
            result.add(user);
        }
        Collections.sort(result, VradiComparators.USER_COMPARATOR);
        return result;
    }

    public static List<Group> getGroupsSendingConcernedBy(Session session, Form form) {
        ArrayList<Group> result = new ArrayList<Group>();
        for (Sending sending : VradiHelper.getAllSending(session)) {
            Set formsIds = sending.getForm();
            if (formsIds == null || !formsIds.contains(form.getWikittyId()) || sending.getGroup() == null) continue;
            String groupId = sending.getGroup();
            Group group = (Group)VradiService.getWikittyProxy().restore(Group.class, groupId);
            result.add(group);
        }
        Collections.sort(result, VradiComparators.GROUP_COMPARATOR);
        return result;
    }

    public static Status getSelectionneStatus() {
        Search search;
        Criteria criteria;
        Status validatedStatus;
        WikittyProxy proxy = VradiService.getWikittyProxy();
        VradiConstants.FormStatus type = VradiConstants.FormStatus.SELECTIONNE;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getOrCreateStatus(" + type.getName() + ")"));
        }
        if ((validatedStatus = (Status)proxy.findByCriteria(Status.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "Status").eq("Status.name", type.getName())).criteria())) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Status not found creating : " + type.getName()));
            }
            validatedStatus = new StatusImpl();
            validatedStatus.setName(type.getName());
            validatedStatus.setValue(type.getValue());
            validatedStatus.setDescription(type.getDescription());
            validatedStatus.setModifiable(false);
            validatedStatus = (Status)proxy.store((BusinessEntity)validatedStatus);
        }
        return validatedStatus;
    }

    protected static List<String> stringToList(String string) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)string)) {
            String[] items;
            for (String item : items = StringUtil.split((String)string, (String)",")) {
                resultList.add(item);
            }
        }
        return resultList;
    }

    public static void addRequestToProperties(String query) {
        List<String> result = VradiHelper.loadRequests();
        if (!result.contains(query)) {
            result.add(0, query);
            String queries = StringUtils.join(result, (String)",");
            VradiHelper.getVradiConfig().setQueries(queries);
        }
    }

    public static List<String> loadRequests() {
        String queries = VradiHelper.getVradiConfig().getQueries();
        List<String> result = VradiHelper.stringToList(queries);
        return result;
    }

    public static List<String> getVradiListCriteria() {
        String criterias = VradiHelper.getVradiConfig().getCriterias();
        List<String> result = VradiHelper.stringToList(criterias);
        return result;
    }

    public static void addVradiListCriteria(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListCriteria();
        result.add(value.getWikittyId());
        String criterias = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setCriterias(criterias);
    }

    public static void removeVradiListCriteria(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListCriteria();
        result.remove(value.getWikittyId());
        String criterias = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setCriterias(criterias);
    }

    public static List<String> getVradiListRootCriteria() {
        String criterias = VradiHelper.getVradiConfig().getRootCriterias();
        List<String> result = VradiHelper.stringToList(criterias);
        return result;
    }

    public static void addVradiListRootCriteria(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListRootCriteria();
        result.add(value.getWikittyId());
        String criterias = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setRootCriterias(criterias);
    }

    public static void removeVradiListRootCriteria(RootThesaurus value) {
        List<String> result = VradiHelper.getVradiListRootCriteria();
        result.remove(value.getWikittyId());
        String criterias = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setRootCriterias(criterias);
    }

    public static List<String> getVradiListRootThesaurus() {
        String rootThesaurus = VradiHelper.getVradiConfig().getRootThesaurus();
        List<String> result = VradiHelper.stringToList(rootThesaurus);
        return result;
    }

    public static void removeVradiListRootThesaurus(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListRootThesaurus();
        result.remove(value.getWikittyId());
        String rootThesaurus = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setRootThesaurus(rootThesaurus);
    }

    public static void addVradiListRootThesaurus(RootThesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListRootThesaurus();
        result.add(value.getWikittyId());
        String rootThesaurus = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setRootThesaurus(rootThesaurus);
    }

    public static List<String> getVradiListThesaurus() {
        String rootThesaurus = VradiHelper.getVradiConfig().getThesaurus();
        List<String> result = VradiHelper.stringToList(rootThesaurus);
        return result;
    }

    public static void removeVradiListThesaurus(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListThesaurus();
        result.remove(value.getWikittyId());
        String thesaurus = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setThesaurus(thesaurus);
    }

    public static void addVradiListThesaurus(Thesaurus value) {
        if (value == null) {
            return;
        }
        List<String> result = VradiHelper.getVradiListThesaurus();
        result.add(value.getWikittyId());
        String thesaurus = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setThesaurus(thesaurus);
    }

    public static List<String> getVradiListColumns() {
        String columns = VradiHelper.getVradiConfig().getOfferColumns();
        List<String> result = VradiHelper.stringToList(columns);
        return result;
    }

    public static void removeVradiListColumns(String columnName) {
        List<String> result = VradiHelper.getVradiListColumns();
        result.remove(columnName);
        String columns = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setOfferColumns(columns);
    }

    public static void addVradiListColumns(String columnName) {
        List<String> result = VradiHelper.getVradiListColumns();
        result.add(columnName);
        String columns = StringUtils.join(result, (char)',');
        VradiHelper.getVradiConfig().setOfferColumns(columns);
    }

    public static Map<Integer, Color> getColorsThesaurus() {
        HashMap<Integer, Color> levelsAndColors = new HashMap<Integer, Color>();
        String thesaurusColors = VradiHelper.getVradiConfig().getThesaurusColors();
        if (StringUtils.isNotEmpty((String)thesaurusColors)) {
            String[] thesaurusColorsItems;
            for (String thesaurusColorsItem : thesaurusColorsItems = StringUtil.split((String)thesaurusColors, (String)",")) {
                if (thesaurusColorsItem.indexOf(61) <= 0) continue;
                String[] levelAndColor = thesaurusColorsItem.split("=|;");
                Integer level = Integer.parseInt(levelAndColor[0]);
                Color color = new Color(Integer.parseInt(levelAndColor[1]), Integer.parseInt(levelAndColor[2]), Integer.parseInt(levelAndColor[3]));
                levelsAndColors.put(level, color);
            }
        }
        if (levelsAndColors.isEmpty()) {
            Color[] colors = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
            for (int level = 0; level < colors.length; ++level) {
                levelsAndColors.put(level, colors[level]);
            }
        }
        return levelsAndColors;
    }

    public static void storeThesaurusColor(int level, Color color) {
        Map<Integer, Color> levelsAndColors = VradiHelper.getColorsThesaurus();
        levelsAndColors.put(level, color);
        StringBuilder levelAndColorConf = new StringBuilder("");
        for (Map.Entry<Integer, Color> entry : levelsAndColors.entrySet()) {
            String stringLevel = entry.getKey().toString();
            String stringColor = entry.getValue().getRed() + ";" + entry.getValue().getGreen() + ";" + entry.getValue().getBlue();
            levelAndColorConf.append(stringLevel);
            levelAndColorConf.append("=");
            levelAndColorConf.append(stringColor);
            levelAndColorConf.append(",");
        }
        VradiHelper.getVradiConfig().setThesaurusColors(levelAndColorConf.toString());
    }

    public static boolean isOnClickThesaurusExpanded() {
        boolean result = VradiHelper.getVradiConfig().isOnClickThesaurusExpanded();
        return result;
    }

    public static void storeOnClickThesaurusExpanded(boolean expendSelected) {
        VradiHelper.getVradiConfig().setOnClickThesaurusExpanded(expendSelected);
    }

    public static String getEntityName(Object o) {
        if (o == null) {
            return "";
        }
        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)o, (String)"name");
            if (descriptor == null) {
                return "";
            }
            Method getter = descriptor.getReadMethod();
            Object invoke = getter.invoke(o, new Object[0]);
            if (invoke == null) {
                return "";
            }
            String result = (String)invoke;
            return result;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        return "";
    }

    public static FieldTypeEnum getFieldTypeEnum(FieldType type) {
        for (FieldTypeEnum typeEnum : FieldTypeEnum.values()) {
            if (!typeEnum.isType(type)) continue;
            return typeEnum;
        }
        return null;
    }

    public static String getFormTypeTemplate(WikittyExtension extension) {
        String result = extension == null ? null : extension.getTagValue(TYPE_TEMPLATE);
        return result;
    }

    public static FormPagedResult executeQuery(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, String streamId, List<String> thesaurus, String[] statusIds, FormPagedResult formPagedResult) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)query);
            }
            formPagedResult.setFormsToShow(null);
            formPagedResult.setTotalFoundFormNb(0);
            if (formPagedResult.getNbFormsToShow() == 0) {
                formPagedResult.setNbFormsToShow(10);
            }
            if (formPagedResult.getPageToShow() == 0) {
                formPagedResult.setPageToShow(1);
            }
            formPagedResult = VradiService.getVradiDataService().findForms(query, extension, dateType, beginDate, endDate, streamId, thesaurus, statusIds, formPagedResult);
            if (log.isDebugEnabled()) {
                log.debug((Object)(formPagedResult.getTotalFoundFormNb() + " forms found"));
                for (Form form : formPagedResult.getFormsToShow()) {
                    log.debug((Object)(form.getWikittyId() + " : " + form.getObjet()));
                }
            }
        }
        catch (VradiException eee) {
            log.error((Object)"Cant execute query : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
            formPagedResult = new FormPagedResult();
        }
        catch (UnsupportedQueryException e) {
            log.error((Object)e.getMessage());
            ErrorDialogUI.showError((Exception)((Object)e));
            formPagedResult = new FormPagedResult();
        }
        return formPagedResult;
    }

    public static String getFieldTypeDescription(FieldType fieldType) {
        return fieldType == null ? null : fieldType.getTagValue(TYPE_DESCRIPTION);
    }

    public static int getFieldTypeRank(FieldType fieldType) {
        int result;
        try {
            result = Integer.valueOf(fieldType.getTagValue(TYPE_RANK));
        }
        catch (NumberFormatException eee) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no tag value for rank");
            }
            result = -1;
        }
        return result;
    }

    public static boolean isVersionNewer(String version) {
        String lastVersion = VradiHelper.getVradiConfig().getLastVersion();
        if (StringUtils.isEmpty((String)lastVersion)) {
            return true;
        }
        String[] versionToken = version.split("\\.");
        String[] lastVersionToken = lastVersion.split("\\.");
        for (int i = 0; i < versionToken.length && i < lastVersionToken.length; ++i) {
            if (Integer.valueOf(versionToken[i]) > Integer.valueOf(lastVersionToken[i])) {
                return true;
            }
            if (Integer.valueOf(versionToken[i]) >= Integer.valueOf(lastVersionToken[i])) continue;
            return false;
        }
        return false;
    }

    public static List<String> extractIds(List<? extends BusinessEntity> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        for (BusinessEntity businessEntity : beans) {
            ids.add(businessEntity.getWikittyId());
        }
        return ids;
    }
}

