package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_THESAURUS_SELECTED = "thesaurusSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_EDIT_ENABLED = "edit.enabled";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusUI adminThesaurusUI = this;
    protected javax.swing.JButton create;
    protected javax.swing.JButton createNewRoot;
    protected javax.swing.JButton delete;
    protected javax.swing.JButton edit;
    protected javax.swing.JCheckBox expandByDefault;
    protected java.lang.Boolean modified;
    protected java.lang.Boolean selected;
    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected java.lang.Boolean thesaurusSelected;
    protected jaxx.runtime.swing.HBox toolBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ThesaurusTreeTableHelper helper;
    
    
    public  AdminThesaurusUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
    //    setContextValue(new ModifThesaurusModel(this, helper));
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
        final Action copyToClipboard = new AdminThesaurusHandler.CopyToClipboard(this);
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
    
    
                JPopupMenu popup = new JPopupMenu();
    
                // Add mouse listener to enable menus
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
    
                    // Add mouse listener to enable menus
                    JMenuItem menuAddRootChild = new JMenuItem();
                    menuAddRootChild.setText(_("vradi.menu.addRootChildThesaurus"));
                    menuAddRootChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                             createNewRoot();
                        }
                    });
                    popup.add(menuAddRootChild);
    
                    JMenuItem menuAddChild = new JMenuItem();
                    menuAddChild.setText(_("vradi.menu.addChildThesaurus"));
                    menuAddChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                            addChildToSelected();
                        }
                    });
                    popup.add(menuAddChild);
    
                    JMenuItem menuRenameSelected = new JMenuItem();
                    menuRenameSelected.setText(_("vradi.menu.editThesaurusSelected"));
                    menuRenameSelected.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            editSelected();
                        }
                    });
                    popup.add(menuRenameSelected);
    
                    JMenuItem menuDeleteSeleted = new JMenuItem();
                    menuDeleteSeleted.setText(_("vradi.menu.deleteThesaurusSelected"));
                    menuDeleteSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            deleteSelected();
                        }
                    });
                    popup.add(menuDeleteSeleted);
    
                    if (isThesaurusSelected()) {
                        JMenuItem menuMoveSeleted = new JMenuItem();
                        menuMoveSeleted.setText(_("vradi.menu.moveThesaurusSelected"));
                        menuMoveSeleted.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                moveSelected();
                            }
                        });
                        popup.add(menuMoveSeleted);
                    }
    
                    JMenuItem menuChangeColorSeleted = new JMenuItem();
                    menuChangeColorSeleted.setText(_("vradi.menu.menuChangeColorSeleted"));
                    menuChangeColorSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            changeColorSelected();
                        }
                    });
                    popup.add(menuChangeColorSeleted);
    
                    popup.add(copyToClipboard);
    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        TreeSelectionListener listener = new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
    
                // Get selcted node
                VradiTreeTableNode selectedNode = (VradiTreeTableNode)e.getPath().getLastPathComponent();
    
                // Set as selected
                setSelected(selectedNode != null);
    
                // Is thesaurus
                setThesaurusSelected(isSelected() &&
                        Thesaurus.class.equals(selectedNode.getInternalClass()));
            }
        };
    
        // Register tree table
        helper.setUI(thesaurus, true, false, listener);
    
        // Single selection mode
        thesaurus.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    
        // Expend on click
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.EDIT));
    }
    
    protected void createNewRoot(){
        // Ajout dun nouveau root thesaurus
        getThesaurusHandler().createRootThesaurus(this);
    }
    
    protected void addChildToSelected(){
        // Ajout dun nouveau thesaurus
        getThesaurusHandler().addChildThesaurusToSelected(this, helper);
    }
    
    protected void editSelected(){
        // Edition dun thesaurus
        getThesaurusHandler().editThesaurusSelected(this, helper);
    }
    
    protected void deleteSelected(){
        // Suppression dun thesaurus
        getThesaurusHandler().deleteThesaurusSelected(this, helper);
    }
    
    protected void moveSelected(){
        // Move thesaurus
        getThesaurusHandler().moveThesaurusSelected(this, helper);
    }
    
    protected void changeColorSelected(){
        // Change color af selected detph
        getThesaurusHandler().changeThesaurusColor(this, helper);
    }
    
    protected void setExpandByDefault(){
        VradiHelper.storeOnClickThesaurusExpanded(expandByDefault.isSelected());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminThesaurusUI() {
        $initialize();
    }

    public AdminThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getThesaurusHandler().importCSV(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getThesaurusHandler().exportThesaurusCSV(this);
    }

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        addChildToSelected();
    }

    public void doActionPerformed__on__createNewRoot(java.awt.event.ActionEvent event) {
        createNewRoot();
    }

    public void doActionPerformed__on__delete(java.awt.event.ActionEvent event) {
        deleteSelected();
    }

    public void doActionPerformed__on__edit(java.awt.event.ActionEvent event) {
        editSelected();
    }

    public void doActionPerformed__on__expandByDefault(java.awt.event.ActionEvent event) {
        setExpandByDefault();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getCreateNewRoot() {
        return createNewRoot;
    }

    public javax.swing.JButton getDelete() {
        return delete;
    }

    public javax.swing.JButton getEdit() {
        return edit;
    }

    public javax.swing.JCheckBox getExpandByDefault() {
        return expandByDefault;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean getThesaurusSelected() {
        return thesaurusSelected;
    }

    public jaxx.runtime.swing.HBox getToolBar() {
        return toolBar;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    public java.lang.Boolean isThesaurusSelected() {
        return thesaurusSelected !=null && thesaurusSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    public void setThesaurusSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.thesaurusSelected;
        this.thesaurusSelected = newValue;
        firePropertyChange(PROPERTY_THESAURUS_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolBar, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        toolBar.add(createNewRoot);
        toolBar.add(create);
        toolBar.add(edit);
        toolBar.add(delete);
        toolBar.add(expandByDefault);
        toolBar.add($JButton0);
        toolBar.add($JButton1);
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreateNewRoot() {
        $objectMap.put("createNewRoot", createNewRoot = new javax.swing.JButton());
        
        createNewRoot.setName("createNewRoot");
        createNewRoot.setText(_("vradi.thesaurus.createNewRoot"));
        createNewRoot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createNewRoot"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new javax.swing.JButton());
        
        delete.setName("delete");
        delete.setText(_("vradi.common.delete"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createEdit() {
        $objectMap.put("edit", edit = new javax.swing.JButton());
        
        edit.setName("edit");
        edit.setText(_("vradi.common.edit"));
        edit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__edit"));
    }

    protected void createExpandByDefault() {
        $objectMap.put("expandByDefault", expandByDefault = new javax.swing.JCheckBox());
        
        expandByDefault.setName("expandByDefault");
        expandByDefault.setText(_("vradi.thesaurus.expendByDefault"));
        expandByDefault.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__expandByDefault"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = false);
    }

    protected void createToolBar() {
        $objectMap.put("toolBar", toolBar = new jaxx.runtime.swing.HBox());
        
        toolBar.setName("toolBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminThesaurusUI();
        addChildrenToToolBar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        createNewRoot.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        create.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        edit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("edit"));
        delete.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        expandByDefault.setSelected(VradiHelper.isOnClickThesaurusExpanded());
        thesaurus.setHighlighters(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.EDIT));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminThesaurusUI", this);
        createModified();
        createSelected();
        createThesaurusSelected();
        createToolBar();
        createCreateNewRoot();
        createCreate();
        createEdit();
        createDelete();
        createExpandByDefault();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminThesaurus.importThesaurusCSV"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminThesaurus.exportThesaurusCSV"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        // inline creation of adminThesaurusUI
        setName("adminThesaurusUI");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                create.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                edit.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
    }

}