package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.FormMenu;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Locale;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class VradiMainUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.VradiMainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel content;
    protected VradiMainUI mainFrame = this;
    protected javax.swing.JMenuBar menu;
    protected javax.swing.JMenu menuAdmin;
    protected javax.swing.JMenuItem menuAdminClient;
    protected javax.swing.JMenuItem menuAdminEmail;
    protected javax.swing.JMenuItem menuAdminForm;
    protected javax.swing.JMenuItem menuAdminGroup;
    protected javax.swing.JMenuItem menuAdminStatus;
    protected javax.swing.JMenuItem menuAdminThesaurus;
    protected javax.swing.JMenuItem menuAdminXmlStream;
    protected javax.swing.JMenu menuEmail;
    protected javax.swing.JMenu menuFile;
    protected javax.swing.JMenuItem menuFileConfiguration;
    protected javax.swing.JMenuItem menuFileExit;
    protected javax.swing.JMenuItem menuFileFullscreen;
    protected javax.swing.JMenu menuFileLanguage;
    protected javax.swing.JMenuItem menuFileLanguageFR;
    protected javax.swing.JMenuItem menuFileLanguageUK;
    protected javax.swing.JMenuItem menuFileNormalscreen;
    protected com.jurismarches.vradi.ui.models.FormMenu menuForm;
    protected javax.swing.JMenu menuHelp;
    protected javax.swing.JMenuItem menuHelpAbout;
    protected javax.swing.JMenuItem menuHelpHelp;
    protected javax.swing.JMenuItem menuHelpSite;
    protected jaxx.runtime.swing.StatusMessagePanel status;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.VradiConfig getConfig() {
        return getContextValue(com.jurismarches.vradi.VradiConfig.class);
    }
    
    public VradiMainUIHandler getHandler() {
        return getContextValue(VradiMainUIHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public boolean acceptLocale(Locale l, String expected) {
      return l != null && l.toString().equals(expected);
    }
    
    void $afterCompleteSetup() {    
        //getBroker().setHandler(getHandler());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiMainUI() {
        $initialize();
    }

    public VradiMainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuAdminClient(java.awt.event.ActionEvent event) {
        getHandler().showAdminClient(this);
    }

    public void doActionPerformed__on__menuAdminEmail(java.awt.event.ActionEvent event) {
        getHandler().showEmail(this);
    }

    public void doActionPerformed__on__menuAdminForm(java.awt.event.ActionEvent event) {
        getHandler().showAdminForm(this);
    }

    public void doActionPerformed__on__menuAdminGroup(java.awt.event.ActionEvent event) {
        getHandler().showAdminGroup(this);
    }

    public void doActionPerformed__on__menuAdminStatus(java.awt.event.ActionEvent event) {
        getHandler().showAdminStatus(this);
    }

    public void doActionPerformed__on__menuAdminThesaurus(java.awt.event.ActionEvent event) {
        getHandler().showAdminThesaurus(this);
    }

    public void doActionPerformed__on__menuAdminXmlStream(java.awt.event.ActionEvent event) {
        getHandler().showAdminXmlStream(this);
    }

    public void doActionPerformed__on__menuFileConfiguration(java.awt.event.ActionEvent event) {
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(java.awt.event.ActionEvent event) {
        getHandler().close(mainFrame);
    }

    public void doActionPerformed__on__menuFileFullscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(java.awt.event.ActionEvent event) {
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(java.awt.event.ActionEvent event) {
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(java.awt.event.ActionEvent event) {
        getHandler().gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(java.awt.event.WindowEvent event) {
        getHandler().close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JMenuBar getMenu() {
        return menu;
    }

    public javax.swing.JMenu getMenuAdmin() {
        return menuAdmin;
    }

    public javax.swing.JMenuItem getMenuAdminClient() {
        return menuAdminClient;
    }

    public javax.swing.JMenuItem getMenuAdminEmail() {
        return menuAdminEmail;
    }

    public javax.swing.JMenuItem getMenuAdminForm() {
        return menuAdminForm;
    }

    public javax.swing.JMenuItem getMenuAdminGroup() {
        return menuAdminGroup;
    }

    public javax.swing.JMenuItem getMenuAdminStatus() {
        return menuAdminStatus;
    }

    public javax.swing.JMenuItem getMenuAdminThesaurus() {
        return menuAdminThesaurus;
    }

    public javax.swing.JMenuItem getMenuAdminXmlStream() {
        return menuAdminXmlStream;
    }

    public javax.swing.JMenu getMenuEmail() {
        return menuEmail;
    }

    public javax.swing.JMenu getMenuFile() {
        return menuFile;
    }

    public javax.swing.JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public javax.swing.JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public javax.swing.JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public javax.swing.JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public javax.swing.JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public javax.swing.JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public javax.swing.JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public com.jurismarches.vradi.ui.models.FormMenu getMenuForm() {
        return menuForm;
    }

    public javax.swing.JMenu getMenuHelp() {
        return menuHelp;
    }

    public javax.swing.JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public javax.swing.JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public javax.swing.JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public jaxx.runtime.swing.StatusMessagePanel getStatus() {
        return status;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(content);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuForm);
        menu.add(menuAdmin);
        menu.add(menuEmail);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuAdmin() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdmin.add(menuAdminClient);
        menuAdmin.add(menuAdminGroup);
        menuAdmin.add(menuAdminForm);
        menuAdmin.add(menuAdminXmlStream);
        menuAdmin.add(menuAdminStatus);
        menuAdmin.add(menuAdminThesaurus);
    }

    protected void addChildrenToMenuEmail() {
        if (!allComponentsCreated) {
            return;
        }
        menuEmail.add(menuAdminEmail);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new javax.swing.JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuAdmin() {
        $objectMap.put("menuAdmin", menuAdmin = new javax.swing.JMenu());
        
        menuAdmin.setName("menuAdmin");
        menuAdmin.setText(_("vradi.menu.admin"));
        menuAdmin.setMnemonic(65);
        menuAdmin.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuAdminClient() {
        $objectMap.put("menuAdminClient", menuAdminClient = new javax.swing.JMenuItem());
        
        menuAdminClient.setName("menuAdminClient");
        menuAdminClient.setText(_("vradi.menu.client"));
        menuAdminClient.setMnemonic(67);
        menuAdminClient.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminClient"));
        menuAdminClient.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminEmail() {
        $objectMap.put("menuAdminEmail", menuAdminEmail = new javax.swing.JMenuItem());
        
        menuAdminEmail.setName("menuAdminEmail");
        menuAdminEmail.setText(_("vradi.menu.email.admin"));
        menuAdminEmail.setMnemonic(67);
        menuAdminEmail.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminEmail"));
        menuAdminEmail.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminForm() {
        $objectMap.put("menuAdminForm", menuAdminForm = new javax.swing.JMenuItem());
        
        menuAdminForm.setName("menuAdminForm");
        menuAdminForm.setText(_("vradi.menu.formType"));
        menuAdminForm.setMnemonic(70);
        menuAdminForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminForm"));
        menuAdminForm.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminGroup() {
        $objectMap.put("menuAdminGroup", menuAdminGroup = new javax.swing.JMenuItem());
        
        menuAdminGroup.setName("menuAdminGroup");
        menuAdminGroup.setText(_("vradi.menu.group"));
        menuAdminGroup.setMnemonic(71);
        menuAdminGroup.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminGroup"));
        menuAdminGroup.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminStatus() {
        $objectMap.put("menuAdminStatus", menuAdminStatus = new javax.swing.JMenuItem());
        
        menuAdminStatus.setName("menuAdminStatus");
        menuAdminStatus.setText(_("vradi.menu.status"));
        menuAdminStatus.setMnemonic(83);
        menuAdminStatus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminStatus"));
        menuAdminStatus.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminThesaurus() {
        $objectMap.put("menuAdminThesaurus", menuAdminThesaurus = new javax.swing.JMenuItem());
        
        menuAdminThesaurus.setName("menuAdminThesaurus");
        menuAdminThesaurus.setText(_("vradi.menu.thesaurus"));
        menuAdminThesaurus.setMnemonic(84);
        menuAdminThesaurus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminThesaurus"));
        menuAdminThesaurus.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminXmlStream() {
        $objectMap.put("menuAdminXmlStream", menuAdminXmlStream = new javax.swing.JMenuItem());
        
        menuAdminXmlStream.setName("menuAdminXmlStream");
        menuAdminXmlStream.setText(_("vradi.menu.xmlStream"));
        menuAdminXmlStream.setMnemonic(88);
        menuAdminXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminXmlStream"));
        menuAdminXmlStream.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuEmail() {
        $objectMap.put("menuEmail", menuEmail = new javax.swing.JMenu());
        
        menuEmail.setName("menuEmail");
        menuEmail.setText(_("vradi.menu.email"));
        menuEmail.setMnemonic(69);
        menuEmail.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new javax.swing.JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("vradi.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new javax.swing.JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("vradi.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("vradi.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new javax.swing.JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("vradi.action.exit"));
        menuFileExit.setMnemonic(88);
        menuFileExit.setToolTipText(_("vradi.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new javax.swing.JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("vradi.action.fullscreen"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.setToolTipText(_("vradi.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new javax.swing.JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("vradi.menu.file.locale"));
        menuFileLanguage.setMnemonic(67);
        menuFileLanguage.setToolTipText(_("vradi.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new javax.swing.JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(_("vradi.action.locale.fr"));
        menuFileLanguageFR.setToolTipText(_("vradi.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new javax.swing.JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(_("vradi.action.locale.uk"));
        menuFileLanguageUK.setMnemonic(85);
        menuFileLanguageUK.setToolTipText(_("vradi.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new javax.swing.JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("vradi.action.normalscreen"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.setToolTipText(_("vradi.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuForm() {
        $objectMap.put("menuForm", menuForm = new com.jurismarches.vradi.ui.models.FormMenu(getHandler()));
        
        menuForm.setName("menuForm");
        menuForm.setText(_("vradi.menu.form"));
        menuForm.setMnemonic(77);
        menuForm.putClientProperty("help", "ui.main.menu.form");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new javax.swing.JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("vradi.menu.help"));
        menuHelp.setMnemonic(101);
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new javax.swing.JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("vradi.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("vradi.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new javax.swing.JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("vradi.action.help"));
        menuHelpHelp.setMnemonic(101);
        menuHelpHelp.setToolTipText(_("vradi.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new javax.swing.JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("vradi.action.site"));
        menuHelpSite.setMnemonic(115);
        menuHelpSite.setToolTipText(_("vradi.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createStatus() {
        $objectMap.put("status", status = new jaxx.runtime.swing.StatusMessagePanel());
        
        status.setName("status");
        status.putClientProperty("help", "ui.main.statusBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuAdmin();
        addChildrenToMenuEmail();
        addChildrenToMenuHelp();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        menuFileConfiguration.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("config"));
        menuFileLanguage.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("translate"));
        menuFileLanguageFR.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("i18n-fr"));
        menuFileLanguageUK.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("i18n-uk"));
        menuFileFullscreen.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("leave-fullscreen"));
        menuFileExit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("exit"));
        menuHelpHelp.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("help"));
        menuHelpSite.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        menuHelpAbout.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("about"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("mainFrame", this);
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuForm();
        createMenuAdmin();
        createMenuAdminClient();
        createMenuAdminGroup();
        createMenuAdminForm();
        createMenuAdminXmlStream();
        createMenuAdminStatus();
        createMenuAdminThesaurus();
        createMenuEmail();
        createMenuAdminEmail();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createContent();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1000);
        setTitle(_("vradi.title.welcome"));
        setDefaultCloseOperation(0);
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}