/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import javax.activation.DataSource;
import org.apache.commons.mail.ByteArrayDataSource;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.MailAttachPlugin;
import org.webharvest.runtime.processors.plugins.MailPluginException;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class MailPlugin
extends WebHarvestPlugin {
    private Email email = null;
    private int attachmentCounter = 0;

    public static DataSource createDataSourceOfVariable(Variable variable, String charset, String mimeType) throws IOException {
        if (variable != null) {
            byte[] bytes = variable.toBinary(charset);
            return new ByteArrayDataSource(bytes, mimeType);
        }
        return null;
    }

    @Override
    public String getName() {
        return "mail";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        String security;
        this.email = null;
        boolean isHtml = "html".equalsIgnoreCase(this.evaluateAttribute("type", scraper));
        this.email = isHtml ? new HtmlEmail() : new SimpleEmail();
        this.email.setHostName(this.evaluateAttribute("smtp-host", scraper));
        this.email.setSmtpPort(this.evaluateAttributeAsInteger("smtp-port", 25, scraper));
        try {
            this.email.setFrom(this.evaluateAttribute("from", scraper));
        }
        catch (EmailException e) {
            throw new MailPluginException("Invalid \"from\" email address!", e);
        }
        for (String replyTo : CommonUtil.tokenize(this.evaluateAttribute("reply-to", scraper), ",")) {
            try {
                this.email.addReplyTo(replyTo);
            }
            catch (EmailException e) {
                throw new MailPluginException("Invalid \"reply-to\" email address!", e);
            }
        }
        for (String to : CommonUtil.tokenize(this.evaluateAttribute("to", scraper), ",")) {
            try {
                this.email.addTo(to);
            }
            catch (EmailException e) {
                throw new MailPluginException("Invalid \"to\" email address!", e);
            }
        }
        for (String cc : CommonUtil.tokenize(this.evaluateAttribute("cc", scraper), ",")) {
            try {
                this.email.addCc(cc);
            }
            catch (EmailException e) {
                throw new MailPluginException("Invalid \"cc\" email address!", e);
            }
        }
        for (String bcc : CommonUtil.tokenize(this.evaluateAttribute("bcc", scraper), ",")) {
            try {
                this.email.addBcc(bcc);
            }
            catch (EmailException e) {
                throw new MailPluginException("Invalid \"bcc\" email address!", e);
            }
        }
        this.email.setSubject(this.evaluateAttribute("subject", scraper));
        String username = this.evaluateAttribute("username", scraper);
        String password = this.evaluateAttribute("password", scraper);
        if (!CommonUtil.isEmptyString(username)) {
            this.email.setAuthentication(username, password);
        }
        if ("tsl".equals(security = this.evaluateAttribute("security", scraper))) {
            this.email.setTLS(true);
        } else if ("ssl".equals(security)) {
            this.email.setSSL(true);
        }
        String charset = this.evaluateAttribute("charset", scraper);
        if (CommonUtil.isEmptyString(charset)) {
            charset = scraper.getConfiguration().getCharset();
        }
        this.email.setCharset(charset);
        if (isHtml) {
            HtmlEmail htmlEmail = (HtmlEmail)this.email;
            String htmlContent = this.executeBody(scraper, context).toString();
            try {
                htmlEmail.setHtmlMsg(htmlContent);
            }
            catch (EmailException e) {
                throw new MailPluginException(e);
            }
        }
        try {
            this.email.setMsg(this.executeBody(scraper, context).toString());
        }
        catch (EmailException e) {
            throw new MailPluginException(e);
        }
        try {
            this.email.send();
        }
        catch (EmailException e) {
            throw new MailPluginException(e);
        }
        this.email = null;
        return new EmptyVariable();
    }

    @Override
    public String[] getValidAttributes() {
        return new String[]{"smtp-host", "smtp-port", "type", "from", "reply-to", "to", "cc", "bcc", "subject", "charset", "username", "password", "security"};
    }

    @Override
    public String[] getRequiredAttributes() {
        return new String[]{"smtp-host", "from", "to"};
    }

    @Override
    public String[] getValidSubprocessors() {
        return null;
    }

    @Override
    public String[] getRequiredSubprocessors() {
        return null;
    }

    @Override
    public Class[] getDependantProcessors() {
        return new Class[]{MailAttachPlugin.class};
    }

    public Email getEmail() {
        return this.email;
    }

    @Override
    public String[] getAttributeValueSuggestions(String attributeName) {
        if ("type".equalsIgnoreCase(attributeName)) {
            return new String[]{"html", "text"};
        }
        if ("charset".equalsIgnoreCase(attributeName)) {
            Set<String> charsetKeys = Charset.availableCharsets().keySet();
            return new ArrayList<String>(charsetKeys).toArray(new String[charsetKeys.size()]);
        }
        if ("security".equalsIgnoreCase(attributeName)) {
            return new String[]{"ssl", "tsl", "none"};
        }
        return null;
    }

    protected String getNextAttachmentName() {
        ++this.attachmentCounter;
        return "Attachment " + this.attachmentCounter;
    }
}

