/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NAKACK_Delivery_Test {
    private NAKACK nak;
    private Address c1;
    private Address c2;
    static final String NAME = "NAKACK";
    MyReceiver receiver = new MyReceiver();
    Executor pool;
    static final int NUM_MSGS = 50;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.c1 = Util.createRandomAddress();
        this.c2 = Util.createRandomAddress();
        UUID.add((UUID)this.c1, "C1");
        UUID.add((UUID)this.c2, "C2");
        this.nak = new NAKACK();
        this.nak.setDownProtocol(new TP(){

            @Override
            public boolean supportsMulticasting() {
                return false;
            }

            @Override
            public String getName() {
                return "blo";
            }

            @Override
            public void sendMulticast(byte[] data, int offset, int length) throws Exception {
            }

            @Override
            public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
            }

            @Override
            public String getInfo() {
                return null;
            }

            @Override
            public Object down(Event evt) {
                return null;
            }

            @Override
            protected PhysicalAddress getPhysicalAddress() {
                return null;
            }

            @Override
            public TimeScheduler getTimer() {
                return new TimeScheduler(1);
            }
        });
        this.receiver.init(this.c1, this.c2);
        this.nak.setUpProtocol(this.receiver);
        this.nak.start();
        Vector<Address> members = new Vector<Address>(2);
        members.add(this.c1);
        members.add(this.c2);
        View view = new View(this.c1, 1L, members);
        this.nak.down(new Event(8, this.c1));
        MutableDigest digest = new MutableDigest(2);
        digest.add(this.c1, 0L, 0L, 0L);
        digest.add(this.c2, 0L, 0L, 0L);
        this.nak.down(new Event(41, digest));
        this.nak.down(new Event(6, view));
        this.pool = new ThreadPoolExecutor(1, 100, 1000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        ((ThreadPoolExecutor)this.pool).setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @AfterMethod
    protected void tearDown() {
        this.nak.stop();
        if (this.pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.pool).shutdownNow();
        }
    }

    public void testSendingOfRandomMessages() {
        List<Integer> seqnos = NAKACK_Delivery_Test.generateRandomNumbers(1, 50);
        seqnos.addAll(NAKACK_Delivery_Test.generateRandomNumbers(1, 50));
        seqnos.addAll(NAKACK_Delivery_Test.generateRandomNumbers(Math.min(15, 25), 25));
        seqnos.addAll(NAKACK_Delivery_Test.generateRandomNumbers(2, 50));
        seqnos.addAll(NAKACK_Delivery_Test.generateRandomNumbers(5, Math.max(5, 40)));
        HashSet<Integer> no_duplicates = new HashSet<Integer>(seqnos);
        System.out.println("sending " + seqnos.size() + " msgs (including duplicates); size excluding duplicates=" + no_duplicates.size());
        NakReceiverWindow win = this.nak.getWindow(this.c1);
        for (int i = 1; i <= 50; ++i) {
            win.add(i, NAKACK_Delivery_Test.msg(this.c1, i, i, true));
        }
        for (int i : seqnos) {
            boolean oob = Util.tossWeightedCoin(0.5);
            this.pool.execute(new Sender(this.c2, i, i, oob));
            this.pool.execute(new Sender(this.c1, i, i, oob));
        }
        ConcurrentMap<Address, Collection<Message>> msgs = this.receiver.getMsgs();
        Collection c1_list = (Collection)msgs.get(this.c1);
        Collection c2_list = (Collection)msgs.get(this.c2);
        long end_time = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < end_time) {
            int size_c1 = c1_list.size();
            int size_c2 = c2_list.size();
            System.out.println("size C1 = " + size_c1 + ", size C2=" + size_c2);
            if (size_c1 == 50 && size_c2 == 50) break;
            Util.sleep(1000L);
        }
        assert (c1_list.size() == 50) : "[C1] expected 50 messages, but got " + c1_list.size();
        assert (c2_list.size() == 50) : "[C2] expected 50 messages, but got " + c2_list.size();
    }

    private static List<Integer> generateRandomNumbers(int from, int to) {
        ArrayList<Integer> retval = new ArrayList<Integer>(20);
        for (int i = from; i <= to; ++i) {
            retval.add(i);
        }
        Collections.shuffle(retval);
        return retval;
    }

    private void send(Address sender, long seqno, int number, boolean oob) {
        assert (sender != null);
        this.nak.up(new Event(1, NAKACK_Delivery_Test.msg(sender, seqno, number, oob)));
    }

    private static Message msg(Address sender, long seqno, int number, boolean oob) {
        Message msg = new Message(null, sender, Integer.valueOf(number));
        if (oob) {
            msg.setFlag((byte)1);
        }
        if (seqno != -1L) {
            msg.putHeader(NAME, new NakAckHeader(1, seqno));
        }
        return msg;
    }

    class Sender
    implements Runnable {
        final Address sender;
        final long seqno;
        final int number;
        final boolean oob;

        public Sender(Address sender, long seqno, int number, boolean oob) {
            this.sender = sender;
            this.seqno = seqno;
            this.number = number;
            this.oob = oob;
        }

        @Override
        public void run() {
            NAKACK_Delivery_Test.this.send(this.sender, this.seqno, this.number, this.oob);
        }
    }

    static class MyReceiver
    extends Protocol {
        final ConcurrentMap<Address, Collection<Message>> msgs = new ConcurrentHashMap<Address, Collection<Message>>();

        MyReceiver() {
        }

        public ConcurrentMap<Address, Collection<Message>> getMsgs() {
            return this.msgs;
        }

        public void init(Address ... mbrs) {
            for (Address mbr : mbrs) {
                this.msgs.putIfAbsent(mbr, new ConcurrentLinkedQueue());
            }
        }

        @Override
        public Object up(Event evt) {
            if (evt.getType() == 1) {
                Collection tmp;
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                Collection<Message> list = (ConcurrentLinkedQueue<Message>)this.msgs.get(sender);
                if (list == null && (tmp = (Collection)this.msgs.putIfAbsent(sender, list = new ConcurrentLinkedQueue<Message>())) != null) {
                    list = tmp;
                }
                list.add(msg);
            }
            return null;
        }
    }
}

