/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Buffer;
import org.jgroups.util.Headers;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Message
implements Streamable {
    protected Address dest_addr;
    protected Address src_addr;
    private byte[] buf;
    protected int offset;
    protected int length;
    protected Headers headers;
    private volatile byte flags;
    private volatile byte transient_flags;
    protected static final Log log = LogFactory.getLog(Message.class);
    static final Set<Class> nonStreamableHeaders = new HashSet<Class>();
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;
    public static final byte OOB = 1;
    public static final byte LOOPBACK = 2;
    public static final byte DONT_BUNDLE = 4;
    public static final byte NO_FC = 8;
    public static final byte OOB_DELIVERED = 1;

    public Message(Address dest) {
        this.setDest(dest);
        this.headers = Message.createHeaders(3);
    }

    public Message(Address dest, Address src, byte[] buf) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, Address src, Serializable obj) {
        this(dest);
        this.setSrc(src);
        this.setObject(obj);
    }

    public Message() {
        this.headers = Message.createHeaders(3);
    }

    public Message(boolean create_headers) {
        if (create_headers) {
            this.headers = Message.createHeaders(3);
        }
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public final byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public final void setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public final void setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public final void setBuffer(Buffer buf) {
        if (buf != null) {
            this.buf = buf.getBuf();
            this.offset = buf.getOffset();
            this.length = buf.getLength();
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map<String, Header> getHeaders() {
        return this.headers.getHeaders();
    }

    public String printHeaders() {
        return this.headers.printHeaders();
    }

    public int getNumHeaders() {
        return this.headers.size();
    }

    public final void setObject(Serializable obj) {
        if (obj == null) {
            return;
        }
        try {
            byte[] tmp = Util.objectToByteBuffer(obj);
            this.setBuffer(tmp);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public final Object getObject() {
        try {
            return Util.objectFromByteBuffer(this.buf, this.offset, this.length);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.flags = (byte)(this.flags | flag);
    }

    public void clearFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.flags = (byte)(this.flags & ~flag);
    }

    public boolean isFlagSet(byte flag) {
        return Message.isFlagSet(this.flags, flag);
    }

    public void setTransientFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.transient_flags = (byte)(this.transient_flags | flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTransientFlagIfAbsent(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        Message message = this;
        synchronized (message) {
            if (this.isTransientFlagSet(flag)) {
                return false;
            }
            this.setTransientFlag(flag);
            return true;
        }
    }

    public void clearTransientFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.transient_flags = (byte)(this.transient_flags & ~flag);
    }

    public boolean isTransientFlagSet(byte flag) {
        return Message.isFlagSet(this.transient_flags, flag);
    }

    protected static boolean isFlagSet(byte flags, byte flag) {
        return (flags & flag) == flag;
    }

    public byte getFlags() {
        return this.flags;
    }

    public byte getTransientFlags() {
        return this.transient_flags;
    }

    public void putHeader(String key, Header hdr) {
        this.headers.putHeader(key, hdr);
    }

    public Header putHeaderIfAbsent(String key, Header hdr) {
        return this.headers.putHeaderIfAbsent(key, hdr);
    }

    public Header removeHeader(String key) {
        return this.getHeader(key);
    }

    public Header getHeader(String key) {
        return this.headers.getHeader(key);
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        Message retval = new Message(false);
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        retval.flags = this.flags;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        retval.headers = Message.createHeaders(this.headers);
        return retval;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public Message makeReply() {
        return new Message(this.src_addr);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(64);
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        int size = this.getNumHeaders();
        if (size > 0) {
            ret.append(" (").append(size).append(" headers)");
        }
        ret.append(", size=");
        if (this.buf != null && this.length > 0) {
            ret.append(this.length);
        } else {
            ret.append('0');
        }
        ret.append(" bytes");
        if (this.flags > 0) {
            ret.append(", flags=").append(Message.flagsToString(this.flags));
        }
        if (this.transient_flags > 0) {
            ret.append(", transient_flags=" + Message.flagsToString(this.transient_flags));
        }
        ret.append(']');
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String printObjectHeaders() {
        return this.headers.printObjectHeaders();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        byte leading = 0;
        if (this.dest_addr != null) {
            leading = Util.setFlag(leading, (byte)1);
        }
        if (this.src_addr != null) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.write(this.flags);
        if (this.dest_addr != null) {
            Util.writeAddress(this.dest_addr, out);
        }
        if (this.src_addr != null) {
            Util.writeAddress(this.src_addr, out);
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int size = this.headers.size();
        out.writeShort(size);
        Object[] data = this.headers.getRawData();
        for (int i = 0; i < data.length; i += 2) {
            if (data[i] == null) continue;
            out.writeUTF((String)data[i]);
            Message.writeHeader((Header)data[i + 1], out);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int len;
        byte leading = in.readByte();
        this.flags = in.readByte();
        if (Util.isFlagSet(leading, (byte)1)) {
            this.dest_addr = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)2)) {
            this.src_addr = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)4)) {
            len = in.readInt();
            this.buf = new byte[len];
            in.readFully(this.buf, 0, len);
            this.length = len;
        }
        len = in.readShort();
        this.headers = Message.createHeaders(len);
        Object[] data = this.headers.getRawData();
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String hdr_name = in.readUTF();
            data[index++] = hdr_name;
            Header hdr = Message.readHeader(in);
            data[index++] = hdr;
        }
    }

    public long size() {
        long retval = 2L;
        if (this.dest_addr != null) {
            retval += (long)Util.size(this.dest_addr);
        }
        if (this.src_addr != null) {
            retval += (long)Util.size(this.src_addr);
        }
        if (this.buf != null) {
            retval += (long)(4 + this.length);
        }
        retval += 2L;
        return retval += (long)this.headers.marshalledSize();
    }

    public static String flagsToString(byte flags) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (Message.isFlagSet(flags, (byte)1)) {
            first = false;
            sb.append("OOB");
        }
        if (Message.isFlagSet(flags, (byte)2)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("LOOPBACK");
        }
        if (Message.isFlagSet(flags, (byte)4)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("DONT_BUNDLE");
        }
        if (Message.isFlagSet(flags, (byte)8)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_FC");
        }
        if (Message.isFlagSet(flags, (byte)1)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("OOB_DELIVERED");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeHeader(Header hdr, DataOutputStream out) throws IOException {
        ObjectOutputStream oos;
        block5: {
            short magic_number = ClassConfigurator.getMagicNumber(hdr.getClass());
            out.writeShort(magic_number);
            if (magic_number == -1) {
                String classname = hdr.getClass().getName();
                out.writeUTF(classname);
                if (log.isWarnEnabled()) {
                    log.warn("magic number for " + classname + " not found, make sure you add your header to " + "jg-magic-map.xml, or register it programmatically with the ClassConfigurator");
                }
            }
            if (hdr instanceof Streamable) {
                ((Streamable)((Object)hdr)).writeTo(out);
                return;
            }
            oos = null;
            try {
                oos = new ObjectOutputStream(out);
                hdr.writeExternal(oos);
                if (nonStreamableHeaders.contains(hdr.getClass())) break block5;
                nonStreamableHeaders.add(hdr.getClass());
                if (!log.isTraceEnabled()) break block5;
                log.trace("encountered non-Streamable header: " + hdr.getClass());
            }
            catch (Throwable throwable) {
                Util.close(oos);
                throw throwable;
            }
        }
        Util.close(oos);
    }

    private static Header readHeader(DataInputStream in) throws IOException {
        try {
            Header hdr;
            Class clazz;
            short magic_number = in.readShort();
            if (magic_number != -1) {
                clazz = ClassConfigurator.get(magic_number);
                if (clazz == null) {
                    throw new IllegalArgumentException("magic number " + magic_number + " is not available in magic map");
                }
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.get(classname);
            }
            if ((hdr = (Header)clazz.newInstance()) instanceof Streamable) {
                ((Streamable)((Object)hdr)).readFrom(in);
            } else {
                ObjectInputStream ois = new ObjectInputStream(in);
                hdr.readExternal(ois);
            }
            return hdr;
        }
        catch (Exception ex) {
            IOException io_ex = new IOException("failed reading header");
            io_ex.initCause(ex);
            throw io_ex;
        }
    }

    private static Headers createHeaders(int size) {
        return size > 0 ? new Headers(size) : new Headers(3);
    }

    private static Headers createHeaders(Headers m) {
        return new Headers(m);
    }
}

