/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.ui.admin.AdminHandler;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import javax.swing.event.ListDataListener;
import java.util.List;

/**
 * @author letellier
 */
public class FormTypeNameModel implements ComboBoxModel {

    protected EntityModel<WikittyExtension> delegate;
    protected AdminHandler handler;

    public FormTypeNameModel(AdminHandler handler, JAXXContextEntryDef<List<WikittyExtension>> formsEntryDef) {
        delegate = new EntityModel<WikittyExtension>(formsEntryDef);
        this.handler = handler;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        String formTypeName = (String) anItem;
        delegate.setSelectedItem(handler.getExtension(formTypeName));
    }

    @Override
    public Object getSelectedItem() {
        Object selected = delegate.getSelectedItem();
        if (selected == null){
            return null;
        }
        return ((WikittyExtension) selected).getName();
    }

    @Override
    public int getSize() {
        return delegate.getSize();
    }

    @Override
    public Object getElementAt(int index) {
        Object o = delegate.getElementAt(index);
        if (o == null){
            return " ";
        }
        return ((WikittyExtension)o).getName();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        delegate.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        delegate.removeListDataListener(l);
    }
}
