package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.ModifThesaurusModel;
import com.jurismarches.vradi.ui.renderer.ThesaurusHighlighter;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.treetable.NavigationTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXPAND = "expand";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_MODIF_MODEL = "modifModel";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_EDIT_ENABLED = "edit.enabled";
    public static final String BINDING_EXPAND_BY_DEFAULT_SELECTED = "expandByDefault.selected";
    public static final String BINDING_MODIF_VIEWER_MODEL = "modifViewer.model";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminThesaurusUI adminThesaurusUI = this;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JButton delete;
    protected javax.swing.JButton edit;
    protected java.lang.Boolean expand;
    protected javax.swing.JCheckBox expandByDefault;
    protected com.jurismarches.vradi.ui.models.ModifThesaurusModel modifModel;
    protected javax.swing.JList modifViewer;
    protected java.lang.Boolean modified;
    protected javax.swing.JSplitPane offerList;
    protected javax.swing.JButton save;
    protected java.lang.Boolean selected;
    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected jaxx.runtime.swing.HBox toolBar;
    protected javax.swing.JButton viewApply;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane1;
    private jaxx.runtime.swing.VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    ThesaurusTreeHelper helper;
    
    
    public  AdminThesaurusUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        setContextValue(new ModifThesaurusModel(this, helper));
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    public void reinit(ThesaurusTreeHelper helper){
        this.helper = helper;
        setContextValue(helper);
    
        modifModel = new ModifThesaurusModel(this, helper);
        modifViewer.setModel(modifModel);
        NavigationTreeTableModel navigationModel = (NavigationTreeTableModel)helper.createTreeModel(this);
        thesaurus.setTreeTableModel(navigationModel);
        //thesaurus.setTreeTableModel((NavigationTreeTableModel)helper.createTreeModel(this));
    
        thesaurus.addTreeSelectionListener(helper.createTreeHandler(this));
        if (expand){
            SwingUtil.addExpandOnClickListener(thesaurus);
        }
    }
    
    protected ThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, ThesaurusHandler.class);
    }
    
    public ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
        final Action copyToClipboard = new ThesaurusHandler.CopyToClipboard(this);
        
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JXTreeTable treeTable = (JXTreeTable) mouseEvent.getSource();
                TreePath path = treeTable.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // If node is selected
                setSelected(path != null);
    
                // Clear if no selection
                if (!isSelected()){
                    treeTable.clearSelection();
                    getHelper().setSelectedNode(AdminThesaurusUI.this, null);
                }
    
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
                    JMenuItem menuAddChild = new JMenuItem();
                    menuAddChild.setText(_("vradi.menu.addChildThesaurus"));
                    menuAddChild.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
    
                            addChildToSelected();
                        }
                    });
                    popup.add(menuAddChild);
    
                    JMenuItem menuRenameSelected = new JMenuItem();
                    menuRenameSelected.setText(_("vradi.menu.editThesaurusSelected"));
                    menuRenameSelected.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            editSelected();
                        }
                    });
                    popup.add(menuRenameSelected);
    
                    JMenuItem menuDeleteSeleted = new JMenuItem();
                    menuDeleteSeleted.setText(_("vradi.menu.deleteThesaurusSelected"));
                    menuDeleteSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            deleteSelected();
                        }
                    });
                    popup.add(menuDeleteSeleted);
    
                    JMenuItem menuMoveSeleted = new JMenuItem();
                    menuMoveSeleted.setText(_("vradi.menu.moveThesaurusSelected"));
                    menuMoveSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            moveSelected();
                        }
                    });
                    popup.add(menuMoveSeleted);
    
                    JMenuItem menuChangeColorSeleted = new JMenuItem();
                    menuChangeColorSeleted.setText(_("vradi.menu.menuChangeColorSeleted"));
                    menuChangeColorSeleted.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            changeColorSelected();
                        }
                    });
                    popup.add(menuChangeColorSeleted);
    
                    popup.add(copyToClipboard);
                    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        thesaurus.addTreeSelectionListener(helper.createTreeHandler(this));
        if (expand){
            SwingUtil.addExpandOnClickListener(thesaurus);
        }
        modifViewer.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
    }
    
    protected void addChildToSelected(){
        log.debug("addChildToSelected ");
        // Ajout dun nouveau thesaurus
        boolean modification = getThesaurusHandler().addChildThesaurusToSelected(this, helper, modifModel);
        // si il a été modifié, il y reste
        setModified(isModified() || modification);
    }
    protected void editSelected(){
        log.debug("editSelected ");
        // Edition dun thesaurus
        boolean modification = getThesaurusHandler().editThesaurusSelected(this, helper, modifModel);
        setModified(isModified() || modification);
    }
    protected void deleteSelected(){
        log.debug("deleteSelected ");
        // Suppression dun thesaurus
        boolean modification = getThesaurusHandler().deleteThesaurusSelected(this, helper, modifModel);
        setModified(isModified() || modification);
    }
    protected void moveSelected(){
        log.debug("moveSelected ");
        // Move thesaurus
        boolean modification = getThesaurusHandler().moveThesaurus(this, helper, modifModel);
        setModified(isModified() || modification);
    }
    protected void changeColorSelected(){
        log.debug("changeColor ");
        // Change color af selected detph
        getThesaurusHandler().changeThesaurusColor(this, helper);
    }
    
    protected void viewApply(){
        java.util.List<VradiThesaurusDTO> concerned = modifModel.getConcernedThesaurus(modifViewer.getSelectedIndices());
        log.info("Find " + concerned.size() + " thesaurus concerned");
        getThesaurusHandler().viewApply(this, concerned);
    }
    
    protected void setExpandByDefault(){
        setExpand(expandByDefault.isSelected());
        VradiHelper.storeExpandSelected(expand);
        if (expand){
            SwingUtil.addExpandOnClickListener(thesaurus);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminThesaurusUI() {
        $initialize();
    }

    public AdminThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getThesaurusHandler().importCSV(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getThesaurusHandler().exportThesaurusCSV(this);
    }

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        getThesaurusHandler().cancelThesaurus(this, helper, true);setModified(false);
    }

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        addChildToSelected();
    }

    public void doActionPerformed__on__delete(java.awt.event.ActionEvent event) {
        deleteSelected();
    }

    public void doActionPerformed__on__edit(java.awt.event.ActionEvent event) {
        editSelected();
    }

    public void doActionPerformed__on__expandByDefault(java.awt.event.ActionEvent event) {
        setExpandByDefault();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        getThesaurusHandler().saveThesaurus(this, helper, true);setModified(false);
    }

    public void doActionPerformed__on__viewApply(java.awt.event.ActionEvent event) {
        viewApply();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getDelete() {
        return delete;
    }

    public javax.swing.JButton getEdit() {
        return edit;
    }

    public java.lang.Boolean getExpand() {
        return expand;
    }

    public javax.swing.JCheckBox getExpandByDefault() {
        return expandByDefault;
    }

    public com.jurismarches.vradi.ui.models.ModifThesaurusModel getModifModel() {
        return modifModel;
    }

    public javax.swing.JList getModifViewer() {
        return modifViewer;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JSplitPane getOfferList() {
        return offerList;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public jaxx.runtime.swing.HBox getToolBar() {
        return toolBar;
    }

    public javax.swing.JButton getViewApply() {
        return viewApply;
    }

    public java.lang.Boolean isExpand() {
        return expand !=null && expand;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExpand(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.expand;
        this.expand = newValue;
        firePropertyChange(PROPERTY_EXPAND, oldValue, newValue);
    }

    public void setModifModel(com.jurismarches.vradi.ui.models.ModifThesaurusModel newValue) {
        com.jurismarches.vradi.ui.models.ModifThesaurusModel oldValue = this.modifModel;
        this.modifModel = newValue;
        firePropertyChange(PROPERTY_MODIF_MODEL, oldValue, newValue);
    }

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolBar, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add(offerList, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(save, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        offerList.add($JScrollPane0, JSplitPane.LEFT);
        offerList.add($Table0, JSplitPane.RIGHT);
    }

    protected void addChildrenToToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        toolBar.add(create);
        toolBar.add(edit);
        toolBar.add(delete);
        toolBar.add(expandByDefault);
        toolBar.add($JButton0);
        toolBar.add($JButton1);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new javax.swing.JButton());
        delete.setName("delete");
        delete.setText(_("vradi.common.delete"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createEdit() {
        $objectMap.put("edit", edit = new javax.swing.JButton());
        edit.setName("edit");
        edit.setText(_("vradi.common.edit"));
        edit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__edit"));
    }

    protected void createExpand() {
        $objectMap.put("expand", expand = VradiHelper.isExpandSelected());
    }

    protected void createExpandByDefault() {
        $objectMap.put("expandByDefault", expandByDefault = new javax.swing.JCheckBox());
        expandByDefault.setName("expandByDefault");
        expandByDefault.setText(_("vradi.thesaurus.expendByDefault"));
        expandByDefault.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__expandByDefault"));
    }

    protected void createModifModel() {
        $objectMap.put("modifModel", modifModel = getContextValue(ModifThesaurusModel.class));
    }

    protected void createModifViewer() {
        $objectMap.put("modifViewer", modifViewer = new javax.swing.JList());
        modifViewer.setName("modifViewer");
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createOfferList() {
        $objectMap.put("offerList", offerList = new javax.swing.JSplitPane());
        offerList.setName("offerList");
        offerList.setOneTouchExpandable(true);
        offerList.setContinuousLayout(true);
        offerList.setDividerSize(12);
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createToolBar() {
        $objectMap.put("toolBar", toolBar = new jaxx.runtime.swing.HBox());
        toolBar.setName("toolBar");
    }

    protected void createViewApply() {
        $objectMap.put("viewApply", viewApply = new javax.swing.JButton());
        viewApply.setName("viewApply");
        viewApply.setToolTipText(_("vradi.adminThesaurus.view"));
        viewApply.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__viewApply"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminThesaurusUI();
        addChildrenToToolBar();
        addChildrenToOfferList();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($VBox0, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(modifViewer);
        // inline complete setup of $VBox0
        $VBox0.add(viewApply);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        create.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        edit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("edit"));
        delete.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        offerList.setDividerLocation(300);
        offerList.setOrientation(JSplitPane.VERTICAL_SPLIT);
        thesaurus.setTreeTableModel((NavigationTreeTableModel)helper.createTreeModel(this));
        viewApply.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("view"));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 5 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminThesaurusUI", this);
        createModified();
        createSelected();
        createModifModel();
        createExpand();
        createToolBar();
        createCreate();
        createEdit();
        createDelete();
        createExpandByDefault();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminThesaurus.importThesaurusCSV"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.adminThesaurus.exportThesaurusCSV"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createOfferList();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.thesaurus.modifTitle"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createModifViewer();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        $VBox0.setName("$VBox0");
        createViewApply();
        createCancel();
        createSave();
        // inline creation of adminThesaurusUI
        setName("adminThesaurusUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                edit.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(isSelected());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EXPAND_BY_DEFAULT_SELECTED, true ,"expand") {
        
            @Override
            public void processDataBinding() {
                expandByDefault.setSelected(isExpand());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MODIF_VIEWER_MODEL, true ,"modifModel") {
        
            @Override
            public void processDataBinding() {
                modifViewer.setModel(getModifModel());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                save.setEnabled(isModified());
            }
        });
    }

}