package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.ThesaurusCartographyModel;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusCartographyUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CARTOGRAPHY_MODEL = "cartographyModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTU8UQRBtVhZYkA9BPowQQTFezCxnIYquohAQAmiIe7F3pt1p7J1uu2tg4GD8Cf4EvXsx8ebJePDswYvxLxjjwauxembZBR2QOO5hd9NV9epVdb3qV19J3mgysUmjyNFhALzGnIXrGxvLlU3mwk1mXM0VSE2ST0uO5Mqky2ucGyAXyos2vFgPL5ZkTcmABfuipxdJp4EdwYzPGAAZOxjhGlNca5inIxXqPdQGqTTUF9+/5Z57z17mCIkUsrOljP8tqllJ6yLJcQ9IP2baokVBgyrS0DyoIt9ue1YS1Ji7tMaekKekfZG0KaoRDMj545ccY8TxkQIyBD4zNNShKVENsqqp8nfuzQOZcmXN2Qw1NzWqXXRytjT1uBNyZz01RKkYtQ1In9s8X5IeE0CuHI5Wsx4mFTQObuJ2Ty6suVoKsUIDNgVk2LYkcsw2dsjZZ7LuhVQ267QiGJBzUledTRyaxyBVEh85CxvrmrHYw0b2NgAKkws3QgAZYMqBAymT43o6Tc4euGocIqc5RM1bbimTvA7xGMhI+c+5W0VTMnEjv02cBYytP4cGPr398mZub8z6MPdgqus+leD1Ky0V08Bt6t5kxkLgorhE1XSZFAwTKLFYQqMpxNbqZiSH+U7ZcMeGO3eo8REi3/753fuhhx9PkNwc6RSSenPU+s+TAvgauyCFF6lrszGjk9sdlrjlBmTQY49oKKAkpGHLSJEClwGQnhmPAh2v8MDDdl+NsCejKT1pEKsUPvwYWHs9u9eXFuR55lD3Zm/yD0gbDwQPWCzAurZSBdelDAs92dRQmqpa7G+nqg/uWPw9kVZ4m8941Uf59s8k+ccpoN4rITCs1oZdjMuw/y4dH1XQHRmCtU/+O0oedUmFNV/OAAIcEjllAdnGpehnBOmhIchVZvgus1vliOYMHAPttCtFWAtKOKW4dO5zw+tbIwsmixQNPJPMJ/NWKPgmI2ahqrlXkkLqjEDDvtR8F8ulItmztwK7KL2MsN3JzkG1/4dL6cAVs31b86ykemDvHYjfn4xordxNnohDMIaOgwEsgiMEYDF+AYLIqNo6CQAA";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.ThesaurusCartographyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.ui.models.ThesaurusCartographyModel cartographyModel;
    protected org.jdesktop.swingx.JXTreeTable cartographyTable;
    protected ThesaurusCartographyUI thesaurusCartographyUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected SearchHandler getHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    void $afterCompleteSetup() {
        ThesaurusCartographyModel model = getContextValue(ThesaurusCartographyModel.class);
        cartographyTable.setTreeCellRenderer(model.new TreeCellRenderer());
        
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
        HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        cartographyTable.addHighlighter(highlighter);
        
        TableColumnModel columnModel = cartographyTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setWidth(350);
        column.setPreferredWidth(350);
        
        column = columnModel.getColumn(1);
        column.setWidth(80);
        column.setPreferredWidth(80);
        
        column = columnModel.getColumn(2);
        column.setWidth(150);
        column.setPreferredWidth(150);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusCartographyUI() {
        $initialize();
    }

    public ThesaurusCartographyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        this.dispose();
    }

    public void doWindowClosing__on__thesaurusCartographyUI(java.awt.event.WindowEvent event) {
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.models.ThesaurusCartographyModel getCartographyModel() {
        return cartographyModel;
    }

    public org.jdesktop.swingx.JXTreeTable getCartographyTable() {
        return cartographyTable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCartographyModel(com.jurismarches.vradi.ui.models.ThesaurusCartographyModel newValue) {
        com.jurismarches.vradi.ui.models.ThesaurusCartographyModel oldValue = this.cartographyModel;
        this.cartographyModel = newValue;
        firePropertyChange(PROPERTY_CARTOGRAPHY_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusCartographyUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void createCartographyModel() {
        $objectMap.put("cartographyModel", cartographyModel = getContextValue(ThesaurusCartographyModel.class));
    }

    protected void createCartographyTable() {
        $objectMap.put("cartographyTable", cartographyTable = new org.jdesktop.swingx.JXTreeTable());
        cartographyTable.setName("cartographyTable");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusCartographyUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(cartographyTable);
        
        // apply 11 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        cartographyTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        cartographyTable.setColumnControlVisible(true);
        cartographyTable.setExpandsSelectedPaths(true);
        cartographyTable.setGridColor(Color.GRAY);
        cartographyTable.setHorizontalScrollEnabled(true);
        cartographyTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        cartographyTable.setShowGrid(false);
        cartographyTable.setTreeTableModel(cartographyModel);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusCartographyUI", this);
        createCartographyModel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createCartographyTable();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of thesaurusCartographyUI
        setName("thesaurusCartographyUI");
        SwingUtil.setComponentHeight(thesaurusCartographyUI,380);
        thesaurusCartographyUI.getContentPane().setLayout(new BorderLayout());
        setModal(false);
        setTitle(_("vradi.thesaurusCartographyUI.title"));
        SwingUtil.setComponentWidth(thesaurusCartographyUI,600);
        thesaurusCartographyUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__thesaurusCartographyUI"));
        
        $completeSetup();
    }

}