/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.RawPostingList;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermVectorsTermsWriterPerField;
import org.apache.lucene.index.TermVectorsTermsWriterPerThread;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;

final class TermVectorsTermsWriter
extends TermsHashConsumer {
    final DocumentsWriter docWriter;
    TermVectorsWriter termVectorsWriter;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    IndexOutput tvx;
    IndexOutput tvd;
    IndexOutput tvf;
    int lastDocID;
    int allocCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TermVectorsTermsWriter(DocumentsWriter docWriter) {
        this.docWriter = docWriter;
    }

    public TermsHashConsumerPerThread addThread(TermsHashPerThread termsHashPerThread) {
        return new TermVectorsTermsWriterPerThread(termsHashPerThread, this);
    }

    void createPostings(RawPostingList[] postings, int start, int count) {
        int end = start + count;
        for (int i = start; i < end; ++i) {
            postings[i] = new PostingList();
        }
    }

    synchronized void flush(Map threadsAndFields, SegmentWriteState state) throws IOException {
        if (this.tvx != null) {
            if (state.numDocsInStore > 0) {
                this.fill(state.numDocsInStore - this.docWriter.getDocStoreOffset());
            }
            this.tvx.flush();
            this.tvd.flush();
            this.tvf.flush();
        }
        Iterator it = threadsAndFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Iterator it2 = ((Collection)entry.getValue()).iterator();
            while (it2.hasNext()) {
                TermVectorsTermsWriterPerField perField = (TermVectorsTermsWriterPerField)it2.next();
                perField.termsHashPerField.reset();
                perField.shrinkHash();
            }
            TermVectorsTermsWriterPerThread perThread = (TermVectorsTermsWriterPerThread)entry.getKey();
            perThread.termsHashPerThread.reset(true);
        }
    }

    synchronized void closeDocStore(SegmentWriteState state) throws IOException {
        if (this.tvx != null) {
            this.fill(state.numDocsInStore - this.docWriter.getDocStoreOffset());
            this.tvx.close();
            this.tvf.close();
            this.tvd.close();
            this.tvx = null;
            if (!$assertionsDisabled && state.docStoreSegmentName == null) {
                throw new AssertionError();
            }
            String fileName = state.docStoreSegmentName + "." + "tvx";
            if (4L + (long)state.numDocsInStore * 16L != state.directory.fileLength(fileName)) {
                throw new RuntimeException("after flush: tvx size mismatch: " + state.numDocsInStore + " docs vs " + state.directory.fileLength(fileName) + " length in bytes of " + fileName + " file exists?=" + state.directory.fileExists(fileName));
            }
            state.flushedFiles.add(state.docStoreSegmentName + "." + "tvx");
            state.flushedFiles.add(state.docStoreSegmentName + "." + "tvf");
            state.flushedFiles.add(state.docStoreSegmentName + "." + "tvd");
            this.docWriter.removeOpenFile(state.docStoreSegmentName + "." + "tvx");
            this.docWriter.removeOpenFile(state.docStoreSegmentName + "." + "tvf");
            this.docWriter.removeOpenFile(state.docStoreSegmentName + "." + "tvd");
            this.lastDocID = 0;
        }
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                if (!$assertionsDisabled && this.allocCount != 1 + this.docFreeList.length) {
                    throw new AssertionError();
                }
                this.docFreeList = new PerDoc[ArrayUtil.getNextSize(this.allocCount)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    void fill(int docID) throws IOException {
        int docStoreOffset = this.docWriter.getDocStoreOffset();
        int end = docID + docStoreOffset;
        if (this.lastDocID < end) {
            long tvfPosition = this.tvf.getFilePointer();
            while (this.lastDocID < end) {
                this.tvx.writeLong(this.tvd.getFilePointer());
                this.tvd.writeVInt(0);
                this.tvx.writeLong(tvfPosition);
                ++this.lastDocID;
            }
        }
    }

    synchronized void initTermVectorsWriter() throws IOException {
        if (this.tvx == null) {
            String docStoreSegment = this.docWriter.getDocStoreSegment();
            if (docStoreSegment == null) {
                return;
            }
            if (!$assertionsDisabled && docStoreSegment == null) {
                throw new AssertionError();
            }
            this.tvx = this.docWriter.directory.createOutput(docStoreSegment + "." + "tvx");
            this.tvd = this.docWriter.directory.createOutput(docStoreSegment + "." + "tvd");
            this.tvf = this.docWriter.directory.createOutput(docStoreSegment + "." + "tvf");
            this.tvx.writeInt(4);
            this.tvd.writeInt(4);
            this.tvf.writeInt(4);
            this.docWriter.addOpenFile(docStoreSegment + "." + "tvx");
            this.docWriter.addOpenFile(docStoreSegment + "." + "tvf");
            this.docWriter.addOpenFile(docStoreSegment + "." + "tvd");
            this.lastDocID = 0;
        }
    }

    synchronized void finishDocument(PerDoc perDoc) throws IOException {
        if (!$assertionsDisabled && !this.docWriter.writer.testPoint("TermVectorsTermsWriter.finishDocument start")) {
            throw new AssertionError();
        }
        this.initTermVectorsWriter();
        this.fill(perDoc.docID);
        this.tvx.writeLong(this.tvd.getFilePointer());
        this.tvx.writeLong(this.tvf.getFilePointer());
        this.tvd.writeVInt(perDoc.numVectorFields);
        if (perDoc.numVectorFields > 0) {
            for (int i = 0; i < perDoc.numVectorFields; ++i) {
                this.tvd.writeVInt(perDoc.fieldNumbers[i]);
            }
            if (!$assertionsDisabled && 0L != perDoc.fieldPointers[0]) {
                throw new AssertionError();
            }
            long lastPos = perDoc.fieldPointers[0];
            for (int i = 1; i < perDoc.numVectorFields; ++i) {
                long pos = perDoc.fieldPointers[i];
                this.tvd.writeVLong(pos - lastPos);
                lastPos = pos;
            }
            perDoc.tvf.writeTo(this.tvf);
            perDoc.tvf.reset();
            perDoc.numVectorFields = 0;
        }
        if (!$assertionsDisabled && this.lastDocID != perDoc.docID + this.docWriter.getDocStoreOffset()) {
            throw new AssertionError();
        }
        ++this.lastDocID;
        this.free(perDoc);
        if (!$assertionsDisabled && !this.docWriter.writer.testPoint("TermVectorsTermsWriter.finishDocument end")) {
            throw new AssertionError();
        }
    }

    public boolean freeRAM() {
        return false;
    }

    public void abort() {
        if (this.tvx != null) {
            try {
                this.tvx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.tvx = null;
        }
        if (this.tvd != null) {
            try {
                this.tvd.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.tvd = null;
        }
        if (this.tvf != null) {
            try {
                this.tvf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tvf = null;
        }
        this.lastDocID = 0;
    }

    synchronized void free(PerDoc doc) {
        if (!$assertionsDisabled && this.freeCount >= this.docFreeList.length) {
            throw new AssertionError();
        }
        this.docFreeList[this.freeCount++] = doc;
    }

    int bytesPerPosting() {
        return 32;
    }

    static {
        $assertionsDisabled = !TermVectorsTermsWriter.class.desiredAssertionStatus();
    }

    static final class PostingList
    extends RawPostingList {
        int freq;
        int lastOffset;
        int lastPosition;

        PostingList() {
        }
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        RAMOutputStream tvf = new RAMOutputStream();
        int numVectorFields;
        int[] fieldNumbers = new int[1];
        long[] fieldPointers = new long[1];

        PerDoc() {
        }

        void reset() {
            this.tvf.reset();
            this.numVectorFields = 0;
        }

        void abort() {
            this.reset();
            TermVectorsTermsWriter.this.free(this);
        }

        void addField(int fieldNumber) {
            if (this.numVectorFields == this.fieldNumbers.length) {
                this.fieldNumbers = ArrayUtil.grow(this.fieldNumbers);
                this.fieldPointers = ArrayUtil.grow(this.fieldPointers);
            }
            this.fieldNumbers[this.numVectorFields] = fieldNumber;
            this.fieldPointers[this.numVectorFields] = this.tvf.getFilePointer();
            ++this.numVectorFields;
        }

        public long sizeInBytes() {
            return this.tvf.sizeInBytes();
        }

        public void finish() throws IOException {
            TermVectorsTermsWriter.this.finishDocument(this);
        }
    }
}

