/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.multistorage;

import java.util.ArrayList;
import java.util.List;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyStorage;

public abstract class MultiStorageConfiguration {
    protected List<WikittyExtensionStorage> extensionStorageMasters = new ArrayList<WikittyExtensionStorage>();
    protected List<WikittyExtensionStorage> extensionStorageReplications = new ArrayList<WikittyExtensionStorage>();
    protected List<WikittyStorage> wikittyStorageMasters = new ArrayList<WikittyStorage>();
    protected List<WikittyStorage> wikittyStorageReplications = new ArrayList<WikittyStorage>();

    public void addExtensionStorage(WikittyExtensionStorage storage, boolean master) {
        if (master) {
            this.extensionStorageMasters.add(storage);
        } else {
            this.extensionStorageReplications.add(storage);
        }
    }

    public void addWikittyStorage(WikittyStorage storage, boolean master) {
        if (master) {
            this.wikittyStorageMasters.add(storage);
        } else {
            this.wikittyStorageReplications.add(storage);
        }
    }

    public List<WikittyExtensionStorage> getExtensionStorageMasters() {
        return this.extensionStorageMasters;
    }

    public void setExtensionStorageMasters(List<WikittyExtensionStorage> extensionStorageMasters) {
        this.extensionStorageMasters = extensionStorageMasters;
    }

    public List<WikittyExtensionStorage> getExtensionStorageReplications() {
        return this.extensionStorageReplications;
    }

    public void setExtensionStorageReplications(List<WikittyExtensionStorage> extensionStorageReplications) {
        this.extensionStorageReplications = extensionStorageReplications;
    }

    public List<WikittyStorage> getWikittyStorageMasters() {
        return this.wikittyStorageMasters;
    }

    public void setWikittyStorageMasters(List<WikittyStorage> wikittyStorageMasters) {
        this.wikittyStorageMasters = wikittyStorageMasters;
    }

    public List<WikittyStorage> getWikittyStorageReplications() {
        return this.wikittyStorageReplications;
    }

    public void setWikittyStorageReplications(List<WikittyStorage> wikittyStorageReplications) {
        this.wikittyStorageReplications = wikittyStorageReplications;
    }

    public abstract WikittyExtensionStorage getCurrentMasterExtensionStorage();

    public abstract WikittyStorage getCurrentMasterWikittyStorage();

    public static class BasicConfiguration
    extends MultiStorageConfiguration {
        @Override
        public WikittyExtensionStorage getCurrentMasterExtensionStorage() {
            if (!this.extensionStorageMasters.isEmpty()) {
                return (WikittyExtensionStorage)this.extensionStorageMasters.get(0);
            }
            throw new WikittyException("No master extension storage available");
        }

        @Override
        public WikittyStorage getCurrentMasterWikittyStorage() {
            if (!this.wikittyStorageMasters.isEmpty()) {
                return (WikittyStorage)this.wikittyStorageMasters.get(0);
            }
            throw new WikittyException("No master wikitty storage available");
        }
    }
}

