/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Enumeration;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationModelBuilder;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.NavigationNodeRendererDecoratorImpl;
import jaxx.runtime.swing.navigation.NavigationNodeRendererI18nImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNavigationModelBuilder<E extends NavigationNode<E>>
implements NavigationModelBuilder<E> {
    private static final Log log = LogFactory.getLog(AbstractNavigationModelBuilder.class);
    protected NavigationModel<E> model;
    protected Class<? extends JAXXObject> defaultUIClass;
    protected Class<? extends JAXXAction> defaultUIHandlerClass;
    protected boolean adjustingValue;

    public AbstractNavigationModelBuilder(Class<? extends JAXXObject> defaultUIClass, Class<? extends JAXXAction> defaultUIHandlerClass, NavigationModel<E> model) {
        this.defaultUIClass = defaultUIClass;
        this.defaultUIHandlerClass = defaultUIHandlerClass;
        this.model = model;
    }

    @Override
    public NavigationModel<E> getModel() {
        return this.model;
    }

    @Override
    public E buildEmptyRoot(JAXXContextEntryDef<?> entryDef, String contextName) {
        Object node = this.createNavigationNode(this.model.getPathSeparator(), contextName, entryDef, null);
        this.addI18nNodeRenderer(node, "");
        return this.addChildNode(null, node);
    }

    @Override
    public E build(E parentNode, String libelle, JAXXContextEntryDef<?> entryDef, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        Object node = this.createNavigationNode(this.model.getPathSeparator(), contextName, entryDef, entryPath);
        this.addI18nNodeRenderer(node, libelle);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public E build(E parentNode, String libelle, JAXXContextEntryDef<?> entryDef, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        Object node = this.createNavigationNode(this.model.getPathSeparator(), contextName, entryDef, null);
        this.addI18nNodeRenderer(node, libelle);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public E build(E parentNode, String libelle, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        Object node = this.createNavigationNode(this.model.getPathSeparator(), contextName, null, entryPath);
        this.addI18nNodeRenderer(node, libelle);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public E build(E parentNode, Decorator<?> decorator, JAXXContextEntryDef<?> entryDef, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        Object node = this.createNavigationNode(this.model.getPathSeparator(), contextName, entryDef, entryPath);
        this.addDecoratorNodeRenderer(node, decorator);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public E build(E parentNode, Decorator<?> decorator, JAXXContextEntryDef<?> entryDef, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        Object node = this.createNavigationNode(this.model.getPathSeparator(), contextName, entryDef, null);
        this.addDecoratorNodeRenderer(node, decorator);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public E build(E parentNode, Decorator<?> decorator, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        Object node = this.createNavigationNode(this.model.getPathSeparator(), contextName, null, entryPath);
        this.addDecoratorNodeRenderer(node, decorator);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public E removeChildNode(E node) {
        Object parentNode = node.getParent();
        this.model.removeNodeFromParent(node);
        return parentNode;
    }

    @Override
    public void moveNode(E parentNode, E node, int position) {
        parentNode.remove(node);
        parentNode.insert(node, position);
        NavigationModel<E> treeModel = this.getModel();
        treeModel.nodeStructureChanged(parentNode);
    }

    @Override
    public void addI18nNodeRenderer(E node, String libelle) {
        node.setRenderer(new NavigationNodeRendererI18nImpl(libelle));
    }

    @Override
    public void addDecoratorNodeRenderer(E node, Decorator<?> decorator) {
        node.setRenderer(new NavigationNodeRendererDecoratorImpl(decorator));
    }

    @Override
    public void addNodeJaxxClasses(E node, Class<? extends JAXXObject> uIClass, Class<? extends JAXXAction> uIHandlerClass) {
        node.setUIClass(uIClass);
        node.setUIHandlerClass(uIHandlerClass);
    }

    @Override
    public void printModel(E node) {
        if (node == null) {
            return;
        }
        log.info((Object)("node " + node.getFullPath() + ", jxpath: " + node.getJaxxContextEntryPath() + ", entryContextDef: " + node.getJaxxContextEntryDef()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("node userObject" + node.getUserObject()));
            log.debug((Object)("value from node " + node.getBean(this.getModel().getContext())));
            log.debug((Object)("value from model " + this.getModel().getBean(node)));
        }
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            this.printModel((NavigationNode)children.nextElement());
        }
    }

    protected E addChildNode(E parentNode, E node) {
        if (node.getUIClass() == null) {
            node.setUIClass(this.defaultUIClass);
        }
        if (node.getUIHandlerClass() == null) {
            node.setUIHandlerClass(this.defaultUIHandlerClass);
        }
        if (parentNode == null) {
            this.model.setRoot(node);
        } else {
            parentNode.add(node);
        }
        this.model.nodeStructureChanged(parentNode == null ? node : parentNode);
        return node;
    }
}

