/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.dto.VradiCartographyDTO;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

public interface VradiStorageService {
    public <E extends BusinessEntity> E getEntity(String var1, Class<E> var2) throws VradiException;

    public <E extends BusinessEntity> List<E> getEntities(List<String> var1, Class<E> var2) throws VradiException;

    public <E extends BusinessEntity> E updateEntity(E var1) throws VradiException;

    public <E extends BusinessEntity> E[] updateEntities(E ... var1) throws VradiException;

    public <E extends BusinessEntity> List<E> updateEntities(List<E> var1) throws VradiException;

    public void deleteEntity(String var1) throws VradiException;

    public void deleteEntity(BusinessEntity var1) throws VradiException;

    public Client getClient(String var1) throws VradiException;

    public User getUser(String var1) throws VradiException;

    public Group getGroup(String var1) throws VradiException;

    public String getQueryHistoryFile(String var1);

    public List<User> getGroupUsers(String var1) throws VradiException;

    @Deprecated
    public List<User> getClientUsers(String var1) throws VradiException;

    public List<Client> getGroupClients(String var1) throws VradiException;

    public Client getClientByUserId(String var1) throws VradiException;

    public List<Client> getAllClients() throws VradiException;

    public List<Group> getAllGroups() throws VradiException;

    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> var1) throws VradiException;

    public XmlStream updateXmlStream(XmlStream var1, List<XmlFieldBinding> var2) throws VradiException;

    public WikittyExtension updateFormType(WikittyExtension var1) throws VradiException;

    public WikittyExtension updateFormType2(String var1, Map<String, FieldType> var2, String var3, Map<String, String> var4) throws VradiException;

    public Form updateForm(Form var1) throws VradiException;

    public XmlStream getXmlStream(String var1) throws VradiException;

    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream var1) throws VradiException;

    public XmlFieldBinding getXmlFieldBinding(String var1) throws VradiException;

    public TreeNodeImpl getThesaurus(String var1) throws VradiException;

    public TreeNodeImpl getRootThesaurus() throws VradiException;

    public List<TreeNodeImpl> getChildrenThesaurus(String var1) throws VradiException;

    public Map<String, FieldType> getFormTypeFields(String var1) throws VradiException;

    public WikittyExtension getFormType(String var1) throws VradiException;

    public Form getForm(String var1) throws VradiException;

    public List<XmlStream> getAllXmlStreams() throws VradiException;

    public List<TreeNodeImpl> getAllThesaurus() throws VradiException;

    public List<WikittyExtension> getAllFormTypes() throws VradiException;

    public List<Form> getAllForms() throws VradiException;

    public VradiFormPageDTO findForms2(String var1, WikittyExtension var2, String var3, Date var4, Date var5, List<String>[] var6, String[] var7, VradiFormPageDTO var8) throws VradiException, UnsupportedQueryException;

    public VradiCartographyDTO getThesaurusCartography(String var1, WikittyExtension var2, String var3, Date var4, Date var5, List<String>[] var6, String[] var7) throws VradiException, UnsupportedQueryException;

    public VradiFormPageDTO findForms(String var1, VradiFormPageDTO var2) throws VradiException, UnsupportedQueryException;

    public void deleteForm(String var1) throws VradiException;

    public void bindForms() throws VradiException;

    public List<Sending> createSending(Session var1, QueryMaker var2, List<Form> var3) throws VradiException;

    public List<Session> getSessions(Date var1) throws VradiException;

    public int[] getFormsFromXmlStream(XmlStream var1, VradiUser var2) throws VradiException;

    public List<User> getAllUsers() throws VradiException;

    public List<VradiUserDTO> getAllUserDTOs() throws VradiException;

    public Map<QueryMaker, List<VradiQueryBean>> findQueriesReturningForm(Form var1) throws VradiException;

    public List<Form> getForms(List<String> var1) throws VradiException;

    public VradiUser updateVradiUser(VradiUser var1) throws VradiException;

    public VradiUser logVradiUser(String var1, String var2) throws VradiException;

    public void updateSendings(List<Sending> var1) throws VradiException;

    public void importData(File var1) throws VradiException;

    public String exportData() throws VradiException;

    public List<Form> updateForms(List<Form> var1) throws VradiException;

    public void importAsCSV(String var1) throws VradiException;

    public String exportAsCSV(Criteria var1) throws VradiException;

    public void reindexData() throws VradiException;

    public int getNbFormsForThesaurus(String var1) throws VradiException;

    public Status getStatus(String var1) throws VradiException;

    public List<Status> getStatuses(List<String> var1) throws VradiException;

    public List<Status> getAllStatuses() throws VradiException;

    public Status updateStatus(Status var1) throws VradiException;

    public List<Status> updateStatuses(List<Status> var1) throws VradiException;

    public void deleteStatus(String var1) throws VradiException;

    public void deleteStatuses(List<String> var1) throws VradiException;

    public List<TreeNodeImpl> proposeThesaurus(Form var1, List<TreeNodeImpl> var2) throws VradiException;

    public void archiveQueries(QueryMaker var1) throws VradiException;

    public void autoLoadFormsFromXmlStreams(String var1, int var2, Integer var3, Integer var4) throws VradiException;

    @Deprecated
    public void uploadFiles(Form var1, List<File> var2) throws IOException;

    @Deprecated
    public void uploadAttachments(Form var1, List<File> var2) throws IOException;

    @Deprecated
    public File addTemplate(WikittyExtension var1, File var2) throws VradiException;

    @Deprecated
    public File[] getTemplates(WikittyExtension var1);

    @Deprecated
    public File getTemplate(String var1, String var2);

    public void setAssociatedFields(String var1, String var2, Map<String, String> var3) throws VradiException, IOException;

    public Map<String, String> getAssociatedFields(String var1, String var2) throws VradiException;

    public Map<QueryMaker, List<VradiQueryBean>> getQueriesToModifyAfterThesaurusModification(String var1);

    public List<Sending> removeAllSending(Session var1, Form var2, QueryMaker var3) throws VradiException;
}

