/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.util;

public class EnvironmentDetect {
    public static void main(String[] a) {
        if (a.length < 1) {
            EnvironmentDetect.usage();
            EnvironmentDetect.show();
            System.exit(-1);
        }
        if (a[0].equals("-jvm")) {
            String vendor = EnvironmentDetect.detectJVM();
            if (vendor.indexOf("BEA") >= 0) {
                System.exit(2);
            } else if (vendor.indexOf("IBM") >= 0) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        if (a[0].equals("-java")) {
            String java = EnvironmentDetect.detectJava();
            if (java.indexOf("1.5") >= 0) {
                System.exit(15);
            } else if (java.indexOf("1.4") >= 0) {
                System.exit(14);
            } else if (java.indexOf("1.3") >= 0) {
                System.exit(13);
            } else {
                System.exit(0);
            }
        }
        if (a.length > 1) {
            EnvironmentDetect.show();
        }
    }

    public static String detectJVM() {
        return System.getProperty("java.vendor").toUpperCase();
    }

    public static String detectJava() {
        return System.getProperty("java.version").toUpperCase();
    }

    public static void show() {
        System.out.println(EnvironmentDetect.detectJVM());
        System.out.println(EnvironmentDetect.detectJava());
    }

    public static void usage() {
        System.out.println("Usage: -jvm | -java");
    }
}

