/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.DeploymentScope;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AfterObjectInitializationCodeAdapter;

public class InstanceLevelAspectVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private final ClassInfo m_classInfo;
    private boolean m_isAdvised = false;

    public InstanceLevelAspectVisitor(ClassVisitor cv, ClassInfo classInfo, Context ctx) {
        super(cv);
        this.m_classInfo = classInfo;
        this.m_ctx = (ContextImpl)ctx;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        if (InstanceLevelAspectVisitor.classFilter(this.m_classInfo, this.m_ctx.getDefinitions())) {
            super.visit(version, access, name, superName, interfaces, sourceFile);
            return;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            String anInterface = interfaces[i];
            if (!anInterface.equals("org/codehaus/aspectwerkz/aspect/management/HasInstanceLevelAspect")) continue;
            super.visit(version, access, name, superName, interfaces, sourceFile);
            return;
        }
        String[] newInterfaceArray = new String[interfaces.length + 1];
        for (int i = 0; i < interfaces.length; ++i) {
            newInterfaceArray[i] = interfaces[i];
        }
        newInterfaceArray[interfaces.length] = "org/codehaus/aspectwerkz/aspect/management/HasInstanceLevelAspect";
        super.visit(version, access, name, superName, newInterfaceArray, sourceFile);
        this.addAspectMapField();
        this.addGetAspectMethod(name);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        if (this.m_isAdvised && name.equals("<init>")) {
            AppendToInitMethodCodeAdapter mv = new AppendToInitMethodCodeAdapter(this.cv.visitMethod(access, name, desc, exceptions, attrs), name);
            mv.visitMaxs(0, 0);
            return mv;
        }
        return this.cv.visitMethod(access, name, desc, exceptions, attrs);
    }

    private void addAspectMapField() {
        super.visitField(4226, "aw$instanceLevelAspects", "Ljava/util/Map;", null, null);
    }

    private void addGetAspectMethod(String name) {
        CodeVisitor cv = super.visitMethod(4097, "aw$getAspect", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, name, "aw$instanceLevelAspects", "Ljava/util/Map;");
        Label ifFieldNullNotLabel = new Label();
        cv.visitJumpInsn(199, ifFieldNullNotLabel);
        cv.visitVarInsn(25, 0);
        cv.visitTypeInsn(187, "java/util/HashMap");
        cv.visitInsn(89);
        cv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        cv.visitFieldInsn(181, this.m_classInfo.getName().replace('.', '/'), "aw$instanceLevelAspects", "Ljava/util/Map;");
        cv.visitLabel(ifFieldNullNotLabel);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, name, "aw$instanceLevelAspects", "Ljava/util/Map;");
        cv.visitVarInsn(25, 2);
        cv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitVarInsn(58, 4);
        cv.visitVarInsn(25, 4);
        Label ifNullNotLabel = new Label();
        cv.visitJumpInsn(199, ifNullNotLabel);
        cv.visitVarInsn(25, 2);
        cv.visitVarInsn(25, 3);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(184, "org/codehaus/aspectwerkz/aspect/management/Aspects", "aspect$Of", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitVarInsn(58, 4);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, name, "aw$instanceLevelAspects", "Ljava/util/Map;");
        cv.visitVarInsn(25, 2);
        cv.visitVarInsn(25, 4);
        cv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitInsn(87);
        cv.visitLabel(ifNullNotLabel);
        cv.visitVarInsn(25, 4);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        this.m_ctx.markAsAdvised();
        this.m_isAdvised = true;
    }

    public static boolean classFilter(ClassInfo classInfo, Set definitions) {
        if (classInfo.isInterface()) {
            return true;
        }
        ExpressionContext ctx = new ExpressionContext(PointcutType.WITHIN, null, classInfo);
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            String className;
            SystemDefinition systemDef = (SystemDefinition)it.next();
            if (systemDef.inExcludePackage(className = classInfo.getName().replace('/', '.'))) {
                return true;
            }
            if (!systemDef.inIncludePackage(className)) {
                return true;
            }
            Collection adviceDefs = systemDef.getAdviceDefinitions();
            Iterator defs = adviceDefs.iterator();
            while (defs.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)defs.next();
                ExpressionInfo expressionInfo = adviceDef.getExpressionInfo();
                if (expressionInfo == null || !adviceDef.getAspectDefinition().getDeploymentModel().equals(DeploymentModel.PER_INSTANCE) || !expressionInfo.getAdvisedClassFilterExpression().match(ctx)) continue;
                return false;
            }
            Collection deploymentScopes = systemDef.getDeploymentScopes();
            Iterator scopes = deploymentScopes.iterator();
            while (scopes.hasNext()) {
                DeploymentScope deploymentScope = (DeploymentScope)scopes.next();
                ExpressionInfo expression = new ExpressionInfo(deploymentScope.getExpression(), systemDef.getUuid());
                if (!expression.getAdvisedClassFilterExpression().match(ctx)) continue;
                return false;
            }
        }
        return true;
    }

    private class AppendToInitMethodCodeAdapter
    extends AfterObjectInitializationCodeAdapter {
        private boolean m_done = false;

        public AppendToInitMethodCodeAdapter(CodeVisitor ca, String callerMemberName) {
            super(ca, callerMemberName);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (opcode == 183 && this.m_isObjectInitialized && !this.m_done) {
                this.m_done = true;
                this.cv.visitVarInsn(25, 0);
                this.cv.visitTypeInsn(187, "java/util/HashMap");
                this.cv.visitInsn(89);
                this.cv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
                this.cv.visitFieldInsn(181, InstanceLevelAspectVisitor.this.m_classInfo.getName().replace('.', '/'), "aw$instanceLevelAspects", "Ljava/util/Map;");
            }
        }
    }
}

