/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AlreadyAddedMethodAdapter;

public class ConstructorBodyVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private final ClassInfo m_calleeClassInfo;
    private String m_declaringTypeName;
    private Set m_addedMethods;

    public ConstructorBodyVisitor(ClassVisitor cv, ClassInfo classInfo, Context ctx, Set addedMethods) {
        super(cv);
        this.m_calleeClassInfo = classInfo;
        this.m_ctx = (ContextImpl)ctx;
        this.m_addedMethods = addedMethods;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.m_declaringTypeName = name;
        super.visit(version, access, name, superName, interfaces, sourceFile);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        String wrapperDesc;
        if (!"<init>".equals(name)) {
            return super.visitMethod(access, name, desc, exceptions, attrs);
        }
        int hash = AsmHelper.calculateConstructorHash(desc);
        ConstructorInfo constructorInfo = this.m_calleeClassInfo.getConstructor(hash);
        if (constructorInfo == null) {
            System.err.println("AW::WARNING metadata structure could not be build for constructor [" + this.m_calleeClassInfo.getName().replace('/', '.') + ".<init>: " + desc + ']');
            return this.cv.visitMethod(access, name, desc, exceptions, attrs);
        }
        ExpressionContext ctx = new ExpressionContext(PointcutType.EXECUTION, constructorInfo, constructorInfo);
        if (ConstructorBodyVisitor.constructorFilter(this.m_ctx.getDefinitions(), ctx)) {
            return this.cv.visitMethod(access, name, desc, exceptions, attrs);
        }
        String wrapperName = TransformationUtil.getConstructorBodyMethodName(this.m_declaringTypeName);
        if (this.m_addedMethods.contains(AlreadyAddedMethodAdapter.getMethodKey(wrapperName, wrapperDesc = TransformationUtil.getConstructorBodyMethodSignature(desc, this.m_declaringTypeName)))) {
            return this.cv.visitMethod(access, name, desc, exceptions, attrs);
        }
        this.m_ctx.markAsAdvised();
        CodeVisitor proxyCtorCodeVisitor = this.cv.visitMethod(access, name, desc, exceptions, attrs);
        int modifiers = 4104;
        CodeVisitor ctorBodyMethodCodeVisitor = this.cv.visitMethod(modifiers, wrapperName, wrapperDesc, exceptions, attrs);
        return new DispatchCtorBodyCodeAdapter(proxyCtorCodeVisitor, ctorBodyMethodCodeVisitor, access, desc);
    }

    private void insertJoinPointInvoke(CodeVisitor ctorProxy, int access, String desc) {
        ctorProxy.visitVarInsn(25, 0);
        AsmHelper.loadArgumentTypes(ctorProxy, Type.getArgumentTypes(desc), false);
        ctorProxy.visitVarInsn(25, 0);
        int joinPointHash = AsmHelper.calculateConstructorHash(desc);
        String joinPointClassName = TransformationUtil.getJoinPointClassName(this.m_declaringTypeName, "<init>", desc, this.m_declaringTypeName, 3, joinPointHash);
        ctorProxy.visitMethodInsn(184, joinPointClassName, "invoke", TransformationUtil.getInvokeSignatureForCodeJoinPoints(access, desc, this.m_declaringTypeName, this.m_declaringTypeName));
        this.m_ctx.addEmittedJoinPoint(new EmittedJoinPoint(3, this.m_declaringTypeName, "<init>", desc, access, this.m_declaringTypeName, "<init>", desc, access, joinPointHash, joinPointClassName, EmittedJoinPoint.NO_LINE_NUMBER));
    }

    public static boolean constructorFilter(Set definitions, ExpressionContext ctx) {
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            if (!((SystemDefinition)it.next()).hasPointcut(ctx)) continue;
            return false;
        }
        return true;
    }

    private class DispatchCtorBodyCodeAdapter
    extends CodeAdapter {
        private CodeVisitor m_ctorBodyMethodCodeVisitor;
        private CodeVisitor m_proxyCtorCodeVisitor;
        private final int m_constructorAccess;
        private final String m_constructorDesc;
        private int m_newCount = 0;
        private boolean m_proxyCtorCodeDone = false;
        private boolean m_isALOADDUPHeuristic = false;
        private int m_index = -1;

        public DispatchCtorBodyCodeAdapter(CodeVisitor proxyCtor, CodeVisitor ctorBodyMethod, int access, String desc) {
            super(proxyCtor);
            this.m_proxyCtorCodeVisitor = proxyCtor;
            this.m_ctorBodyMethodCodeVisitor = ctorBodyMethod;
            this.m_constructorAccess = access;
            this.m_constructorDesc = desc;
        }

        public void visitInsn(int opcode) {
            super.visitInsn(opcode);
            if (!this.m_proxyCtorCodeDone && opcode == 89 && this.m_index == 0) {
                this.m_isALOADDUPHeuristic = true;
                ++this.m_index;
            }
        }

        public void visitIntInsn(int i, int i1) {
            super.visitIntInsn(i, i1);
        }

        public void visitVarInsn(int opcode, int i1) {
            super.visitVarInsn(opcode, i1);
            if (!this.m_proxyCtorCodeDone && opcode == 25 && i1 == 0) {
                ++this.m_index;
            }
        }

        public void visitFieldInsn(int i, String s, String s1, String s2) {
            super.visitFieldInsn(i, s, s1, s2);
        }

        public void visitLdcInsn(Object o) {
            super.visitLdcInsn(o);
        }

        public void visitIincInsn(int i, int i1) {
            super.visitIincInsn(i, i1);
        }

        public void visitMultiANewArrayInsn(String s, int i) {
            super.visitMultiANewArrayInsn(s, i);
        }

        public void visitTypeInsn(int opcode, String name) {
            super.visitTypeInsn(opcode, name);
            if (opcode == 187) {
                ++this.m_newCount;
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (!this.m_proxyCtorCodeDone) {
                if (opcode == 183) {
                    if (this.m_newCount == 0) {
                        this.m_proxyCtorCodeVisitor.visitMethodInsn(opcode, owner, name, desc);
                        ConstructorBodyVisitor.this.insertJoinPointInvoke(this.m_proxyCtorCodeVisitor, this.m_constructorAccess, this.m_constructorDesc);
                        this.m_proxyCtorCodeVisitor.visitInsn(177);
                        this.m_proxyCtorCodeVisitor.visitMaxs(0, 0);
                        this.m_proxyCtorCodeVisitor = null;
                        this.m_proxyCtorCodeDone = true;
                        this.cv = this.m_ctorBodyMethodCodeVisitor;
                        if (this.m_isALOADDUPHeuristic) {
                            this.m_ctorBodyMethodCodeVisitor.visitVarInsn(25, 0);
                        }
                    } else {
                        --this.m_newCount;
                        this.cv.visitMethodInsn(opcode, owner, name, desc);
                    }
                } else {
                    this.cv.visitMethodInsn(opcode, owner, name, desc);
                }
            } else {
                this.cv.visitMethodInsn(opcode, owner, name, desc);
            }
        }
    }
}

