/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.deployer;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.annotation.AspectAnnotationParser;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.DeploymentScope;
import org.codehaus.aspectwerkz.definition.DocumentParser;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.definition.XmlParser;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.joinpoint.management.AdviceInfoContainer;
import org.codehaus.aspectwerkz.joinpoint.management.JoinPointManager;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.AspectModelManager;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilationInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.JoinPointFactory;
import org.codehaus.aspectwerkz.transform.inlining.compiler.MatchingJoinPointInfo;
import org.codehaus.aspectwerkz.transform.inlining.deployer.ChangeSet;
import org.codehaus.aspectwerkz.transform.inlining.deployer.DeploymentHandle;
import org.codehaus.aspectwerkz.transform.inlining.deployer.RedefinerFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class Deployer {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;

    public static DeploymentHandle deploy(Class aspect) {
        return Deployer.deploy(aspect, DeploymentScope.MATCH_ALL);
    }

    public static DeploymentHandle deploy(String aspectClassName) {
        return Deployer.deploy(aspectClassName, DeploymentScope.MATCH_ALL);
    }

    public static DeploymentHandle deploy(Class aspect, ClassLoader deployLoader) {
        return Deployer.deploy(aspect, DeploymentScope.MATCH_ALL, deployLoader);
    }

    public static DeploymentHandle deploy(String aspectClassName, ClassLoader deployLoader) {
        return Deployer.deploy(aspectClassName, DeploymentScope.MATCH_ALL, deployLoader);
    }

    public static DeploymentHandle deploy(Class aspect, DeploymentScope deploymentScope) {
        return Deployer.deploy(aspect, deploymentScope, Thread.currentThread().getContextClassLoader());
    }

    public static DeploymentHandle deploy(String aspectClassName, DeploymentScope deploymentScope) {
        return Deployer.deploy(aspectClassName, deploymentScope, Thread.currentThread().getContextClassLoader());
    }

    public static DeploymentHandle deploy(Class aspect, DeploymentScope deploymentScope, ClassLoader deployLoader) {
        if (aspect == null) {
            throw new IllegalArgumentException("aspect to deploy can not be null");
        }
        if (deploymentScope == null) {
            throw new IllegalArgumentException("prepared pointcut can not be null");
        }
        if (deployLoader == null) {
            throw new IllegalArgumentException("class loader to deploy aspect in can not be null");
        }
        String className = aspect.getName();
        return Deployer.deploy(className, deploymentScope, deployLoader);
    }

    public static synchronized DeploymentHandle deploy(String className, DeploymentScope deploymentScope, ClassLoader deployLoader) {
        Deployer.logDeployment(className, deployLoader);
        Class<?> aspectClass = null;
        try {
            aspectClass = Class.forName(className, false, deployLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load class [" + className + "] in class loader [" + deployLoader + "]");
        }
        DeploymentHandle deploymentHandle = new DeploymentHandle(aspectClass, deployLoader);
        ClassInfo aspectClassInfo = JavaClassInfo.getClassInfo(aspectClass);
        SystemDefinition systemDef = SystemDefinitionContainer.getVirtualDefinitionAt(deployLoader);
        AspectDefinition newAspectDef = new AspectDefinition(className, aspectClassInfo, systemDef);
        Set newExpressions = Deployer.getNewExpressionsForAspect(aspectClass, newAspectDef, systemDef, deploymentScope, deploymentHandle);
        Deployer.redefine(newExpressions);
        return deploymentHandle;
    }

    public static DeploymentHandle deploy(Class aspect, String xmlDef) {
        return Deployer.deploy(aspect, xmlDef, DeploymentScope.MATCH_ALL);
    }

    public static DeploymentHandle deploy(Class aspect, String xmlDef, DeploymentScope deploymentScope) {
        return Deployer.deploy(aspect, xmlDef, deploymentScope, aspect.getClassLoader());
    }

    public static DeploymentHandle deploy(Class aspect, String xmlDef, ClassLoader deployLoader) {
        return Deployer.deploy(aspect, xmlDef, DeploymentScope.MATCH_ALL, deployLoader);
    }

    public static synchronized DeploymentHandle deploy(Class aspect, String xmlDef, DeploymentScope deploymentScope, ClassLoader deployLoader) {
        if (aspect == null) {
            throw new IllegalArgumentException("aspect to deploy can not be null");
        }
        if (deploymentScope == null) {
            throw new IllegalArgumentException("prepared pointcut can not be null");
        }
        if (xmlDef == null) {
            throw new IllegalArgumentException("xml definition can not be null");
        }
        if (deployLoader == null) {
            throw new IllegalArgumentException("class loader to deploy aspect in can not be null");
        }
        String className = aspect.getName();
        Deployer.logDeployment(className, deployLoader);
        DeploymentHandle deploymentHandle = new DeploymentHandle(aspect, deployLoader);
        SystemDefinition systemDef = SystemDefinitionContainer.getVirtualDefinitionAt(deployLoader);
        try {
            Document document = XmlParser.createDocument(xmlDef);
            AspectDefinition newAspectDef = DocumentParser.parseAspectDefinition(document, systemDef, aspect);
            Set newExpressions = Deployer.getNewExpressionsForAspect(aspect, newAspectDef, systemDef, deploymentScope, deploymentHandle);
            Deployer.redefine(newExpressions);
        }
        catch (DocumentException e) {
            throw new DefinitionException("XML definition for aspect is not well-formed: " + xmlDef);
        }
        return deploymentHandle;
    }

    public static void undeploy(Class aspect) {
        Deployer.undeploy(aspect, aspect.getClassLoader());
    }

    public static void undeploy(Class aspect, ClassLoader loader) {
        if (aspect == null) {
            throw new IllegalArgumentException("aspect to undeploy can not be null");
        }
        if (loader == null) {
            throw new IllegalArgumentException("loader to undeploy aspect from can not be null");
        }
        Deployer.undeploy(aspect.getName(), loader);
    }

    public static void undeploy(String className, ClassLoader loader) {
        Deployer.logUndeployment(className, loader);
        Set systemDefs = SystemDefinitionContainer.getDefinitionsAt(loader);
        Iterator it = systemDefs.iterator();
        while (it.hasNext()) {
            SystemDefinition systemDef = (SystemDefinition)it.next();
            AspectDefinition aspectDef = systemDef.getAspectDefinition(className);
            if (aspectDef == null) continue;
            HashSet<ExpressionInfo> newExpressions = new HashSet<ExpressionInfo>();
            Iterator it2 = aspectDef.getAdviceDefinitions().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                ExpressionInfo oldExpression = adviceDef.getExpressionInfo();
                if (oldExpression == null) continue;
                adviceDef.setExpressionInfo(null);
                newExpressions.add(oldExpression);
            }
            Deployer.redefine(newExpressions);
        }
    }

    public static void undeploy(DeploymentHandle deploymentHandle) {
        if (deploymentHandle == null) {
            throw new IllegalArgumentException("deployment handle can not be null");
        }
        deploymentHandle.revertChanges();
        Class aspectClass = deploymentHandle.getAspectClass();
        if (aspectClass == null) {
            return;
        }
        Deployer.undeploy(aspectClass);
    }

    private static void redefine(Set expressions) {
        HashSet allMatchingJoinPoints = new HashSet();
        Iterator itExpr = expressions.iterator();
        while (itExpr.hasNext()) {
            ExpressionInfo expression = (ExpressionInfo)itExpr.next();
            Set matchingJoinPoints = JoinPointFactory.getJoinPointsMatching(expression);
            allMatchingJoinPoints.addAll(matchingJoinPoints);
        }
        ChangeSet changeSet = new ChangeSet();
        Iterator it = allMatchingJoinPoints.iterator();
        while (it.hasNext()) {
            MatchingJoinPointInfo joinPointInfo = (MatchingJoinPointInfo)it.next();
            CompilationInfo compilationInfo = joinPointInfo.getCompilationInfo();
            compilationInfo.incrementRedefinitionCounter();
            changeSet.addElement(new ChangeSet.Element(compilationInfo, joinPointInfo));
        }
        Deployer.doRedefine(changeSet);
    }

    private static void doRedefine(ChangeSet changeSet) {
        Iterator it = changeSet.getElements().iterator();
        while (it.hasNext()) {
            Deployer.compileNewJoinPoint((ChangeSet.Element)it.next());
        }
        Deployer.redefineInitialJoinPoints(changeSet);
    }

    private static void compileNewJoinPoint(ChangeSet.Element changeSetElement) {
        CompilationInfo compilationInfo = changeSetElement.getCompilationInfo();
        MatchingJoinPointInfo joinPointInfo = changeSetElement.getJoinPointInfo();
        ClassLoader loader = joinPointInfo.getJoinPointClass().getClassLoader();
        AdviceInfoContainer newAdviceContainer = JoinPointManager.getAdviceInfoContainerForJoinPoint(joinPointInfo.getExpressionContext(), loader);
        CompilationInfo.Model redefinedModel = new CompilationInfo.Model(compilationInfo.getInitialModel().getEmittedJoinPoint(), newAdviceContainer, compilationInfo.getRedefinitionCounter(), compilationInfo.getInitialModel().getThisClassInfo());
        JoinPointFactory.compileJoinPointAndAttachToClassLoader(redefinedModel, loader);
        compilationInfo.setRedefinedModel(redefinedModel);
        JoinPointFactory.addCompilationInfo(joinPointInfo.getJoinPointClass(), compilationInfo);
    }

    private static void redefineInitialJoinPoints(ChangeSet changeSet) {
        RedefinerFactory.newRedefiner(RedefinerFactory.Type.HOTSWAP).redefine(changeSet);
    }

    private static Set getNewExpressionsForAspect(Class aspectClass, AspectDefinition newAspectDef, SystemDefinition systemDef, DeploymentScope deploymentScope, DeploymentHandle deploymentHandle) {
        ClassLoader aspectLoader = aspectClass.getClassLoader();
        String aspectName = aspectClass.getName();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(aspectName, aspectLoader);
        AspectModelManager.defineAspect(classInfo, newAspectDef, aspectLoader);
        AspectAnnotationParser.parse(classInfo, newAspectDef, aspectLoader);
        AspectDefinition aspectDef = systemDef.getAspectDefinition(aspectName);
        if (aspectDef != null) {
            newAspectDef.setContainerClassName(aspectDef.getContainerClassName());
            newAspectDef.setDeploymentModel(aspectDef.getDeploymentModel());
        }
        systemDef.addAspectOverwriteIfExists(newAspectDef);
        HashSet<ExpressionInfo> newExpressions = new HashSet<ExpressionInfo>();
        Iterator it2 = newAspectDef.getAdviceDefinitions().iterator();
        while (it2.hasNext()) {
            AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
            ExpressionInfo oldExpression = adviceDef.getExpressionInfo();
            if (oldExpression == null) continue;
            deploymentHandle.registerDefinitionChange(adviceDef, oldExpression);
            ExpressionInfo newExpression = deploymentScope.newExpressionInfo(oldExpression);
            adviceDef.setExpressionInfo(newExpression);
            newExpressions.add(newExpression);
        }
        return newExpressions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void importClassIntoLoader(Class clazz, ClassLoader toLoader) {
        ClassLoader fromLoader = clazz.getClassLoader();
        if (toLoader == fromLoader) {
            return;
        }
        String className = clazz.getName();
        try {
            Class.forName(className, false, toLoader);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                void var6_7;
                InputStream stream = null;
                try {
                    stream = fromLoader.getResourceAsStream(className.replace('.', '/') + ".class");
                    byte[] bytes = new ClassReader((InputStream)stream).b;
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {}
                }
                Class<?> klass = Class.forName("java.lang.ClassLoader", false, toLoader);
                Method method = klass.getDeclaredMethod("defineClass", class$java$lang$String == null ? (class$java$lang$String = Deployer.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = Deployer.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                Object[] args = new Object[]{clazz.getName(), var6_7, new Integer(0), new Integer(((void)var6_7).length)};
                method.invoke((Object)toLoader, args);
                method.setAccessible(false);
            }
            catch (Exception e) {
                throw new RuntimeException("could not deploy aspect [" + className + "] in class loader [" + toLoader + ']');
            }
        }
    }

    private static void logUndeployment(String className, ClassLoader loader) {
        System.out.println("Deployer::INFO - undeploying aspect [" + className + "] from class loader [" + loader + ']');
    }

    private static void logDeployment(String className, ClassLoader loader) {
        System.out.println("Deployer::INFO - deploying aspect [" + className + "] in class loader [" + loader + ']');
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

