/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.compiler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilationInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.ConstructorCallJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.ConstructorCallJoinPointRedefiner;
import org.codehaus.aspectwerkz.transform.inlining.compiler.ConstructorExecutionJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.ConstructorExecutionJoinPointRedefiner;
import org.codehaus.aspectwerkz.transform.inlining.compiler.FieldGetJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.FieldGetJoinPointRedefiner;
import org.codehaus.aspectwerkz.transform.inlining.compiler.FieldSetJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.FieldSetJoinPointRedefiner;
import org.codehaus.aspectwerkz.transform.inlining.compiler.HandlerJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.HandlerJoinPointRedefiner;
import org.codehaus.aspectwerkz.transform.inlining.compiler.MatchingJoinPointInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.MethodCallJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.MethodCallJoinPointRedefiner;
import org.codehaus.aspectwerkz.transform.inlining.compiler.MethodExecutionJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.MethodExecutionJoinPointRedefiner;
import org.codehaus.aspectwerkz.transform.inlining.compiler.StaticInitializationJoinPointCompiler;

public class JoinPointFactory {
    private static final Map COMPILATION_INFO_REPOSITORY = new WeakHashMap();

    public static Class compileJoinPointAndAttachToClassLoader(CompilationInfo.Model model, ClassLoader loader) {
        return JoinPointFactory.attachToClassLoader(model.getJoinPointClassName(), loader, JoinPointFactory.compileJoinPoint(model));
    }

    public static Class attachToClassLoader(String joinpointClassName, ClassLoader loader, byte[] bytecode) {
        return AsmHelper.defineClass(loader, bytecode, joinpointClassName);
    }

    public static void addCompilationInfo(Class clazz, CompilationInfo compilationInfo) {
        COMPILATION_INFO_REPOSITORY.put(clazz, compilationInfo);
    }

    public static byte[] compileJoinPoint(CompilationInfo.Model model) {
        switch (model.getEmittedJoinPoint().getJoinPointType()) {
            case 1: {
                return new MethodExecutionJoinPointCompiler(model).compile();
            }
            case 2: {
                return new MethodCallJoinPointCompiler(model).compile();
            }
            case 3: {
                return new ConstructorExecutionJoinPointCompiler(model).compile();
            }
            case 4: {
                return new ConstructorCallJoinPointCompiler(model).compile();
            }
            case 5: {
                return new FieldSetJoinPointCompiler(model).compile();
            }
            case 6: {
                return new FieldGetJoinPointCompiler(model).compile();
            }
            case 7: {
                return new HandlerJoinPointCompiler(model).compile();
            }
            case 8: {
                return new StaticInitializationJoinPointCompiler(model).compile();
            }
        }
        throw new UnsupportedOperationException("join point type is not supported: " + model.getEmittedJoinPoint().getJoinPointType());
    }

    public static byte[] redefineJoinPoint(CompilationInfo compilationInfo) {
        switch (compilationInfo.getInitialModel().getEmittedJoinPoint().getJoinPointType()) {
            case 1: {
                return new MethodExecutionJoinPointRedefiner(compilationInfo).compile();
            }
            case 2: {
                return new MethodCallJoinPointRedefiner(compilationInfo).compile();
            }
            case 3: {
                return new ConstructorExecutionJoinPointRedefiner(compilationInfo).compile();
            }
            case 4: {
                return new ConstructorCallJoinPointRedefiner(compilationInfo).compile();
            }
            case 5: {
                return new FieldSetJoinPointRedefiner(compilationInfo).compile();
            }
            case 6: {
                return new FieldGetJoinPointRedefiner(compilationInfo).compile();
            }
            case 7: {
                return new HandlerJoinPointRedefiner(compilationInfo).compile();
            }
        }
        throw new UnsupportedOperationException("join point type is not supported: " + compilationInfo.getInitialModel().getEmittedJoinPoint().getJoinPointType());
    }

    public static Set getJoinPointsMatching(ExpressionInfo expression) {
        HashSet<MatchingJoinPointInfo> matchingJoinPointInfos = new HashSet<MatchingJoinPointInfo>();
        Iterator it = COMPILATION_INFO_REPOSITORY.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Class clazz = (Class)entry.getKey();
            CompilationInfo compilationInfo = (CompilationInfo)entry.getValue();
            EmittedJoinPoint joinPoint = compilationInfo.getInitialModel().getEmittedJoinPoint();
            ClassLoader loader = clazz.getClassLoader();
            ClassInfo calleeClassInfo = AsmClassInfo.getClassInfo(joinPoint.getCalleeClassName(), loader);
            ClassInfo callerClassInfo = AsmClassInfo.getClassInfo(joinPoint.getCallerClassName(), loader);
            MethodInfo callerMethodInfo = JoinPointFactory.getCallerMethodInfo(callerClassInfo, joinPoint);
            ExpressionContext ctx = null;
            switch (joinPoint.getJoinPointType()) {
                case 1: {
                    ctx = new ExpressionContext(PointcutType.EXECUTION, calleeClassInfo.getMethod(joinPoint.getJoinPointHash()), callerMethodInfo);
                    break;
                }
                case 2: {
                    ctx = new ExpressionContext(PointcutType.CALL, calleeClassInfo.getMethod(joinPoint.getJoinPointHash()), callerMethodInfo);
                    break;
                }
                case 3: {
                    ctx = new ExpressionContext(PointcutType.EXECUTION, calleeClassInfo.getConstructor(joinPoint.getJoinPointHash()), callerMethodInfo);
                    break;
                }
                case 4: {
                    ctx = new ExpressionContext(PointcutType.CALL, calleeClassInfo.getConstructor(joinPoint.getJoinPointHash()), callerMethodInfo);
                    break;
                }
                case 5: {
                    ctx = new ExpressionContext(PointcutType.SET, calleeClassInfo.getField(joinPoint.getJoinPointHash()), callerMethodInfo);
                    break;
                }
                case 6: {
                    ctx = new ExpressionContext(PointcutType.GET, calleeClassInfo.getField(joinPoint.getJoinPointHash()), callerMethodInfo);
                    break;
                }
                case 7: {
                    ctx = new ExpressionContext(PointcutType.HANDLER, AsmClassInfo.getClassInfo(joinPoint.getCalleeClassName(), loader), callerMethodInfo);
                    break;
                }
                case 8: {
                    ctx = new ExpressionContext(PointcutType.STATIC_INITIALIZATION, calleeClassInfo.staticInitializer(), calleeClassInfo);
                }
            }
            if (!expression.getExpression().match(ctx)) continue;
            matchingJoinPointInfos.add(new MatchingJoinPointInfo(clazz, compilationInfo, ctx));
        }
        return matchingJoinPointInfos;
    }

    public static EmittedJoinPoint getEmittedJoinPoint(Class clazz) {
        return (EmittedJoinPoint)COMPILATION_INFO_REPOSITORY.get(clazz);
    }

    private static MethodInfo getCallerMethodInfo(ClassInfo callerClassInfo, EmittedJoinPoint emittedJoinPoint) {
        MethodInfo callerMethodInfo = null;
        MethodInfo[] callerMethods = callerClassInfo.getMethods();
        for (int i = 0; i < callerMethods.length; ++i) {
            MethodInfo method = callerMethods[i];
            if (!method.getName().equals(emittedJoinPoint.getCallerMethodName()) || !method.getSignature().equals(emittedJoinPoint.getCallerMethodDesc())) continue;
            callerMethodInfo = method;
            break;
        }
        return callerMethodInfo;
    }
}

