/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.proxy;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.AsmAnnotationHelper;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.Attributes;
import org.codehaus.aspectwerkz.proxy.Proxy;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;

public class ProxyCompiler
implements TransformationConstants {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static InputStream getProxyResourceAsStream(ClassLoader loader, String proxyClassName) {
        String className = Proxy.getUniqueClassNameFromProxy(proxyClassName);
        if (className != null) {
            byte[] proxy = ProxyCompiler.compileProxyFor(loader, className, proxyClassName);
            return new BufferedInputStream(new ByteArrayInputStream(proxy));
        }
        return null;
    }

    public static byte[] compileProxyFor(Class clazz, String proxyClassName) {
        return ProxyCompiler.compileProxyFor(clazz.getClassLoader(), clazz.getName(), proxyClassName);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] compileProxyFor(ClassLoader loader, String className, String proxyClassName) {
        void var6_6;
        String targetClassName = className.replace('.', '/');
        ClassWriter proxyWriter = AsmHelper.newClassWriter(true);
        InputStream in = null;
        try {
            in = loader != null ? loader.getResourceAsStream(targetClassName + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(targetClassName + ".class");
            ClassReader classReader = new ClassReader(in);
        }
        catch (IOException e) {
            throw new WrappedRuntimeException("Cannot compile proxy for " + className, e);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
        }
        ProxyCompilerClassVisitor createProxy = new ProxyCompilerClassVisitor(proxyWriter, proxyClassName.replace('.', '/'));
        var6_6.accept(createProxy, Attributes.getDefaultAttributes(), true);
        return proxyWriter.toByteArray();
    }

    private static class ProxyCompilerClassVisitor
    extends AsmAnnotationHelper.NullClassAdapter {
        private final ClassVisitor m_proxyCv;
        private final String m_proxyClassName;
        private String m_className;

        public ProxyCompilerClassVisitor(ClassVisitor proxyCv, String proxyClassName) {
            this.m_proxyCv = proxyCv;
            this.m_proxyClassName = proxyClassName;
        }

        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            if (Modifier.isFinal(access)) {
                throw new RuntimeException("Cannot create a proxy from final class " + name);
            }
            this.m_className = name;
            this.m_proxyCv.visit(version, 4129, this.m_proxyClassName.replace('.', '/'), name, interfaces, null);
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            if (!(Modifier.isFinal(access) || Modifier.isPrivate(access) || Modifier.isNative(access) || "<clinit>".equals(name))) {
                if ("<init>".equals(name)) {
                    CodeVisitor proxyCode = this.m_proxyCv.visitMethod(access + 4096, "<init>", desc, exceptions, attrs);
                    proxyCode.visitVarInsn(25, 0);
                    AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), false);
                    proxyCode.visitMethodInsn(183, this.m_className, "<init>", desc);
                    proxyCode.visitInsn(177);
                    proxyCode.visitMaxs(0, 0);
                } else {
                    CodeVisitor proxyCode = this.m_proxyCv.visitMethod(access + 4096, name, desc, exceptions, attrs);
                    if (Modifier.isStatic(access)) {
                        AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), true);
                        proxyCode.visitMethodInsn(184, this.m_className, name, desc);
                        AsmHelper.addReturnStatement(proxyCode, Type.getReturnType(desc));
                        proxyCode.visitMaxs(0, 0);
                    } else {
                        proxyCode.visitVarInsn(25, 0);
                        AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), false);
                        proxyCode.visitMethodInsn(183, this.m_className, name, desc);
                        AsmHelper.addReturnStatement(proxyCode, Type.getReturnType(desc));
                        proxyCode.visitMaxs(0, 0);
                    }
                }
            }
            return AsmAnnotationHelper.NullCodeAdapter.NULL_CODE_ADAPTER;
        }
    }
}

