/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.proxy;

import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.definition.DefinitionParserHelper;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper;
import org.codehaus.aspectwerkz.intercept.AdvisableImpl;
import org.codehaus.aspectwerkz.proxy.ProxyCompiler;
import org.codehaus.aspectwerkz.proxy.Uuid;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;

public class Proxy {
    public static final String PROXY_SUFFIX_START = "$$ProxiedByAW$$";
    private static final Map PROXY_CLASS_CACHE = new WeakHashMap();

    public static Object newInstance(Class clazz) {
        try {
            Class proxyClass = Proxy.getProxyClassFor(clazz, true, false);
            return proxyClass.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    public static Object newInstance(Class clazz, Class[] argumentTypes, Object[] argumentValues) {
        try {
            Class proxyClass = Proxy.getProxyClassFor(clazz, true, false);
            return proxyClass.getDeclaredConstructor(argumentTypes).newInstance(argumentValues);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    public static Object newInstance(Class clazz, boolean useCache, boolean makeAdvisable) {
        try {
            Class proxyClass = Proxy.getProxyClassFor(clazz, useCache, makeAdvisable);
            return proxyClass.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    public static Object newInstance(Class clazz, Class[] argumentTypes, Object[] argumentValues, boolean useCache, boolean makeAdvisable) {
        try {
            Class proxyClass = Proxy.getProxyClassFor(clazz, useCache, makeAdvisable);
            return proxyClass.getDeclaredConstructor(argumentTypes).newInstance(argumentValues);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClassFor(Class clazz, boolean useCache, boolean makeAdvisable) {
        if (clazz.getName().startsWith("java.")) {
            throw new RuntimeException("can not create proxies from system classes (java.*)");
        }
        if (!useCache) {
            return Proxy.getNewProxyClassFor(clazz, makeAdvisable);
        }
        Map map = PROXY_CLASS_CACHE;
        synchronized (map) {
            Object cachedProxyClass = PROXY_CLASS_CACHE.get(clazz);
            if (cachedProxyClass != null) {
                return (Class)cachedProxyClass;
            }
            Class proxyClass = Proxy.getNewProxyClassFor(clazz, makeAdvisable);
            PROXY_CLASS_CACHE.put(clazz, proxyClass);
            return proxyClass;
        }
    }

    private static Class getNewProxyClassFor(Class clazz, boolean makeAdvisable) {
        ClassLoader loader = clazz.getClassLoader();
        String proxyClassName = Proxy.getUniqueClassNameForProxy(clazz);
        if (makeAdvisable) {
            Proxy.makeProxyAdvisable(clazz);
        }
        byte[] bytes = ProxyCompiler.compileProxyFor(clazz, proxyClassName);
        byte[] transformedBytes = ClassPreProcessorHelper.defineClass0Pre((ClassLoader)loader, (String)proxyClassName, (byte[])bytes, (int)0, (int)bytes.length, null);
        return AsmHelper.defineClass(loader, transformedBytes, proxyClassName);
    }

    private static String getUniqueClassNameForProxy(Class clazz) {
        return clazz.getName().replace('.', '/') + PROXY_SUFFIX_START + new Long(Uuid.newUuid()).toString();
    }

    public static String getUniqueClassNameFromProxy(String proxyClassName) {
        int index = proxyClassName.lastIndexOf(PROXY_SUFFIX_START);
        if (index > 0) {
            return proxyClassName.substring(0, index);
        }
        return null;
    }

    private static void makeProxyAdvisable(Class clazz) {
        SystemDefinition definition = SystemDefinitionContainer.getVirtualDefinitionAt(clazz.getClassLoader());
        Proxy.addAdvisableDefToSystemDef(clazz, definition);
    }

    private static void addAdvisableDefToSystemDef(Class clazz, SystemDefinition definition) {
        String withinPointcut = "within(" + clazz.getName().replace('/', '.') + ')';
        definition.addMixinDefinition(DefinitionParserHelper.createAndAddMixinDefToSystemDef(AdvisableImpl.CLASS_INFO, withinPointcut, DeploymentModel.PER_INSTANCE, false, definition));
        DefinitionParserHelper.createAndAddAdvisableDef("(execution(!static * *.*(..)) && " + withinPointcut + ')', definition);
    }
}

