/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.aspectwerkz.exception.DefinitionException;

public class QDoxParser {
    private JavaDocBuilder m_builder = new JavaDocBuilder();
    private JavaClass m_class;
    private String m_className;

    public static String[] getJavaMethodParametersAsStringArray(JavaMethod method) {
        JavaParameter[] javaParameters = method.getParameters();
        String[] parameters = new String[javaParameters.length];
        for (int i = 0; i < javaParameters.length; ++i) {
            Type type = javaParameters[i].getType();
            int dimensions = type.getDimensions();
            StringBuffer parameter = new StringBuffer(type.getValue());
            for (int j = 0; j < dimensions; ++j) {
                parameter.append("[]");
            }
            parameters[i] = parameter.toString();
        }
        return parameters;
    }

    public QDoxParser(String srcDir) {
        this.m_builder.addSourceTree(new File(srcDir));
    }

    public boolean parse(String className) {
        this.m_class = this.m_builder.getClassByName(className);
        if (this.m_class == null) {
            return false;
        }
        this.m_className = this.m_class.getFullyQualifiedName();
        return true;
    }

    public JavaClass getJavaClass() {
        if (this.m_class == null && this.m_className == null) {
            throw new DefinitionException("no class has been parsed, call parse(..) first");
        }
        if (this.m_class == null) {
            throw new DefinitionException("could not find source file for " + this.m_className + " (have you specified the correct srcDir)");
        }
        return this.m_class;
    }

    public String[] getAllClassNames() {
        Collection classes = this.m_builder.getClassLibrary().all();
        ArrayList<String> classNames = new ArrayList<String>();
        String className = null;
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            className = (String)it.next();
            if ("java.lang.Object".equals(className)) continue;
            classNames.add(className);
        }
        return classNames.toArray(new String[0]);
    }

    public JavaMethod[] getJavaMethods() {
        if (this.m_class == null && this.m_className == null) {
            throw new DefinitionException("no class has been parsed, call parse(..) first");
        }
        if (this.m_class == null) {
            throw new DefinitionException("could not find source file for " + this.m_className + " (have you specified the correct srcDir)");
        }
        return this.m_class.getMethods();
    }

    public JavaField[] getJavaFields() {
        if (this.m_class == null && this.m_className == null) {
            throw new DefinitionException("no class has been parsed, call parse(..) first");
        }
        if (this.m_class == null) {
            throw new DefinitionException("could not find source file for " + this.m_className + " (have you specified the correct srcDir)");
        }
        return this.m_class.getFields();
    }
}

