/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.regexp;

import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.IDContextProvider;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.util.DatatypeRef;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.msv.verifier.regexp.ResidualCalculator;
import com.sun.msv.verifier.regexp.Token;
import java.util.StringTokenizer;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

public class StringToken
extends Token {
    public final String literal;
    public final IDContextProvider context;
    protected final ResidualCalculator resCalc;
    protected final boolean ignorable;
    public DatatypeRef refType;
    protected boolean saturated = false;
    private static final Datatype[] ignoredType = new Datatype[0];

    public StringToken(REDocumentDeclaration rEDocumentDeclaration, String string, IDContextProvider iDContextProvider) {
        this(rEDocumentDeclaration.resCalc, string, iDContextProvider, null);
    }

    public StringToken(REDocumentDeclaration rEDocumentDeclaration, String string, IDContextProvider iDContextProvider, DatatypeRef datatypeRef) {
        this(rEDocumentDeclaration.resCalc, string, iDContextProvider, datatypeRef);
    }

    public StringToken(ResidualCalculator residualCalculator, String string, IDContextProvider iDContextProvider, DatatypeRef datatypeRef) {
        this.resCalc = residualCalculator;
        this.literal = string;
        this.context = iDContextProvider;
        this.refType = datatypeRef;
        boolean bl = this.ignorable = string.trim().length() == 0;
        if (this.ignorable && datatypeRef != null) {
            datatypeRef.types = ignoredType;
        }
    }

    public boolean match(DataExp dataExp) {
        if (!dataExp.dt.isValid(this.literal, (ValidationContext)this.context)) {
            return false;
        }
        if (dataExp.except != Expression.nullSet && this.resCalc.calcResidual(dataExp.except, this) == Expression.epsilon) {
            return false;
        }
        if (this.refType != null) {
            this.assignType(dataExp.dt);
        }
        if (dataExp.dt.getIdType() != 0 && this.context != null) {
            this.context.onID(dataExp.dt, this.literal);
        }
        return true;
    }

    public boolean match(ValueExp valueExp) {
        Object object = valueExp.dt.createValue(this.literal, (ValidationContext)this.context);
        if (!valueExp.dt.sameValue(object, valueExp.value)) {
            return false;
        }
        if (this.refType != null) {
            this.assignType(valueExp.dt);
        }
        if (valueExp.dt.getIdType() != 0 && this.context != null) {
            this.context.onID(valueExp.dt, this.literal);
        }
        return true;
    }

    public boolean match(ListExp listExp) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.literal);
        Expression expression = listExp.exp;
        DatatypeRef datatypeRef = null;
        Datatype[] datatypeArray = null;
        int n = 0;
        if (this.refType != null) {
            datatypeRef = new DatatypeRef();
            datatypeArray = new Datatype[stringTokenizer.countTokens()];
        }
        while (stringTokenizer.hasMoreTokens()) {
            StringToken stringToken = this.createChildStringToken(stringTokenizer.nextToken(), datatypeRef);
            if ((expression = this.resCalc.calcResidual(expression, stringToken)) == Expression.nullSet) {
                return false;
            }
            if (datatypeRef == null) continue;
            if (datatypeRef.types == null) {
                this.saturated = true;
                this.refType.types = null;
                datatypeRef = null;
                continue;
            }
            if (datatypeRef.types.length != 1) {
                throw new Error();
            }
            datatypeArray[n++] = datatypeRef.types[0];
        }
        if (!expression.isEpsilonReducible()) {
            return false;
        }
        if (datatypeArray != null) {
            this.refType.types = this.saturated ? null : datatypeArray;
            this.saturated = true;
        }
        return true;
    }

    protected StringToken createChildStringToken(String string, DatatypeRef datatypeRef) {
        return new StringToken(this.resCalc, string, this.context, datatypeRef);
    }

    public boolean matchAnyString() {
        if (this.refType != null) {
            this.assignType((Datatype)StringType.theInstance);
        }
        return true;
    }

    private void assignType(Datatype datatype) {
        if (this.saturated) {
            if (this.refType.types != null && (this.refType.types[0] != datatype || this.refType.types.length != 1)) {
                this.refType.types = null;
            }
        } else {
            this.refType.types = new Datatype[]{datatype};
            this.saturated = true;
        }
    }

    boolean isIgnorable() {
        return this.ignorable;
    }
}

