/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.trex.ng.comp;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.relaxng.RELAXNGGrammar;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.State;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.trex.ng.comp.CompAttributeState;
import com.sun.msv.reader.trex.ng.comp.DefAttCompatibilityChecker;
import com.sun.msv.reader.trex.ng.comp.IDCompatibilityChecker;
import com.sun.msv.util.LightStack;
import com.sun.msv.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RELAXNGCompReader
extends RELAXNGReader {
    private final Map defaultedAttributes = new HashMap();
    public static final String AnnotationNamespace = "http://relaxng.org/ns/compatibility/annotations/1.0";
    private final LightStack lastRNGElement = new LightStack();
    private boolean inAnnotation = false;
    public static final String CERR_ANN_CHILD_ELEMENT = "RELAXNGReader.Compatibility.Annotation.ChildElement";
    public static final String CERR_ANN_MISPLACED = "RELAXNGReader.Compatibility.Annotation.Misplaced";
    public static final String CERR_ANN_INVALID_ATTRIBUTE = "RELAXNGReader.Compatibility.Annotation.InvalidAttribute";

    public static TREXGrammar parse(String string, GrammarReaderController grammarReaderController) {
        RELAXNGCompReader rELAXNGCompReader = new RELAXNGCompReader(grammarReaderController);
        rELAXNGCompReader.parse(string);
        return rELAXNGCompReader.getResult();
    }

    public static TREXGrammar parse(InputSource inputSource, GrammarReaderController grammarReaderController) {
        RELAXNGCompReader rELAXNGCompReader = new RELAXNGCompReader(grammarReaderController);
        rELAXNGCompReader.parse(inputSource);
        return rELAXNGCompReader.getResult();
    }

    public RELAXNGCompReader(GrammarReaderController grammarReaderController) {
        this(grammarReaderController, GrammarReader.createParserFactory(), new ExpressionPool());
    }

    public RELAXNGCompReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, ExpressionPool expressionPool) {
        this(grammarReaderController, sAXParserFactory, new StateFactory(), expressionPool);
    }

    public RELAXNGCompReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, StateFactory stateFactory, ExpressionPool expressionPool) {
        super(grammarReaderController, sAXParserFactory, stateFactory, expressionPool);
        this.lastRNGElement.push(null);
    }

    protected final void addDefaultValue(AttributeExp attributeExp, String string) {
        this.setDeclaredLocationOf(attributeExp);
        if (this.defaultedAttributes.put(attributeExp, string) != null) {
            throw new Error();
        }
    }

    protected TREXGrammar getGrammar() {
        return this.grammar;
    }

    protected String localizeMessage(String string, Object[] objectArray) {
        String string2;
        try {
            string2 = ResourceBundle.getBundle("com.sun.msv.reader.trex.ng.comp.Messages").getString(string);
        }
        catch (Exception exception) {
            return super.localizeMessage(string, objectArray);
        }
        return MessageFormat.format(string2, objectArray);
    }

    public void wrapUp() {
        super.wrapUp();
        if (!this.controller.hadError()) {
            new DefAttCompatibilityChecker(this, this.defaultedAttributes).test();
            new IDCompatibilityChecker(this).test();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (this.inAnnotation) {
            this.reportWarning(CERR_ANN_CHILD_ELEMENT, null, new Locator[]{this.locator});
            ((RELAXNGGrammar)this.grammar).isAnnotationCompatible = false;
        }
        if (string.equals(AnnotationNamespace) && string2.equals("annotation")) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string4 = attributes.getURI(n);
                if (string4.equals("") || string4.equals(AnnotationNamespace) || string4.equals("http://relaxng.org/ns/structure/1.0")) {
                    this.reportWarning(CERR_ANN_INVALID_ATTRIBUTE, new Object[]{attributes.getQName(n)}, new Locator[]{this.locator});
                    ((RELAXNGGrammar)this.grammar).isAnnotationCompatible = false;
                    break;
                }
                ++n;
            }
            if (!(this.lastRNGElement.size() == 0 || this.lastRNGElement.top() == null || "value".equals(this.lastRNGElement.top()) || "param".equals(this.lastRNGElement.top()) || "name".equals(this.lastRNGElement.top()))) {
                this.reportWarning(CERR_ANN_MISPLACED, new Object[]{this.lastRNGElement.top()}, new Locator[]{this.locator});
                ((RELAXNGGrammar)this.grammar).isAnnotationCompatible = false;
            }
            this.inAnnotation = true;
        }
        this.lastRNGElement.push(null);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        this.inAnnotation = false;
        this.lastRNGElement.pop();
        if (string.equals("http://relaxng.org/ns/structure/1.0")) {
            this.lastRNGElement.pop();
            this.lastRNGElement.push(string2);
        }
    }

    public static class StateFactory
    extends RELAXNGReader.StateFactory {
        public State attribute(State state, StartTagInfo startTagInfo) {
            return new CompAttributeState();
        }

        public TREXGrammar createGrammar(ExpressionPool expressionPool, TREXGrammar tREXGrammar) {
            return new RELAXNGGrammar(expressionPool, tREXGrammar);
        }
    }
}

