package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public abstract class VradiEditor<O, M extends VradiEditorModel<O>> extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_NAME_LABEL_TEXT = "fieldNameLabel.text";
    public static final String BINDING_FIELD_NAME_LABEL_TOOL_TIP_TEXT = "fieldNameLabel.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Sy24TMRS9mTYJaUh5VJSiFmiBLQ77IigKRFCFh0iEKrLBid3GkWdsbE87sEB8Ap8AezZI7FghFqxZsEH8AkIs2CJsJ5k0MKiVShYzk+t7js8997z+BnmtYKWPkwSpODIspGj92sbG3U6fds11qruKSSMUDH65AII2lEla1wbOtxsOXh3CqzURShHRaBd6tQEz2jzhVPcoNQZOTyK6Wleb6fFqImM1Yk1FZbG+/PE9eEGevwoAEmnVTdlRlvdCjSeZbkDAiIHj9qZtXOU42rIyFIu2rN6Kq9U41voODuljeAbFBhQkVpbMwLn9j+w5PD6RBooXWrjD6SUDF7siRP1YMR1i1e1RjbYVJgzFDFHCnLXogSvc8H+k9BwFA7ObjHLiRDVwh3Ir3ylNkN6xwtG6L7rWUoqoDPhqIjJe/CTgHo5SgILFCfvsYtB4MWPncm3Iq9iWDSy0/97lfXs02OLCH1t0hP701/zc53df39ZHq3MpPJHZuit51lKphKTKMHf1kcHeYsN49TaWq20oacptbH0slzKENYfHVpy975iDIwdHN7HuWYp88cv7D/OPPk1BUIcZLjCpY9d/C0qmp6wLgpNEXl3zig7vHLLPo06bgXKIExbGYZM9tUbNXibY4OUOi4j1+EpinVjKcCKV0yl9/DnXfLM2ciNn1Z36Z/vYkfxDKLCIs4j6KA9TmhndstQ0JmKcxqx85ty7IodhO+mfi9njsmg0rms6k8TuddZrd18r+6aqSEU3qVKU/AeyaUMTc0COshGCt5hs7U31G54RPkc/BQAA";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.editors.VradiEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel editorContent;
    protected javax.swing.JLabel fieldNameLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VradiEditor $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * Initialize the editor, must be call before any use of it.
     */
    public void init() {
        // model is null, when coming here from parent
        applyDataBinding("fieldNameLabel.text");
    }
    
    //public abstract M getModel();
    public abstract VradiEditorModel<O> getModel();
    
    public String getFieldName() { 
        return getModel().getFieldName();
    }
    
    public void setFieldName(String newValue) {
        getModel().setFieldName(newValue);
    }
    
    public String getFieldDescription() {
        return getModel().getFieldDescription();
    }
    
    public void setFieldDescription(String newValue) {
        getModel().setFieldDescription(newValue);
    }
    
    public String getExtensionName() {
        return getModel().getExtensionName();
    }
    
    public void setExtensionName(String newValue) {
        getModel().setExtensionName(newValue);
    }
    
    public O getValue() {
        return getModel().getValue();
    }
    
    public void setValue(O newValue) {
        getModel().setValue(newValue);
    }
    
    public String getValidatorContext() {
        return getModel().getValidatorContext();
    }
    
    public void setValidatorContext(String newValue) {
        getModel().setValidatorContext(newValue);
        registerValidator();
    }
    
    abstract void registerValidator();

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiEditor() {
        $initialize();
    }

    public VradiEditor(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getEditorContent() {
        return editorContent;
    }

    public javax.swing.JLabel getFieldNameLabel() {
        return fieldNameLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEditorContent() {
        $objectMap.put("editorContent", editorContent = new javax.swing.JPanel());
        editorContent.setName("editorContent");
    }

    protected void createFieldNameLabel() {
        $objectMap.put("fieldNameLabel", fieldNameLabel = new javax.swing.JLabel());
        fieldNameLabel.setName("fieldNameLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add(fieldNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add(editorContent, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 2 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        fieldNameLabel.setMaximumSize(new Dimension(100,10));
        fieldNameLabel.setMinimumSize(new Dimension(100,10));
        fieldNameLabel.setPreferredSize(new Dimension(100,10));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$Table0", this);
        createFieldNameLabel();
        createEditorContent();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_NAME_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    fieldNameLabel.setText(_(getModel().getFieldName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_NAME_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldDescription", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    fieldNameLabel.setToolTipText(_(getModel().getFieldDescription()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldDescription", this);
                }
            }
        });
    }

}