package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.admin.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusPathChooserUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SAVED = "saved";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECT_ENABLED = "select.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton cancel;
    protected java.lang.Boolean saved;
    protected javax.swing.JButton select;
    protected java.lang.Boolean selected;
    protected javax.swing.JTree thesaurus;
    protected ThesaurusPathChooserUI thesaurusPathChooserUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeHelper helper;
    
    
    public  ThesaurusPathChooserUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeHelper helper) {
        jaxx.runtime.Util.initContext(this, parentContext);
        this.helper = helper;
        setContextValue(helper);
    $initialize();
    }
    
    public void setHelper(ThesaurusTreeHelper helper){
        this.helper = helper;
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // Clear if no selection
                if (path == null){
                    tree.clearSelection();
                    getHelper().setSelectedNode(ThesaurusPathChooserUI.this, null);
                    setSelected(false);
                } else {
                    setSelected(true);
                }
            }
        });
    }
        
    protected void close(){
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusPathChooserUI() {
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__select(java.awt.event.ActionEvent event) {
        setSaved(true);close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public java.lang.Boolean getSaved() {
        return saved;
    }

    public javax.swing.JButton getSelect() {
        return select;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean isSaved() {
        return saved !=null && saved;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSaved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.saved;
        this.saved = newValue;
        firePropertyChange(PROPERTY_SAVED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusPathChooserUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createSaved() {
        $objectMap.put("saved", saved = false);
    }

    protected void createSelect() {
        $objectMap.put("select", select = new javax.swing.JButton());
        select.setName("select");
        select.setText(_("vradi.common.select"));
        select.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__select"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        thesaurus.setName("thesaurus");
        thesaurus.setExpandsSelectedPaths(true);
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusPathChooserUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(select, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 1 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        thesaurus.setModel(helper.createTreeModel(this));
        thesaurus.setSelectionModel(helper.createTreeHandler(this));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        select.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("select"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("thesaurusPathChooserUI", this);
        createSelected();
        createSaved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminThesaurus.selectAsk"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        createCancel();
        createSelect();
        // inline creation of thesaurusPathChooserUI
        setName("thesaurusPathChooserUI");
        SwingUtil.setComponentHeight(thesaurusPathChooserUI,600);
        thesaurusPathChooserUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminThesaurus.select"));
        SwingUtil.setComponentWidth(thesaurusPathChooserUI,800);
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                select.setEnabled(isSelected());
            }
        });
    }

}