package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.NavigationContentUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public abstract class AdminContentUI<B> extends javax.swing.JPanel implements jaxx.runtime.swing.navigation.NavigationContentUI, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLOCK_LAYER_UI_BLOCK = "blockLayerUI.block";
    public static final String BINDING_COMMON_ACTIONS_VISIBLE = "commonActions.visible";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVtrS8kOFSCBAUsSLB7cYjxAEaoglRYmIMfbi7O5IB2dn1pnZsr0Y/wT/BL17MfHmyXjw7MGL8V8wxoNX45vttkt1wQZ6mN28ed/3vvf6vX3zHeWURAsHOAwtGXBNPWJtrT98eNc+II6+RZQjqa+FRJ1fJouyDTTi9uJKo8VG3cArMbxSFZ4vOOFH0Mt1VFK6zYhqEqI1mu9HOEpVdnvXy6EfyC5rT1Qa66ufP7Iv3RevswiFPqgrQSvl/6GSTobqKEtdjSagUgtXGOb7IENSvg96x0ysyrBSd7BHnqHnqFBHeR9LINPo8uAtRxwRPvQ1Gr6ytYM5YUsaWY7wrINAUuVh6TSJsloSu9QKqIVdj3Jr3ZxVwTUQ79V8P2LJA4cnXPqEEpB+0ai0jHJrQwhGME/S8i3MqBtJH0+iozYTztM6bhO5V4NG+salDqlhMhnwEicl2BKRUsj72GZEo5U+ZFQLQ98xx645H3SD20QpvE8i5LZwCUs4Cxp021jC32B6CWN8Z0omp9hLHbKF2zbvM/3xMRikJ/i6o6ngYMjplJ6i0v2wvIO5Q5hGk32FNwKtBTc5c0llhVsReiGOSzTbVwQcbCUOTiyWaaCcDCAMqhr/mv4eXHXsPv2X3Q1hdPt7avLL+2/vNrseH4Hal1JTj6woeM+XwidSU1P6fMfggaasso395QYqKsJgv6P9nUsRthtfgzio13GZgVu3sWoCRa7w9cPHqcefz6HsJioxgd1NbPJrqKibEqYgmBv6N9ciRaOHw3BeMNpg6gy3BYwYja+ANXDZptyFua+GMIS5lCH0lNjFT78md9+udQeRAWEzx6Ynw8g9QnnKGeUkWvd4k1PXe8RXJHBFsrFpO5wxz5IfO/hqdF5L6zQXbZq5XgoD87geqTZvNyKSiQFIxux4GauCCXlGskKgSM2BDwqaWOmMpIw1fPDsQJPV09KacOUEYbODCGtRReMFPYZmfgCaIep0NvcYjvIgHJqE2txunJbDhHdOULE4yEAINx8s90w0Jrx3QiuG4Q88NRI4AQgAAA==";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.BlockingLayerUI blockLayerUI;
    protected javax.swing.JPanel body;
    protected javax.swing.JButton cancel;
    protected jaxx.runtime.swing.Table commonActions;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorTable;
    protected java.lang.Boolean modified;
    protected javax.swing.JButton save;
    protected javax.swing.JPanel toolbar;
    protected java.lang.Boolean valide;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminContentUI $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    /**
     * @return the editing bean of the content
     */
    public abstract B getBean();
    
    /**
     * Transfert incmoing {@code bean} into the editing bean.
     *
     * @param bean the incoming bean
     */
    protected abstract void updateBeanFromEntity(B bean);
    
    /**
     * Save the editing bean
     */
    public abstract void save();
    
    /**
     * Save the editing bean and unmodify the form
     */
    public void postSave(){
        save();
        setModified(false);
    }
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        log.info("selected path " + getHelper().getSelectedPath(this));
        B bean = getSelectedEntity();
        log.info("selected bean " + bean);
        updateBeanFromEntity(bean);
        setEnabled(bean != null);
        // always reset to false since updateBean will update modified property
        setModified(false);
    }
    
    /**
     * @return the incoming bean to transfert to editing bean from selected bean
     */
    public B getSelectedEntity() {
        // obtain entity
        Object bean = getHelper().getSelectedBean(this);
        if (bean  instanceof java.util.List<?> || bean  == null) {
            bean  = null;
        }
        return (B) bean;
    }
    
    @Override
    public void closeUI(NavigationTreeNode node) throws Exception {
    }
    
    protected VradiNavigationTreeHelper getHelper() {
        return getContextValue(VradiNavigationTreeHelper.class);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected Icon updateCollapseIcon(boolean c) {
        String key = c ? "collapseIcon" : "expandIcon";
        Icon i = (Icon) getClientProperty(key);
        return i;
    }
    
    protected void addBeanModifiedPCS(VradiDTO bean) {
        bean.addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (isEnabled()) {
                    setModified(true);
                }
            }
        });
    }
    
    protected void addBeanPCSLogger(VradiDTO bean) {
        bean.addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("bean." + evt.getPropertyName() + " <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
            }
        });
    }
    
    protected void addPCSLogger() {
        addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("ui." + evt.getPropertyName() + " <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
            }
        });
    }
    
    void $afterCompleteSetup() {    
        setContextValue(errorTable, "errorTable");
        SwingUtil.getLayer(body).setUI(blockLayerUI);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminContentUI() {
        $initialize();
    }

    public AdminContentUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        getHandler().cancel(this, getHelper());
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        postSave();
    }

    public void doTableChanged__on__errorTable(javax.swing.event.TableModelEvent event) {
        setValide(errorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.BlockingLayerUI getBlockLayerUI() {
        return blockLayerUI;
    }

    public javax.swing.JPanel getBody() {
        return body;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public jaxx.runtime.swing.Table getCommonActions() {
        return commonActions;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorTable() {
        return errorTable;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public javax.swing.JPanel getToolbar() {
        return toolbar;
    }

    public java.lang.Boolean getValide() {
        return valide;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    public java.lang.Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    public void setValide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.valide;
        this.valide = newValue;
        firePropertyChange(PROPERTY_VALIDE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommonActions() {
        if (!allComponentsCreated) {
            return;
        }
        commonActions.add(cancel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(save, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBlockLayerUI() {
        $objectMap.put("blockLayerUI", blockLayerUI = new jaxx.runtime.swing.BlockingLayerUI());
        blockLayerUI.setUseIcon(false);
    }

    protected void createBody() {
        $objectMap.put("body", body = new javax.swing.JPanel());
        body.setName("body");
        body.setLayout(new BorderLayout());
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCommonActions() {
        $objectMap.put("commonActions", commonActions = new jaxx.runtime.swing.Table());
        commonActions.setName("commonActions");
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        errorTable.addTableModelListener(Util.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorTable"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new javax.swing.JPanel());
        toolbar.setName("toolbar");
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.NORTH);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(commonActions, BorderLayout.SOUTH);
        addChildrenToCommonActions();
        
        // apply 3 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        blockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createModified();
        createValide();
        createBlockLayerUI();
        createErrorTable();
        createToolbar();
        createBody();
        createCommonActions();
        createCancel();
        createSave();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.putClientProperty("expandIcon", SwingUtil.createActionIcon("expand"));
        $JPanel0.putClientProperty("collapseIcon", SwingUtil.createActionIcon("collapse"));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLOCK_LAYER_UI_BLOCK, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                blockLayerUI.setBlock(!isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMMON_ACTIONS_VISIBLE, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                commonActions.setVisible(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_ENABLED, true ,"modified" ,"valide") {
        
            @Override
            public void processDataBinding() {
                save.setEnabled(isModified() && isValide());
            }
        });
    }

}