/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

import javax.swing.*;
import javax.swing.table.TableRowSorter;
import javax.swing.text.MaskFormatter;
import java.awt.*;
import java.awt.event.*;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

/**
 * @author letellier
 */
public class OfferListHandler {

    static private final Log log = LogFactory.getLog(OfferListHandler.class);

    static final public int TABPANEL_LABEL_MAX_CHAR_NB = 30;

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param rootHandler
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public OfferListUI initUI(JAXXContext rootContext, VradiMainUIHandler rootHandler) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext).add(this);

        SearchHandler searchHandler = UIHelper.getHandler(context, SearchHandler.class);

        // show main ui
        OfferListTableModel offerListTableModel = getOfferListTableModel();
        context.add(offerListTableModel);

        OfferListUI ui = new OfferListUI(context);

        // Show search ui
        SearchUI searchUI = searchHandler.initUI(rootContext, offerListTableModel);

        searchUI.setOfferListUI(true);

        ui.getSearchPanel().add(searchUI, BorderLayout.CENTER);

        // Saved in context
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(rootContext, ui);

        return ui;
    }

    public OfferListTableModel getOfferListTableModel() {
        OfferListTableModel model = null;

        Calendar now = new GregorianCalendar();
        now.set(Calendar.HOUR, 0);
        now.set(Calendar.MINUTE, 0);
        now.set(Calendar.MILLISECOND, 0);
        try {
            VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
            ServiceHelper.getVradiStorageService().findForms(null, null, Form.FQ_FIELD_DATEPUB,
                    now.getTime(), now.getTime(), null, formPageDTO);
            model = new OfferListTableModel(formPageDTO);
        } catch (TechnicalException eee) {
            log.error("Cant find forms for this day ", eee);
            ErrorDialogUI.showError(eee);
            model = new OfferListTableModel(new VradiFormPageDTO());
        }
        return model;
    }

    public void addEditPane(JAXXContext context, final Form data) {
        final OfferListUI ui = getUI(context);

        // Fill free space
        ui.setDividerLocation(0);
        ui.setResizeWeight(0);
        ui.setDividerSize(10);

        // Get tab
        JTabbedPane contentTabbedPane = ui.getEditTabs();

        // Tab id
        String id = data.getWikittyId();

        // Exist ?
        if (contentTabbedPane.indexOfTab(id) < 0) {

            // Open new
            final OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
            final OfferEditUI editUi = handler.initUI(context, data);
            contentTabbedPane.add(id, editUi);

            final VradiTabHeader panel = new VradiTabHeader();
            if (data.getName() != null) {
                String panelLabel = data.getName().length() < TABPANEL_LABEL_MAX_CHAR_NB ?
                        data.getName() : data.getName().substring(0, TABPANEL_LABEL_MAX_CHAR_NB) + "...";
                panel.getLabel().setText(panelLabel);
            }
            panel.setId(id);

            // Table closeable
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(id), panel);
            panel.getCloseTab().addMouseListener(new javax.swing.event.MouseInputAdapter() {

                @Override
                public void mouseClicked(MouseEvent e) {
                    closePane(editUi, panel.getId());
                }
            });

            // Detachable
            panel.getDetachTab().addMouseListener(new javax.swing.event.MouseInputAdapter() {

                @Override
                public void mouseClicked(MouseEvent e) {
                    detachPane(e);
                }
            });

            // Cancel
            editUi.getAnnuler().addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent e) {
                    closePane(editUi, panel.getId());
                }
            });

            // Update
            editUi.getValidate().addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    handler.save(editUi, data);
                    closePane(editUi, panel.getId());

                    SearchHandler handler = UIHelper.getHandler(editUi, SearchHandler.class);
                    handler.executeQuery(ui);
                }
            });
        }

        // Select
        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(id));
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton) e.getSource();
        return (VradiTabHeader) button.getParent();
    }

    protected void closePane(JAXXContext context, String id) {
        OfferListUI ui = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        JTabbedPane contentTabbedPane = getContentPane(ui);
        int index = contentTabbedPane.indexOfTab(id);
        if (index > -1) {
            contentTabbedPane.remove(index);
        }
        allEditPanelRemoved(contentTabbedPane, ui);
    }

    private void removeEditPaneFromRef(OfferEditUI ui) {
        VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get()).remove(ui);
    }

    // Detach editUI
    protected void detachPane(MouseEvent e) {
        // Get panel
        VradiTabHeader mytab = getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();

        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = getContentPane(ui);
        final OfferEditUI content = getOfferEdit(contentTabbedPane, id);

        // Create popup
        final JFrame frame = new JFrame(name);

        // Close
        content.getValidate().addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                closeDetachedPane(frame, content);
            }
        });

        // Cancel
        content.getAnnuler().addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                closeDetachedPane(frame, content);
            }
        });

        // Remove default listener
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

        // Add listener
        frame.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosed(WindowEvent e) {
                closeDetachedPane(frame, content);
            }
        });

        frame.setLayout(new BorderLayout());
        frame.add(content, BorderLayout.CENTER);
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 800));

        // Remove
        allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected OfferEditUI getOfferEdit(JTabbedPane contentTabbedPane, String id) {
        return (OfferEditUI) contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
    }

    protected void closeDetachedPane(JFrame f, OfferEditUI ui) {
        f.dispose();
        removeEditPaneFromRef(ui);
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            addEditPane(context, data);
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1);
            ui.setDividerSize(0);
        }
    }

    OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI) context;
        }
        OfferListUI ui = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = getUI(context);
        return ui.getEditTabs();
    }

    JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context) {
        JTable listTable = getUI(context).listTable;
        OfferListTableModel tableModel = getUI(context).offerListTableModel;
        int selectedRow = listTable.getSelectedRow();
        //selectedRow = listTable.convertRowIndexToModel(selectedRow);
        edit(context, selectedRow, tableModel);
    }

    protected void edit(JAXXContext context, int i, OfferListTableModel model) {
        Form data = null;
        data = model.getDatas().getFormsToShow().get(i);
        log.debug("Form selected : " + data);
        if (data != null) {
            addEditPane(context, data);
        }
    }

    public static RowFilter<OfferListTableModel, Integer> makeRowFilter(final int itemsPerPage, final int target) {
        return new RowFilter<OfferListTableModel, Integer>() {
            @Override
            public boolean include(Entry<? extends OfferListTableModel, ? extends Integer> entry) {
                int ei = entry.getIdentifier();
                return (target * itemsPerPage <= ei && ei < target * itemsPerPage + itemsPerPage);
            }
        };
    }


    public void removeColumn(JAXXContext context, TreeNode thesaurus) {

        // Save in properties
        VradiHelper.removeVradiListColumns(thesaurus);

        // Refresh model
        getUI(context).updateTableModel();
    }

}
