/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.editors.*;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.List;

/**
 * @author letellier
 */
public class OfferEditHandler {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(OfferEditHandler.class);
    private static final String DEFAULT_EDITOR_NAME = "$default";
    public static final String REQUIRED_FIELD_CONTEXT = "required";

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param data
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public OfferEditUI initUI(JAXXContext rootContext, Form data) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext).add(this);

        // show main ui
        context.add(data);
        UIHelper.getHandler(context, ThesaurusHandler.class);
        OfferEditUI ui = new OfferEditUI(context);

        fillfields(ui, data);

        // Adding in referenciel
        List<OfferEditUI> editUIs = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get());
        if (editUIs == null) {
            editUIs = new ArrayList<OfferEditUI>();
            VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.setContextValue(VradiContext.get(), editUIs);
        }
        VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get()).add(ui);

        initThesaurus(context, ui);

        if (log.isDebugEnabled()) {
            log.debug("There is " + VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get()).size() + " OfferEditUI in referenciel");
        }

        return ui;
    }

    public void initThesaurus(JAXXContext context, OfferEditUI ui) {
        // Remove all thsuaurus
        JPanel thesaurusPanel = ui.getThesaurus();
        thesaurusPanel.removeAll();

        ThesaurusHandler thesaurusHandler = UIHelper.getHandler(context, ThesaurusHandler.class);

        List<String> thesaurusId = VradiHelper.getVradiListThesaurus();

        // Get rootThesaurus
        VradiThesaurusDTO rootThesaurus = null;
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            rootThesaurus = new VradiThesaurusDTO();
            rootThesaurus.fromWikitty(rootTreeNode);
        } catch (TechnicalException e) {
            log.error("Cant get root thesaurus ", e);
            ErrorDialogUI.showError(e);
        }
        // If no properties found and if root dont hav children display root thesaurus
        Collection<VradiThesaurusDTO> thesaurusChildren = rootThesaurus.getChildren();
        List<VradiThesaurusDTO> thesaurusSaved = new ArrayList<VradiThesaurusDTO>();

        if (thesaurusChildren != null && !thesaurusChildren.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("chidren size : " + thesaurusChildren.size());
            }
            // Find saved thesaurus
            if (thesaurusId != null) {
                for (String id : thesaurusId) {
                    VradiThesaurusDTO savedThesaurus = rootThesaurus.findThesaurus(id);
                    if (savedThesaurus != null) {
                        thesaurusSaved.add(savedThesaurus);
                        for (VradiThesaurusDTO child : thesaurusChildren) {
                            // Remove child thesaurus
                            child.removeThesaurusRecursivly(savedThesaurus);
                        }
                    }
                }
            }
            // Display children thesaurus
            for (VradiThesaurusDTO child : thesaurusChildren) {
                thesaurusPanel.add(thesaurusHandler.initUI(context, child, ui.getData(), false));
            }

            // Display saved thesaurus
            for (VradiThesaurusDTO saved : thesaurusSaved) {
                thesaurusPanel.add(thesaurusHandler.initUI(context, saved, ui.getData(), true));
            }
        }
    }

    protected void fillfields(OfferEditUI ui, Form data) {
        // FIXME : to be removed in future version
        for (WikittyExtension ext : data.getExtensions()) {
            if (!ext.equals(ModificationTag.MODIFICATION_TAG)) {
                for (String fieldName : ext.getFieldNames()) {
                    FieldType type = ext.getFieldType(fieldName);
                    createField(ui, ext.getName(), fieldName, type, data);
                }
            }
        }
    }

    protected static Map<String, Class<? extends VradiEditor<?, ?>>> editorMapping;

    protected void createField(OfferEditUI ui, String ext, String fieldName, FieldType type, BusinessEntity data) {
        JPanel content = ui.getContent();
        if (!type.isCollection()) {
            VradiEditor editor = null;
            if (ext.equals(Form.EXT_FORM) && fieldName.equals("id")) {
                editor = new IdEditor(ui);
                ((IdEditor) editor).getWikittyId().setText(data.getWikittyId());
            } else {
                editor = getEditor(type, ui);
            }
            if (editor != null) {
                Object value = data.getField(ext, fieldName);
                if (log.isDebugEnabled()) {
                    log.debug("editor data = [" + editor.getObjectById("data") + "] for value[" + value + "]");
                }
                editor.setFieldName(fieldName);
                editor.setFieldDescription(type.getTagValue(VradiHelper.TYPE_DESCRIPTION));
                editor.setExtensionName(ext);
                editor.setValue(value);
                if (type.isNotNull()) {
                    editor.setValidatorContext(REQUIRED_FIELD_CONTEXT);
                    //editor.setValidatorContext(null);
                    if (log.isDebugEnabled()) {
                        log.debug(fieldName + " is not null");
                    }
                }
                content.add(editor);
            }
        }
    }

    OfferEditUI getUI(JAXXContext context) {
        if (context instanceof OfferEditUI) {
            return (OfferEditUI) context;
        }
//        OfferEditUI ui = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(context);
        return null;
    }

    public void openRequestPopup(JAXXContext context, List<String> queries) {
        RequestFormViewHandler handler = UIHelper.getHandler(context, RequestFormViewHandler.class);
        RequestFormViewUI ui = handler.initUI(context);
        for (String query : queries) {
            ui.getContent().add(new JLabel(query));
        }
        ui.setVisible(true);
    }

    // TODO
    protected void addPropositions(JAXXContext context, Object[] props) {
        for (Object p : props) {
            getUI(context).propositionListModel.removeElement(p);
        }
    }

    protected void save(JAXXContext context, Form form) {
        log.info("Save form " + form.getName());
        // Remove all thesaurus
        form.clearThesaurus();
        // Find all thesaurus selected
        for (Component c : getUI(context).getThesaurus().getComponents()) {
            ThesaurusUI thesaurusUI = (ThesaurusUI) c;
            DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
            Object[] selected = model.toArray();

            for (Object s : selected) {
                TreeNode treeNode = (TreeNode) s;
                log.debug(treeNode.getChildren());
                if (log.isDebugEnabled()) {
                    log.debug("treeNode to save : " + treeNode.getName() + " in form : " + form.getName());
                }
                // Save thesaurus
                form.addThesaurus(treeNode.getWikittyId());
            }
        }

        for (Component c : getUI(context).getContent().getComponents()) {
            VradiEditor editor = (VradiEditor) c;
            form.setField(editor.getExtensionName(), editor.getFieldName(), editor.getValue());
            if (log.isDebugEnabled()) {
                log.debug("field to save : " + editor.getFieldName() + " = " + editor.getValue() + " in form : " + form.getName());
            }
        }

        if (!form.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
            form.addExtension(ModificationTag.MODIFICATION_TAG);
        }
        VradiUser vradiUser = context.getContextValue(VradiUser.class);
        form.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER,
                vradiUser != null ? vradiUser.getName() : null);
        form.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED, new Date());
        try {
            ServiceHelper.getVradiStorageService().updateForm(form);
        } catch (TechnicalException eee) {
            log.error("Cant save form : " + form.getName(), eee);
            ErrorDialogUI.showError(eee);
        }
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void test(JAXXContext context, Form form) {
        List<String> queries = new ArrayList<String>();
        try {
            queries = ServiceHelper.getVradiStorageService().getQueriesReturningForm(form);
        } catch (TechnicalException eee) {
            log.error(eee);
            ErrorDialogUI.showError(eee);
        }
        openRequestPopup(context, queries);
    }

    // TODO
    protected void addFile(JAXXContext context) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.showOpenDialog(getUI(context));

        File file = fileChooser.getSelectedFile();
//        getUI(context).fileList.addItem(new Item(file.getName(), file.getName(), file.getPath(), false));
    }

    // TODO
    protected void removeFile(JAXXContext context) {
//        java.util.List<Item> itemsToRemove = getUI(context).fileList.getSelectedItems();
//        getUI(context).fileList.removeAllItems(itemsToRemove);
    }

    public void addThesaurus(JAXXContext context, VradiThesaurusDTO thesToAdd) {
        for (Component c : getUI(context).getThesaurus().getComponents()) {
            ThesaurusUI ui = (ThesaurusUI) c;
            ThesaurusTreeHelper helper = ui.helper;
            NavigationTreeNode rootNode = helper.getRootNode();
            VradiThesaurusDTO root = (VradiThesaurusDTO) rootNode.getBean();
            log.info("Try to add " + thesToAdd.getName() + " to " + root.getName());
            if (root.addChildRecursif(thesToAdd)) {
                log.info("succes");
                helper.setRootThesaurus(root);
                helper.createTreeModel(context);
                ui.getThesaurus().setModel(helper.getTreeModel(context));
                break;
            }
        }
    }

    protected synchronized VradiEditor getEditor(FieldType type, JAXXContext context) {
        if (editorMapping == null) {
            editorMapping = new TreeMap<String, Class<? extends VradiEditor<?, ?>>>();
            editorMapping.put(FieldTypeEnum.STRING.name(), StringEditor.class);
            editorMapping.put(FieldTypeEnum.DATE_TIME.name(), DateTimeEditor.class);
            editorMapping.put(FieldTypeEnum.DATE.name(), DateEditor.class);
            editorMapping.put(FieldTypeEnum.EMAIL.name(), EmailEditor.class);
            editorMapping.put(FieldTypeEnum.NUMERIC.name(), NumEditor.class);
            editorMapping.put(FieldTypeEnum.TEXT.name(), TextEditor.class);
            editorMapping.put(FieldTypeEnum.URL.name(), UrlEditor.class);
            editorMapping.put(FieldTypeEnum.CURRENCY.name(), CurrencyEditor.class);
            editorMapping.put(DEFAULT_EDITOR_NAME, StringEditor.class);
        }

        FieldTypeEnum typeEnum = FieldTypeEnum.valueOf(type);
        if (log.isDebugEnabled()) {
            log.debug("typeEnum of type " + type + " = " + typeEnum);
        }
        String editorName = typeEnum == null ? DEFAULT_EDITOR_NAME : typeEnum.name();
        if (log.isDebugEnabled()) {
            log.debug("editor name for type [" + type.getType() + "] : " + editorName);
        }

        Class<? extends VradiEditor<?, ?>> editorClass = editorMapping.get(editorName);

        if (log.isDebugEnabled()) {
            log.debug("editor class to use : " + editorClass);
        }
        try {
            Constructor[] constructors = editorClass.getConstructors();
            for (Constructor constructor : constructors) {
                if (constructor.getParameterTypes() != null
                        && constructor.getParameterTypes().length == 1
                        && constructor.getParameterTypes()[0].equals(JAXXContext.class)) {
                    VradiEditor editor = (VradiEditor) constructor.newInstance(context);
                    editor.init();
                    return editor;
                }
            }
            return null;
        } catch (InvocationTargetException eee) {
            // should never happens
            throw new IllegalStateException(eee);
        } catch (InstantiationException eee) {
            // should never happens
            throw new IllegalStateException(eee);
        } catch (IllegalAccessException eee) {
            // should never happens
            throw new IllegalStateException(eee);
        }
    }
}
