/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.entities;

import org.sharengo.wikitty.FieldType;

public enum FieldTypeEnum {
    STRING(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.string", 0, 1),
    TEXT(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.text", 0, 1),
    DATE(FieldType.TYPE.DATE, "vradi.fieldTypeEnum.date", 1, 1),
    DATE_TIME(FieldType.TYPE.DATE, "vradi.fieldTypeEnum.dateTime", 1, 1),
    EMAIL(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.email", 0, 1),
    URL(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.url", 0, 1),
    NUMERIC(FieldType.TYPE.NUMERIC, "vradi.fieldTypeEnum.numeric", 1, 1),
    CURRENCY(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.currency", 0, 1);

    public static final String CURRENCY_TAG_VALUE = "currency";
    protected String TAG_VALUE = "use";
    protected String tagValue;
    protected FieldType type;

    private FieldTypeEnum(FieldType.TYPE type, String tagValue, int min, int max) {
        this.tagValue = tagValue;
        this.type = new FieldType(type, min, max);
        this.type.addTagValue(this.TAG_VALUE, tagValue);
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public FieldType getFieldType() {
        FieldType result = new FieldType(this.type.getType(), this.type.getLowerBound(), this.type.getUpperBound());
        result.addTagValue(this.TAG_VALUE, this.tagValue);
        return result;
    }

    public boolean isType(FieldType type) {
        return this.tagValue.equals(type.getTagValue(this.TAG_VALUE));
    }

    public String toString() {
        return this.getTagValue();
    }

    public static FieldTypeEnum valueOf(FieldType type) {
        FieldTypeEnum e = DATE_TIME.isType(type) ? DATE_TIME : (DATE.isType(type) || FieldType.TYPE.DATE.equals((Object)type.getType()) ? DATE : (EMAIL.isType(type) ? EMAIL : (CURRENCY.isType(type) ? CURRENCY : (NUMERIC.isType(type) || FieldType.TYPE.NUMERIC.equals((Object)type.getType()) ? NUMERIC : (TEXT.isType(type) ? TEXT : (URL.isType(type) ? URL : STRING))))));
        return e;
    }

    public static Currency getCurrency(String value) {
        if ("vradi.currency.euro".equals(value)) {
            return Currency.EUR;
        }
        if ("vradi.currency.usd".equals(value)) {
            return Currency.USD;
        }
        if ("vradi.currency.gbp".equals(value)) {
            return Currency.GBP;
        }
        return null;
    }

    public static enum Currency {
        EUR("vradi.currency.euro"),
        USD("vradi.currency.usd"),
        GBP("vradi.currency.gbp");

        private String name;

        private Currency(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

